/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.dialogues;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.ui.components.TemplateReferenceListUIComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SelectTemplateDialogue
extends Dialog {
    private static final String NONE_NAME = "<none>";
    final TemplateManager templateManager;
    TemplateReference templateReference;
    private UUID templateID;
    private boolean enableNoneEntry;
    final SessionToken session;
    String pluginID;
    private final Filter filter;
    private final Filter statusFilter;
    private final String title;
    private final String description;

    public SelectTemplateDialogue(SessionToken session, Shell parentShell, String pluginID, TemplateManager templateManager, String title, String description, UUID templateID, boolean enableNoneEntry, Filter filter, Filter statusFilter) {
        super(parentShell);
        this.title = title;
        this.description = description;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.session = session;
        this.pluginID = pluginID;
        this.templateManager = templateManager;
        this.templateID = templateID;
        this.enableNoneEntry = enableNoneEntry;
        this.filter = filter;
        this.statusFilter = statusFilter;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setSize(600, 400);
    }

    protected Control createDialogArea(Composite parent) {
        String dialogueTitle = this.title != null ? this.title : "Select process template";
        this.getShell().setText(dialogueTitle);
        final ArrayList<TemplateReference> templates = new ArrayList<TemplateReference>(this.templateManager.findTemplates(this.session, this.filter, this.statusFilter));
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Composite container = toolkit.createComposite(parent, 2048);
        GridLayout containerLayout = new GridLayout(1, false);
        containerLayout.marginWidth = 15;
        containerLayout.marginHeight = 15;
        containerLayout.horizontalSpacing = 10;
        containerLayout.verticalSpacing = 7;
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.description != null) {
            Label label = toolkit.createLabel(container, this.description, 64);
            label.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        final TemplateReferenceListUIComponent viewer = new TemplateReferenceListUIComponent(container, 0);
        viewer.initColumns(null, new String[]{"id"}, "name", true);
        Table columnControl = (Table)viewer.getColumnControl();
        columnControl.setLinesVisible(true);
        columnControl.setHeaderVisible(true);
        if (this.enableNoneEntry) {
            templates.add(new TemplateReference(){

                @Override
                public boolean areInstancesChangeable(boolean subprocessScope) {
                    return false;
                }

                @Override
                public boolean areInstancesMigratableTo(boolean subprocessScope) {
                    return false;
                }

                @Override
                public ProcessConstants.TemplateBuildtimeState getBuildtimeState() {
                    return null;
                }

                @Override
                public String getDescription() {
                    return "";
                }

                @Override
                public UUID getID() {
                    return UUID.randomUUID();
                }

                @Override
                public Set<ProcessModelParameter> getInputParameters() {
                    return Collections.emptySet();
                }

                @Override
                public String getName() {
                    return SelectTemplateDialogue.NONE_NAME;
                }

                @Override
                public Set<ProcessModelParameter> getOutputParameters() {
                    return Collections.emptySet();
                }

                @Override
                public String getProcessType() {
                    return "";
                }

                @Override
                public QualifiedAgent getSupervisorAgent() {
                    return new QualifiedAgent(0L, SelectTemplateDialogue.NONE_NAME, 0L, SelectTemplateDialogue.NONE_NAME);
                }

                @Override
                public ProcessConstants.TemplateUsage getUsageAsSubprocess() {
                    return ProcessConstants.TemplateUsage.NO_SUBPROCESS;
                }

                @Override
                public String getVersion() {
                    return "";
                }

                @Override
                public boolean isDerivable() {
                    return false;
                }

                @Override
                public boolean isInstantiable(boolean subprocessScope) {
                    return false;
                }

                @Override
                public boolean isOutdated(boolean subprocessScope) {
                    return false;
                }

                @Override
                public boolean isTopLevelUsable() {
                    return false;
                }

                @Override
                public String getUserAttributeValue(String attributeName) {
                    return "";
                }

                @Override
                public Map<String, String> getUserAttributes() {
                    return Collections.emptyMap();
                }

                @Override
                public void removeUserAttributeValue(String attributeName) {
                }

                @Override
                public void setUserAttributeValue(String attributeName, String attributeValue) {
                }

                @Override
                public PluginData getPluginData(String pluginID) {
                    return new DefaultPluginData(pluginID);
                }

                @Override
                public Map<String, PluginData> getPluginDatas() {
                    return Collections.emptyMap();
                }

                @Override
                public Map<String, Set<String>> getSupportedPlugins() {
                    return Collections.emptyMap();
                }
            });
        }
        viewer.setInput(templates);
        GridData layout = new GridData(4, 4, true, true);
        layout.widthHint = 500;
        layout.heightHint = 300;
        viewer.getControl().setLayoutData((Object)layout);
        this.packTableColumns(columnControl);
        viewer.getColumnViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    SelectTemplateDialogue.this.templateReference = (TemplateReference)sel.getFirstElement();
                    SelectTemplateDialogue.this.enableButton(0, true);
                } else {
                    SelectTemplateDialogue.this.enableButton(0, false);
                }
            }
        });
        viewer.getColumnViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                SelectTemplateDialogue.this.templateReference = (TemplateReference)sel.getFirstElement();
                SelectTemplateDialogue.this.setReturnCode(0);
                SelectTemplateDialogue.this.close();
            }
        });
        toolkit.paintBordersFor(container);
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (TemplateReference templateRef : templates) {
                    if ((!templateRef.getName().equals(SelectTemplateDialogue.NONE_NAME) || SelectTemplateDialogue.this.templateID != null) && !templateRef.getID().equals(SelectTemplateDialogue.this.templateID)) continue;
                    viewer.getColumnViewer().setSelection((ISelection)new StructuredSelection((Object)templateRef));
                }
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.enableButton(0, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void enableButton(int buttonID, boolean enable) {
        this.getButton(buttonID).setEnabled(enable);
    }

    public TemplateReference getTemplateReference() {
        if (this.templateReference == null || this.templateReference.getName().equals(NONE_NAME)) {
            return null;
        }
        return this.templateReference;
    }

    void packTableColumns(Table table) {
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumn(i).pack();
            ++i;
        }
    }
}

