/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.guimanager;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.runtimemanager.ExecutionControlManager;
import de.aristaflow.adept2.core.runtimemanager.gui.AbstractGUIManager;
import de.aristaflow.adept2.core.runtimemanager.gui.GUIContextUnavailableException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.GUIContext;
import de.aristaflow.adept2.ui.htmlgui.RemoteHTMLContext;
import de.aristaflow.adept2.ui.htmlgui.httpservice.HTTPService;
import de.aristaflow.adept2.ui.nullgui.NullGUIContext;
import java.net.MalformedURLException;
import org.apache.commons.configuration.Configuration;

public class RemoteHTMLGUIManager
extends AbstractGUIManager {
    public RemoteHTMLGUIManager(Configuration configuration, Registry registry) {
        super(configuration, registry, new String[0], new String[]{"HTTPService"});
    }

    @Override
    public GUIContext getGUIContext(SessionToken session, ActivityInstance activityInstance, EBPInstanceReference ebpInstanceReference, String sessionID, ExecutionContext executionContext, ExecutionControlManager executionControlManager, Thread thread) throws GUIContextUnavailableException {
        GUIContext ret;
        String reqGuiContext = activityInstance.getGUIContextID();
        if (reqGuiContext != null) {
            if (reqGuiContext.equals("HTMLContext")) {
                HTTPService httpService;
                try {
                    httpService = this.registry.getServiceOfType(session, "HTTPService", HTTPService.class);
                }
                catch (ServiceNotKnownException snke) {
                    String msg = "No HTTP service available. This is ususally caused by a wrong client configuration. Could not create GUI context '%s' for session '%s'.";
                    msg = String.format(msg, reqGuiContext, sessionID);
                    throw new GUIContextUnavailableException(this.getClass().getName(), msg, snke);
                }
                ret = new RemoteHTMLContext(thread, session, httpService, sessionID, activityInstance, ebpInstanceReference, executionContext);
                try {
                    httpService.registerReplyHandler(session, sessionID, (RemoteHTMLContext)ret);
                }
                catch (MalformedURLException e) {
                    String msg = "SessionID '%1$s' is not a valid URL-string! Can not create requested %2$s.";
                    msg = String.format(msg, sessionID, reqGuiContext);
                    this.logger.severe(msg);
                    throw new GUIContextUnavailableException(this.getClass().getName(), msg, e);
                }
            }
            ret = new NullGUIContext();
        } else {
            ret = new NullGUIContext();
        }
        return ret;
    }
}

