/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.htmlgui;

import de.aristaflow.adept2.model.runtimeenvironment.InvalidExecutorThreadException;
import de.aristaflow.adept2.ui.htmlgui.HTMLContext;
import de.aristaflow.adept2.ui.htmlgui.httpservice.HTTPReplyHandler;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractHTMLContext
implements HTMLContext,
HTTPReplyHandler {
    public static final HTMLContext.Response DEFAULT_FINAL_RESPONSE = new HTMLContext.Response(410, "text/html", "<html><head><title>Activity closed!</title></head><body>The activity is not running any more. You can close this window now. <br />If you have not finished the activity yet, please check its state in your worklist.</body></html>");
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final Thread thread;
    protected URL baseURL;
    protected HTMLContext.Response initialContent;
    protected final Map<HTMLContext.HTTPReply, CountDownLatch> replies;
    protected final Map<HTMLContext.HTTPReply, HTMLContext.Response> responses;
    protected HTMLContext.Response finalResponse;
    protected volatile boolean replyHandlerTerminated;

    public AbstractHTMLContext(Thread thread) {
        this.thread = thread;
        this.initialContent = null;
        this.replies = new LinkedHashMap<HTMLContext.HTTPReply, CountDownLatch>();
        this.responses = new HashMap<HTMLContext.HTTPReply, HTMLContext.Response>();
        this.finalResponse = null;
        this.replyHandlerTerminated = false;
    }

    @Override
    public URL getURL() {
        this.checkForValidExecutorThread();
        return this.baseURL;
    }

    @Override
    @Deprecated
    public URL getURL(String query) {
        this.checkForValidExecutorThread();
        URL ret = this.baseURL;
        try {
            ret = new URL(this.baseURL + "?" + query);
        }
        catch (MalformedURLException mue) {
            String msg = String.format("Query '%1$s' is UTF-8 encoded '%2$s' but still not a valid URI", ret, query);
            this.logger.log(Level.SEVERE, msg, mue);
        }
        return ret;
    }

    @Override
    public URL getURL(Map<String, String> query) {
        URL ret = this.baseURL;
        StringBuffer queryString = new StringBuffer("?");
        try {
            int i = 0;
            for (Map.Entry<String, String> entry : query.entrySet()) {
                String encKey = URLEncoder.encode(entry.getKey(), "UTF-8");
                String encValue = URLEncoder.encode(entry.getValue(), "UTF-8");
                queryString.append(encKey).append('=').append(encValue);
                if (i < query.size() - 1) {
                    queryString.append('&');
                }
                ++i;
            }
            ret = new URL(this.baseURL + queryString.toString());
        }
        catch (UnsupportedEncodingException uee) {
            this.logger.log(Level.SEVERE, "URL can not be UTF-8-encoded! Check your JVM installation.", uee);
        }
        catch (MalformedURLException mue) {
            String msg = String.format("Query '%1$s' is UTF-8 encoded '%2$s' but still not a valid URI", ret, queryString);
            this.logger.log(Level.SEVERE, msg, mue);
        }
        return ret;
    }

    @Override
    public void setInitialContent(String initialContent) {
        this.checkForValidExecutorThread();
        this.initialContent = new HTMLContext.Response(202, "text/html", initialContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setResponse(HTMLContext.Response response) {
        this.checkForValidExecutorThread();
        if (!this.replyHandlerTerminated) {
            Map<HTMLContext.HTTPReply, CountDownLatch> map = this.replies;
            synchronized (map) {
                Iterator<HTMLContext.HTTPReply> it = this.replies.keySet().iterator();
                if (it.hasNext()) {
                    this.logger.info("HTMLContext#setResponse(Response) is deprecated, please use HTMLContext#setResponse(HTTPReply, Response) instead for a correct correlation of the reply and response. I assign the first retrieved pending reply to the response now.");
                    this.setResponse(it.next(), response);
                } else {
                    this.logger.warning("HTMLContext#setResponse(Response) is deprecated, please use HTMLContext#setResponse(HTTPReply, Response) instead for a correct correlation of the reply or HTMLContext#setFinalResponse(Response) if finishing without a causing reply. Since there is no pending reply I set the final response now.");
                    this.setFinalResponse(response);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(HTMLContext.HTTPReply reply, HTMLContext.Response response) {
        this.checkForValidExecutorThread();
        ArgChecks.checkForNull(reply, "reply");
        if (!this.replyHandlerTerminated) {
            Map<HTMLContext.HTTPReply, Object> map = this.responses;
            synchronized (map) {
                this.responses.put(reply, response);
            }
            map = this.replies;
            synchronized (map) {
                CountDownLatch replyPresent = this.replies.remove(reply);
                replyPresent.countDown();
            }
        }
    }

    public void setFinalResponse(HTMLContext.Response response) {
        this.setFinalResponse(response, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setFinalResponse(HTMLContext.Response response, boolean checkThread) {
        if (checkThread) {
            this.checkForValidExecutorThread();
        }
        ArgChecks.checkForNull(response, "response");
        if (!this.replyHandlerTerminated) {
            Map<HTMLContext.HTTPReply, CountDownLatch> map = this.replies;
            synchronized (map) {
                this.replyHandlerTerminated = true;
                this.finalResponse = response;
            }
            Iterator<Map.Entry<HTMLContext.HTTPReply, CountDownLatch>> it = this.replies.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<HTMLContext.HTTPReply, CountDownLatch> respHandler = it.next();
                Map<HTMLContext.HTTPReply, HTMLContext.Response> map2 = this.responses;
                synchronized (map2) {
                    this.responses.put(respHandler.getKey(), response);
                }
                respHandler.getValue().countDown();
                it.remove();
            }
        }
    }

    @Override
    @Deprecated
    public Map<String, String> waitForReply() throws InterruptedException {
        return this.waitForHTTPReply().getParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public HTMLContext.HTTPReply waitForHTTPReply() throws InterruptedException {
        this.checkForValidExecutorThread();
        Map<HTMLContext.HTTPReply, CountDownLatch> map = this.replies;
        synchronized (map) {
            while (this.replies.size() <= 0 && !this.replyHandlerTerminated) {
                this.replies.wait();
            }
            return this.replyHandlerTerminated ? null : this.replies.keySet().iterator().next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLContext.HTTPReply waitForHTTPReply(long timeout) throws InterruptedException {
        this.checkForValidExecutorThread();
        Map<HTMLContext.HTTPReply, CountDownLatch> map = this.replies;
        synchronized (map) {
            boolean timedOut = false;
            while (this.replies.size() <= 0 && !timedOut && !this.replyHandlerTerminated) {
                long waitStart = System.currentTimeMillis();
                this.replies.wait(timeout);
                boolean bl = timedOut = System.currentTimeMillis() - waitStart > timeout;
            }
            return timedOut || this.replyHandlerTerminated ? null : this.replies.keySet().iterator().next();
        }
    }

    protected void checkForValidExecutorThread() {
        if (!Thread.currentThread().equals(this.thread)) {
            throw new InvalidExecutorThreadException();
        }
    }

    @Override
    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLContext.Response getResponse(HTMLContext.HTTPReply reply) throws InterruptedException {
        boolean terminated;
        ArgChecks.checkForNull(reply, "reply");
        if (this.initialContent != null) {
            HTMLContext.Response ret = this.initialContent;
            this.initialContent = null;
            return ret;
        }
        CountDownLatch replyPresent = new CountDownLatch(1);
        Map<HTMLContext.HTTPReply, Object> map = this.replies;
        synchronized (map) {
            terminated = this.replyHandlerTerminated;
            if (!terminated) {
                this.replies.put(reply, replyPresent);
            }
        }
        if (terminated) {
            return this.finalResponse;
        }
        map = this.replies;
        synchronized (map) {
            this.replies.notify();
        }
        replyPresent.await();
        map = this.responses;
        synchronized (map) {
            return this.responses.remove(reply);
        }
    }
}

