/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.htmlgui;

import de.aristaflow.adept2.model.runtimeenvironment.GUIContext;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface HTMLContext
extends GUIContext {
    public URL getURL();

    @Deprecated
    public URL getURL(String var1);

    public URL getURL(Map<String, String> var1);

    public void setInitialContent(String var1);

    public void setResponse(Response var1);

    @Deprecated
    public Map<String, String> waitForReply() throws InterruptedException;

    public HTTPReply waitForHTTPReply() throws InterruptedException;

    public static class Attachment {
        protected final String contentType;
        protected final long size;
        protected final InputStream data;
        protected final String fileName;
        protected final Map<String, String> headerData;

        public Attachment(String contentType, InputStream data, long size, String fileName, Map<String, String> headerData) {
            ArgChecks.checkForBlank(contentType, "contentType");
            ArgChecks.checkForNull(data, "data");
            ArgChecks.checkForNull(headerData, "headerData");
            this.contentType = contentType;
            this.size = size;
            this.data = data;
            this.fileName = fileName;
            this.headerData = Collections.unmodifiableMap(headerData);
        }

        public String getContentType() {
            return this.contentType;
        }

        public long getSize() {
            return this.size;
        }

        public InputStream getData() {
            return this.data;
        }

        public String getFileName() {
            return this.fileName;
        }

        public Map<String, String> getHeaderData() {
            return this.headerData;
        }
    }

    public static class HTTPReply {
        protected final Map<String, List<Attachment>> attachmentLists;
        protected final Map<String, Attachment> attachments;
        protected final Map<String, List<String>> parameterLists;
        protected final Map<String, String> parameters;

        public HTTPReply(Map<String, String> parameters, Map<String, Attachment> attachments, Map<String, List<String>> parameterLists, Map<String, List<Attachment>> attachmentLists) {
            ArgChecks.checkForNull(parameters, "parameters");
            ArgChecks.checkForNull(attachments, "attachments");
            ArgChecks.checkForNull(parameterLists, "parameterLists");
            ArgChecks.checkForNull(attachmentLists, "attachmentLists");
            this.parameters = Collections.unmodifiableMap(parameters);
            this.attachments = Collections.unmodifiableMap(attachments);
            HashMap<String, List<String>> pls = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> entry : parameterLists.entrySet()) {
                pls.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
            }
            this.parameterLists = pls;
            HashMap<String, List<Attachment>> als = new HashMap<String, List<Attachment>>();
            for (Map.Entry<String, List<Attachment>> entry : attachmentLists.entrySet()) {
                als.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
            }
            this.attachmentLists = als;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public Map<String, Attachment> getAttachments() {
            return this.attachments;
        }

        public Map<String, List<String>> getParameterLists() {
            return this.parameterLists;
        }

        public Map<String, List<Attachment>> getAttachmentLists() {
            return this.attachmentLists;
        }
    }

    public static class Response {
        protected int status;
        protected String mimeType;
        protected InputStream data;
        protected Map<String, String> header = new HashMap<String, String>();

        public Response(int status, String origMimeType, InputStream data) {
            String mimeType = origMimeType;
            this.status = status;
            if (mimeType == null) {
                mimeType = "text/plain";
            }
            this.mimeType = mimeType;
            this.data = data;
        }

        public Response(int status, String mimeType, String txt) {
            this(status, mimeType, Response.toStream(txt));
            if (!this.mimeType.trim().toLowerCase().endsWith("utf-8")) {
                this.mimeType = String.valueOf(this.mimeType) + "; charset=utf-8";
            }
        }

        public void addHeader(String name, String value) {
            this.header.put(name, value);
        }

        public int getStatus() {
            return this.status;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public InputStream getData() {
            return this.data;
        }

        public Map<String, String> getHeader() {
            return this.header;
        }

        private static InputStream toStream(String txt) {
            try {
                return new ByteArrayInputStream(txt.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)"UTF-8 encoding not supported!");
            }
        }

        public static class MimeType {
            public static final String MIME_PLAINTEXT = "text/plain";
            public static final String MIME_HTML = "text/html";
            public static final String MIME_XML = "text/xml";
            public static final String MIME_DEFAULT_BINARY = "application/octet-stream";
            public static final String MIME_PDF = "application/pdf";
        }
    }
}

