/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.htmlgui.httpservice;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.ui.htmlgui.HTMLContext;
import de.aristaflow.adept2.ui.htmlgui.httpservice.HTTPReplyHandler;
import de.aristaflow.adept2.ui.htmlgui.httpservice.HTTPService;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.UUIDTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class AristaFlowHTTPService
extends HttpServlet
implements HTTPService {
    private static final long serialVersionUID = 4678863733756598946L;
    private URL myURL;
    private final Logger logger = LoggerTools.getLogger(this);
    protected final Map<String, HTTPReplyHandler> replyHandlers = Collections.synchronizedMap(new HashMap());
    protected final Map<UUID, String> sessions = Collections.synchronizedMap(new HashMap());
    private transient ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());

    public AristaFlowHTTPService() {
        this.fileUpload.setHeaderEncoding("UTF-8");
    }

    public void setURL(URL myURL) {
        this.myURL = myURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HTMLContext.Response activityResponse;
        Map<String, List<String>> parameterLists;
        Map<String, String> reply;
        HTTPReplyHandler handler;
        String sessionID;
        UUID id;
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        String requestURL = request.getRequestURL().toString();
        this.logger.fine(String.format("Request retrieved, multipart=%s, URL=%s, remoteHost=%s, remoteAddress=%s", isMultipart, requestURL, request.getRemoteHost(), request.getRemoteAddr()));
        requestURL = new URL(requestURL).getPath();
        String[] pathSegments = requestURL.split("/");
        String idString = pathSegments[pathSegments.length - 1];
        try {
            id = UUID.fromString(idString);
        }
        catch (IllegalArgumentException e) {
            this.logger.info(String.format("Unable to parse ID from path element '%s', message: %s.", pathSegments[pathSegments.length - 1], e.getMessage()));
            response.sendError(500, e.getMessage());
            return;
        }
        Map<String, HTTPReplyHandler> map = this.replyHandlers;
        synchronized (map) {
            sessionID = this.sessions.get(id);
            if (!this.replyHandlers.containsKey(sessionID)) {
                response.getWriter().print(String.format("Session ID '%s' unknown!", sessionID));
                return;
            }
            handler = this.replyHandlers.get(sessionID);
        }
        HashMap<String, HTMLContext.Attachment> attachments = new HashMap<String, HTMLContext.Attachment>();
        HashMap<String, List<HTMLContext.Attachment>> attachmentLists = new HashMap<String, List<HTMLContext.Attachment>>();
        if (isMultipart) {
            List items;
            try {
                items = this.fileUpload.parseRequest(request);
            }
            catch (FileUploadException e) {
                String message = "Unable to parse attachments! Declining request.";
                this.logger.log(Level.SEVERE, message, e);
                response.sendError(500, String.valueOf(message) + e.getMessage());
                return;
            }
            reply = this.getParameters(items);
            parameterLists = this.getParameterLists(items);
            this.getParameterAttachments(items, attachments, attachmentLists);
        } else {
            reply = this.getParameters(request);
            parameterLists = this.getParameterLists(request);
        }
        this.logger.finest(String.format("Parameters of request of session %s: %s.", sessionID, reply));
        this.logger.finest(String.format("List parameters of request of session %s: %s.", sessionID, parameterLists));
        this.logger.finest(String.format("Attachments of request of session %s: %s.", sessionID, attachments));
        this.logger.finest(String.format("List attachments of request of session %s: %s.", sessionID, attachmentLists));
        HTMLContext.HTTPReply httpReply = new HTMLContext.HTTPReply(reply, attachments, parameterLists, attachmentLists);
        try {
            activityResponse = handler.getResponse(httpReply);
        }
        catch (InterruptedException ie) {
            String message = String.format("Interrupted while waiting for reply for session with id %s!", sessionID);
            this.logger.log(Level.WARNING, message, ie);
            response.getWriter().print(String.valueOf(message) + "\n");
            ie.printStackTrace(response.getWriter());
            return;
        }
        Map<String, String> headers = activityResponse.getHeader();
        this.logger.finest(String.format("Retrieved response for session %s. Mime type is '%s'. Going to write following headers: %s.", sessionID, activityResponse.getMimeType(), headers));
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("location".equalsIgnoreCase(key)) {
                response.sendRedirect(value);
                return;
            }
            response.setHeader(key, value);
        }
        response.setContentType(activityResponse.getMimeType());
        this.logger.finest(String.format("Writing data for session %s...", sessionID));
        InputStream data = activityResponse.getData();
        byte[] b = new byte[1024];
        int r = data.read(b);
        ServletOutputStream outputStream = response.getOutputStream();
        while (r > 0) {
            outputStream.write(b, 0, r);
            outputStream.flush();
            r = data.read(b);
        }
        outputStream.flush();
        this.logger.finest(String.format(".. finished writing data for session %s.", sessionID));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterReplyHandler(SessionToken session, String sessionID) {
        Map<String, HTTPReplyHandler> map = this.replyHandlers;
        synchronized (map) {
            this.replyHandlers.remove(sessionID);
            HashSet<UUID> removedSessions = new HashSet<UUID>();
            for (Map.Entry<UUID, String> sessionIDs : this.sessions.entrySet()) {
                if (!sessionIDs.getValue().equals(sessionID)) continue;
                removedSessions.add(sessionIDs.getKey());
            }
            for (UUID removeSession : removedSessions) {
                this.sessions.remove(removeSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerReplyHandler(SessionToken session, String sessionID, HTTPReplyHandler replyHandler) throws MalformedURLException {
        Map<String, HTTPReplyHandler> map = this.replyHandlers;
        synchronized (map) {
            UUID id = UUIDTools.createRandomUUID();
            this.sessions.put(id, sessionID);
            URL url = new URL(this.myURL, id.toString());
            this.logger.info(String.format("Using '%s' as reply URL.", url));
            replyHandler.setBaseURL(url);
            this.replyHandlers.put(sessionID, replyHandler);
        }
    }

    protected Map<String, String> getParameters(HttpServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            Object o = entry.getValue();
            String stringValue = this.getStringValue(o);
            if (stringValue == null) continue;
            result.put((String)entry.getKey(), stringValue);
        }
        return result;
    }

    protected Map<String, List<String>> getParameterLists(HttpServletRequest request) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            Object o = entry.getValue();
            List<String> listValue = this.getListValue(o);
            if (listValue == null) continue;
            result.put((String)entry.getKey(), listValue);
        }
        return result;
    }

    protected Map<String, String> getParameters(List<FileItem> items) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> listValuedFields = new HashSet<String>();
        for (FileItem item : items) {
            if (!item.isFormField()) continue;
            String stringValue = this.getStringValue(item.get());
            String fieldName = item.getFieldName();
            if (result.containsKey(fieldName) || listValuedFields.contains(fieldName)) {
                listValuedFields.add(fieldName);
                result.remove(fieldName);
                continue;
            }
            result.put(fieldName, stringValue);
        }
        return result;
    }

    protected Map<String, List<String>> getParameterLists(List<FileItem> items) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        HashSet<String> listValuedFields = new HashSet<String>();
        for (FileItem item : items) {
            List<String> stringValueList;
            if (!item.isFormField()) continue;
            String stringValue = this.getStringValue(item.get());
            String fieldName = item.getFieldName();
            if (result.containsKey(fieldName)) {
                listValuedFields.add(fieldName);
            }
            if (result.containsKey(fieldName)) {
                stringValueList = (List)result.get(fieldName);
            } else {
                stringValueList = new LinkedList();
                result.put(fieldName, stringValueList);
            }
            stringValueList.add(stringValue);
        }
        result.keySet().retainAll(listValuedFields);
        return result;
    }

    protected void getParameterAttachments(List<FileItem> items, Map<String, HTMLContext.Attachment> attachments, Map<String, List<HTMLContext.Attachment>> attachmentLists) {
        HashSet<String> listValuedFields = new HashSet<String>();
        for (FileItem item : items) {
            List<Object> list;
            String oldFileName;
            InputStream inputStream;
            if (item.isFormField()) continue;
            String name = item.getFieldName();
            String fileName = item.getName();
            String contentType = item.getContentType();
            try {
                inputStream = item.getInputStream();
            }
            catch (IOException e) {
                String message = String.format("Could not retrieve the stream for uploaded file '%s', skipping!", fileName);
                this.logger.log(Level.SEVERE, message, e);
                continue;
            }
            long size = item.getSize();
            if (fileName.length() > 0 && fileName.lastIndexOf(92) + 1 > fileName.length()) {
                oldFileName = fileName;
                fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
                this.logger.info(String.format("Removed path from the file name '%s', new name is '%s'.", oldFileName, fileName));
            } else if (fileName.length() > 0 && fileName.lastIndexOf(47) + 1 > fileName.length()) {
                oldFileName = fileName;
                fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                this.logger.info(String.format("Removed path from the file name '%s', new name is '%s'.", oldFileName, fileName));
            }
            if (attachments.containsKey(name)) {
                listValuedFields.add(name);
            }
            HTMLContext.Attachment attachment = new HTMLContext.Attachment(contentType, inputStream, size, fileName, new HashMap<String, String>());
            attachments.put(name, attachment);
            if (attachmentLists.containsKey(name)) {
                list = attachmentLists.get(name);
            } else {
                list = new LinkedList();
                attachmentLists.put(name, list);
            }
            list.add(attachment);
        }
        attachmentLists.keySet().retainAll(listValuedFields);
        attachments.keySet().removeAll(listValuedFields);
    }

    protected String getStringValue(Object o) {
        String value;
        if (o instanceof byte[]) {
            try {
                value = new String((byte[])o, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.log(Level.SEVERE, "Unable to encode to string!", e);
                value = null;
            }
            this.logger.info(String.format("Found parameter of type byte[], converted as UTF-8 to '%s'.", value));
        } else if (o instanceof String[]) {
            if (((String[])o).length == 1) {
                value = ((String[])o)[0];
                this.logger.finest(String.format("Parameter is of type String[]: '%s'.", value));
            } else {
                value = null;
                this.logger.info(String.format("Parameter is of type String[], but with length %d. Returning null instead.", ((String[])o).length));
            }
        } else if (o instanceof String) {
            value = (String)o;
            this.logger.finest(String.format("Parameter is of type String: '%s'.", value));
        } else {
            this.logger.warning(String.format("Parameter is of type %s and can't be handled! Ignoring!", o.getClass()));
            value = null;
        }
        return value;
    }

    protected List<String> getListValue(Object o) {
        ArrayList<String> result;
        if (o instanceof String[] && ((String[])o).length > 1) {
            String[] s = (String[])o;
            result = new ArrayList(s.length);
            Collections.addAll(result, s);
        } else if (o instanceof List) {
            List l = (List)o;
            result = new ArrayList<String>(l.size());
            for (Object lo : l) {
                String stringValue = this.getStringValue(lo);
                if (stringValue == null) continue;
                result.add(stringValue);
            }
        } else {
            result = null;
        }
        return result;
    }

    private void readObject(ObjectInputStream in) {
        this.fileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
    }

    @Override
    public void emergencyShutdown() {
    }

    @Override
    public String[] getRuntimeRequiredServices() {
        return new String[0];
    }

    @Override
    public String[] getStartupRequiredServices() {
        return new String[0];
    }

    @Override
    public URI[] getURIs() {
        return new URI[0];
    }

    @Override
    public void init(URI[] exportedURIs) {
    }

    @Override
    public boolean ping() {
        return true;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void start() {
    }
}

