/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.htmlgui.httpservice;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.ui.htmlgui.httpservice.AristaFlowHTTPService;
import de.aristaflow.adept2.ui.htmlgui.httpservice.HTTPReplyHandler;
import de.aristaflow.adept2.ui.htmlgui.httpservice.HTTPService;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.Servlet;
import org.apache.commons.configuration.Configuration;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.log.Log;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

@ConfigurationDescription(properties={@Property(name="ThreadCount", type=Property.Type.INT, defaultValue="100", description="The amount of concurrent requests this HTTP-service canhandle."), @Property(name="Port", type=Property.Type.INT, defaultValue="0", description="The port on which this HTTP-service will listen. Usually a random port will be picked for not interfering with other applications."), @Property(name="IPAddress", type=Property.Type.STRING, description="Specifies the address of this HTTP-service. This is needed to set the right network interface, if e.g. there is more than one network interface card. If the designated address is not registered on the actual machine a configuration exception is thrown. If nothing is provided, the default address of the actual machine will be used."), @Property(name="Localhost", type=Property.Type.BOOLEAN, defaultValue="false", description="This property is used to signal, if localhost, i.e. 127.0.0.1, should be used as address. If nothing is provided, false will be assumed.")})
public class JettyHTTPD
extends AbstractADEPT2Service
implements HTTPService {
    public static final String PROPERTY_THREAD_COUNT = "ThreadCount";
    public static final String PROPERTY_PORT = "Port";
    public static final String PROPERTY_IP_ADDRESS = "IPAddress";
    public static final String PROPERTY_LOCALHOST_FLAG = "Localhost";
    protected int myTcpPort;
    protected int threadCount;
    protected String serverHost = null;
    protected URL myURL;
    protected Server jetty;
    protected Connector connector;
    private AristaFlowHTTPService httpService;

    public JettyHTTPD(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry);
        this.threadCount = configuration.getInt(PROPERTY_THREAD_COUNT);
        try {
            String infoMessage = "Configure Jetty...";
            this.logger.info(infoMessage);
            boolean localhost = configuration.getBoolean(PROPERTY_LOCALHOST_FLAG);
            infoMessage = String.format("Set localhost flag to '%s'.", localhost);
            this.logger.info(infoMessage);
            this.myTcpPort = configuration.getInt(PROPERTY_PORT);
            String ipAddress = configuration.getString(PROPERTY_IP_ADDRESS);
            if (localhost) {
                this.serverHost = "localhost";
                infoMessage = String.format("Localhost flag was set to 'TRUE', so set serverHostIP to '%s'!", this.serverHost);
                this.logger.info(infoMessage);
            } else if (ipAddress != null && ipAddress.trim().length() != 0) {
                this.serverHost = ipAddress;
                if (this.isRemoteAddress(this.serverHost)) {
                    throw new ConfigurationException("The ip address specified in the configuration is not from the actual machine! Cancelling execution!");
                }
                infoMessage = String.format("Set serverHostIP to '%s' as configured!", this.serverHost);
                this.logger.info(infoMessage);
            } else {
                this.serverHost = InetAddress.getLocalHost().getHostAddress();
                infoMessage = String.format("No serverHostIP was configured and localhost flag was not set, so set serverHostIP to default value '%s'!", this.serverHost);
                this.logger.info(infoMessage);
            }
            infoMessage = "Configure TCP_IP_Invocation_CommunicationService... done.";
            this.logger.info(infoMessage);
        }
        catch (UnknownHostException e) {
            throw new ConfigurationException("Hostname couldn't be resolved! Cancelling execution!", e);
        }
        catch (SocketException se) {
            throw new ConfigurationException("Network interfaces couldn't be resolved! Cancelling execution!", se);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("NumberFormatException for Port: specified value is not of type int! Cancelling execution!", e);
        }
    }

    private boolean isRemoteAddress(String hostString) throws SocketException {
        InetAddress ipToCheck;
        try {
            ipToCheck = InetAddress.getByName(hostString);
        }
        catch (UnknownHostException unknownHostException) {
            this.logger.severe("Unable to resolve configured host string: " + hostString);
            return true;
        }
        boolean remoteAddress = true;
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        block2: while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements() && remoteAddress) {
                InetAddress ia = addresses.nextElement();
                if (!ia.equals(ipToCheck)) continue;
                remoteAddress = false;
                continue block2;
            }
        }
        return remoteAddress;
    }

    @Override
    public void registerReplyHandler(SessionToken session, String sessionID, HTTPReplyHandler replayHandler) throws MalformedURLException {
        super.sessionActive(session);
        try {
            this.httpService.registerReplyHandler(session, sessionID, replayHandler);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void deregisterReplyHandler(SessionToken session, String sessionID) {
        super.sessionActive(session);
        try {
            this.httpService.deregisterReplyHandler(session, sessionID);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        Log.setLog(null);
        this.jetty = new Server();
        QueuedThreadPool threadPool = new QueuedThreadPool(this.threadCount);
        this.jetty.setThreadPool((ThreadPool)threadPool);
        this.connector = new SocketConnector();
        this.connector.setPort(this.myTcpPort);
        this.connector.setHost(this.serverHost);
        this.jetty.addConnector(this.connector);
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath("/AristaFlowHTTPService");
        this.jetty.addHandler((Handler)contextHandler);
        ServletHandler servletHandler = new ServletHandler();
        contextHandler.addHandler((Handler)servletHandler);
        this.httpService = new AristaFlowHTTPService();
        ServletHolder servlet = new ServletHolder((Servlet)this.httpService);
        servletHandler.addServletWithMapping(servlet, "/");
    }

    @Override
    public void start() throws ConfigurationException {
        try {
            this.jetty.start();
        }
        catch (Exception e) {
            String msg = "Unable to start the Jetty HTTP-service on address '%s' on port%d. Aborting start.";
            throw new ConfigurationException(String.format(msg, this.serverHost, this.myTcpPort), e);
        }
        this.myTcpPort = this.connector.getLocalPort();
        if (this.myTcpPort == -1) {
            String msg = "Unable to retrieve a port number for the Jetty HTTP-service. Aborting start.";
            throw new ConfigurationException(msg);
        }
        try {
            this.myURL = new URL("http", this.serverHost, this.myTcpPort, "/AristaFlowHTTPService/");
        }
        catch (MalformedURLException mue) {
            throw new ConfigurationException("Unable to create a URL for the Jetty HTTP-service. Aborting start", mue);
        }
        this.httpService.setURL(this.myURL);
        super.signalStart();
        this.logger.info(String.format("Jetty running on '%s'.", this.myURL));
    }

    @Override
    public boolean isActive() {
        return super.isActive();
    }

    @Override
    public void shutdown() {
        this.logger.info("Shutting down Jetty ...");
        super.shutdown();
        try {
            this.jetty.stop();
            this.jetty.join();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception while stopping the HTTP service.", e);
            this.jetty.setStopAtShutdown(true);
        }
        this.logger.info("done.");
    }

    @Override
    public void emergencyShutdown() {
        this.logger.info("Emergency shut down of Jetty...");
        super.emergencyShutdown();
        try {
            this.jetty.stop();
            this.jetty.join();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception while stopping the HTTP service.", e);
            this.jetty.setStopAtShutdown(true);
        }
        this.logger.info("done.");
    }
}

