/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.i18n;

import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LocaleTools;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AddLocaleDialogue
extends Dialog {
    private Set<Locale> commonLocales = new HashSet<Locale>();
    private Locale selectedLocale;
    ComboViewer localesCombo;

    public AddLocaleDialogue(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Add Locale");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        area.setLayout((Layout)new MigLayout("wrap", "[grow, fill]"));
        Label label = new Label(area, 0);
        label.setText("Please enter the new locale or select one from the drop down menu.");
        this.localesCombo = new ComboViewer(area, 0);
        this.localesCombo.getCombo().setVisibleItemCount(1000);
        this.localesCombo.setComparator(new ViewerComparator());
        this.localesCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Locale locale = (Locale)element;
                return LocaleTools.getLocaleLabel(locale);
            }
        });
        this.localesCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.localesCombo.setInput(this.commonLocales);
        this.localesCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Locale locale = (Locale)selection.getFirstElement();
                if (locale != null) {
                    AddLocaleDialogue.this.localesCombo.getCombo().setText(locale.toString());
                }
            }
        });
        return area;
    }

    protected void okPressed() {
        this.selectedLocale = LocaleTools.parseLocaleString(this.localesCombo.getCombo().getText());
        super.okPressed();
    }

    public void setCommonLocales(Locale ... locales) {
        ArgChecks.checkForNulls(locales, "locales");
        this.commonLocales.clear();
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            this.commonLocales.add(locale);
            ++n2;
        }
    }

    public void setCommonLocales(Collection<Locale> locales) {
        ArgChecks.checkForNulls(locales, "locales");
        this.commonLocales.clear();
        this.commonLocales.addAll(locales);
    }

    public Locale getLocale() {
        return this.selectedLocale;
    }
}

