/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.i18n;

import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DialogTextCellEditor
extends TextCellEditor {
    boolean cellEditorHasFocus;
    boolean dialogueIsOpen = false;

    public DialogTextCellEditor() {
    }

    public DialogTextCellEditor(Composite parent) {
        super(parent);
    }

    public DialogTextCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createControl(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new MigLayout("insets 0", "[grow, fill][]"));
        composite.setFont(parent.getFont());
        composite.setBackground(parent.getBackground());
        Control control = super.createControl(composite);
        control.setLayoutData((Object)"w 0:0");
        Button button = new Button(composite, 0x800000);
        button.setLayoutData((Object)"w 0:n, h 0:n");
        button.setText("\u00e2\u20ac\u00a6");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextDialogue dialogue = new TextDialogue(parent.getShell());
                dialogue.setText(DialogTextCellEditor.this.text.getText());
                DialogTextCellEditor.this.dialogueIsOpen = true;
                if (dialogue.open() == 0) {
                    DialogTextCellEditor.this.text.setText(dialogue.getText());
                    DialogTextCellEditor.this.text.selectAll();
                }
                DialogTextCellEditor.this.dialogueIsOpen = false;
                DialogTextCellEditor.this.text.setFocus();
            }
        });
        composite.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                DialogTextCellEditor.this.cellEditorHasFocus = true;
            }
        });
        composite.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                DialogTextCellEditor.this.cellEditorHasFocus = false;
                DialogTextCellEditor.this.focusLost();
            }
        });
        return composite;
    }

    protected void focusLost() {
        if (!this.cellEditorHasFocus && !this.dialogueIsOpen) {
            super.focusLost();
        }
    }

    private static class TextDialogue
    extends FormDialog {
        private String title;
        private String text = "";
        private Text textBox;

        public TextDialogue(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Multiline Value Editor");
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text == null ? "" : text;
        }

        protected void createFormContent(IManagedForm mform) {
            super.createFormContent(mform);
            FormToolkit toolkit = mform.getToolkit();
            Composite body = mform.getForm().getBody();
            body.setLayout((Layout)new MigLayout("insets 0", "[grow, fill]", "[grow, fill]"));
            toolkit.decorateFormHeading(mform.getForm().getForm());
            mform.getForm().setText(this.title);
            this.textBox = toolkit.createText(body, "", 2818);
            this.textBox.setLayoutData((Object)"w 0:400lp, h 0:200lp");
            this.textBox.setText(this.text);
            this.textBox.selectAll();
        }

        protected void okPressed() {
            this.text = this.textBox.getText();
            super.okPressed();
        }
    }
}

