/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.i18n;

import de.aristaflow.adept2.Activator;
import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.changeoperations.UpdatePluginDataContainer;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.ModelViewerProvider;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.ui.i18n.TranslateActionCallback;
import de.aristaflow.adept2.ui.i18n.TranslationDialogue;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;

public class TranslateAction
extends Action {
    private Shell parentShell;
    private ModelViewerProvider modelViewerProvider;
    private TranslateActionCallback provider;
    private UpdateManager updateManager;

    public TranslateAction(Shell parentShell, ModelViewerProvider modelViewerProvider, TranslateActionCallback provider, UpdateManager updateManager) {
        super("Translate", Activator.getImageDescriptor("icons/i18n/translation_edit.gif"));
        ArgChecks.checkForNull(parentShell, "parentShell");
        ArgChecks.checkForNull(modelViewerProvider, "modelViewerProvider");
        ArgChecks.checkForNull(provider, "provider");
        ArgChecks.checkForNull(updateManager, "updateManager");
        this.parentShell = parentShell;
        this.modelViewerProvider = modelViewerProvider;
        this.provider = provider;
        this.updateManager = updateManager;
    }

    public void run() {
        Collection<PluginData> pluginDatas = this.provider.getPluginData();
        if (pluginDatas == null) {
            return;
        }
        TranslationDialogue dialogue = new TranslationDialogue(this.parentShell, this.modelViewerProvider, this.provider.getLocalisedProcessModelClass());
        dialogue.setPluginDatas(pluginDatas);
        if (dialogue.open() == 0) {
            ChangeableTemplate template = this.provider.getTemplate();
            PluginDataContainer pluginDataContainer = this.provider.getPluginDataContainer();
            String transactionLabel = "Translation";
            StartTransaction.performOperation(template, this.updateManager);
            for (PluginData pluginData : dialogue.getPluginDatas().values()) {
                String extensionPointID;
                if (pluginData.getPluginID().equals("ProcessLocalisation")) {
                    extensionPointID = "ProcessLocalisation";
                } else {
                    extensionPointID = null;
                    for (Map.Entry<String, Set<String>> entry : pluginDataContainer.getSupportedPlugins().entrySet()) {
                        if (!entry.getValue().contains(pluginData.getPluginID())) continue;
                        extensionPointID = entry.getKey();
                        break;
                    }
                    if (extensionPointID == null) {
                        throw new RuntimeException("The plugin data container appears to have an illegal state. It has no extension point ID for one of its plugin IDs.");
                    }
                }
                UpdatePluginDataContainer.performOperation(template, this.provider.getPluginDataContainer(), extensionPointID, pluginData.getPluginID(), pluginData, this.updateManager);
            }
            EndTransaction.performOperation(template, this.updateManager, transactionLabel);
        }
    }
}

