/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.i18n;

import de.aristaflow.adept2.model.common.i18n.Localised;
import de.aristaflow.adept2.model.common.viewer.Attribute;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LocaleTools;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class TranslationDataAdapter {
    private String pluginID;
    private Class<?> viewInterface;
    private Set<String> translatableAttributes;
    private Map<String, String> pluginData;

    public TranslationDataAdapter(String pluginID, Class<?> viewInterface, Map<String, String> pluginData) {
        ArgChecks.checkForNull(pluginID, "pluginID");
        ArgChecks.checkForNullKey(pluginData, "data");
        this.pluginID = pluginID;
        this.viewInterface = viewInterface;
        this.pluginData = pluginData;
        if (this.viewInterface != null) {
            HashSet<String> translatableKeys = new HashSet<String>();
            Method[] methodArray = viewInterface.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute;
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(Localised.class)) {
                    Localised localised = method.getAnnotation(Localised.class);
                    translatableKeys.add(localised.value());
                } else if (method.isAnnotationPresent(Attribute.class) && (attribute = method.getAnnotation(Attribute.class)).localised()) {
                    translatableKeys.add(attribute.name());
                }
                ++n2;
            }
            this.translatableAttributes = Collections.unmodifiableSet(translatableKeys);
        } else {
            this.translatableAttributes = Collections.emptySet();
        }
    }

    public Set<String> getTranslatableAttributes() {
        return this.translatableAttributes;
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public String getValue(String attrName, Locale locale) {
        this.checkAttrName(attrName);
        return this.pluginData.get(this.compKey(attrName, locale));
    }

    public void setValue(String attrName, String value, Locale locale) {
        this.checkAttrName(attrName);
        this.pluginData.put(this.compKey(attrName, locale), value);
    }

    public void removeValue(String attrName, Locale locale) {
        this.checkAttrName(attrName);
        this.pluginData.remove(this.compKey(attrName, locale));
    }

    public void removeTranslations(Locale locale) {
        ArgChecks.checkForNull(locale, "locale");
        for (String attrName : this.getTranslatableAttributes()) {
            this.removeValue(attrName, locale);
        }
    }

    public Locale[] getUsedLocales() {
        HashSet<Locale> locales = new HashSet<Locale>();
        block0: for (String rawKey : this.pluginData.keySet()) {
            for (String key : this.translatableAttributes) {
                String localeString;
                Locale locale;
                if (rawKey.equals(key) || !rawKey.startsWith(key) || rawKey.charAt(key.length()) != '.' || (locale = LocaleTools.parseLocaleString(localeString = rawKey.substring(key.length() + 1))) == null) continue;
                locales.add(locale);
                continue block0;
            }
        }
        return locales.toArray(new Locale[locales.size()]);
    }

    private String compKey(String attrName, Locale locale) {
        if (locale == null) {
            return attrName;
        }
        return String.valueOf(attrName) + "." + locale.toString();
    }

    private void checkAttrName(String attrName) {
        ArgChecks.checkForNull(attrName, "attrName");
        if (!this.translatableAttributes.contains(attrName)) {
            String msg = "The specified key '%s' is no translatable attribute!";
            msg = String.format(msg, attrName);
            throw new IllegalArgumentException(msg);
        }
    }
}

