/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.i18n;

import de.aristaflow.adept2.model.common.ModelViewerProvider;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.ui.i18n.TranslationUIComponent;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TranslationDialogue
extends TitleAreaDialog {
    private ModelViewerProvider modelViewerProvider;
    private Class<?> localisedProcessModelClass;
    private TranslationUIComponent translationUI;
    private Collection<Locale> defaultLocales;
    private Collection<PluginData> pluginData;

    public TranslationDialogue(Shell parentShell, ModelViewerProvider modelViewerProvider) {
        this(parentShell, modelViewerProvider, null);
    }

    public TranslationDialogue(Shell parentShell, ModelViewerProvider modelViewerProvider, Class<?> localisedProcessModelClass) {
        super(parentShell);
        ArgChecks.checkForNull(modelViewerProvider, "modelViewerProvider");
        this.modelViewerProvider = modelViewerProvider;
        this.localisedProcessModelClass = localisedProcessModelClass;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Translation Dialogue");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Attribute Translations");
        if (this.localisedProcessModelClass == null) {
            this.setMessage("Translate plug-in attributes.");
        } else {
            String msg = "Translate %s and plug-in attributes.";
            msg = String.format(msg, this.localisedProcessModelClass.getSimpleName());
            this.setMessage(msg);
        }
        Composite dialogArea = new Composite((Composite)super.createDialogArea(parent), 0);
        dialogArea.setLayoutData((Object)new GridData(1808));
        dialogArea.setLayout((Layout)new MigLayout("wrap, insets dialog", "[grow, fill]", "[grow, fill]"));
        this.translationUI = new TranslationUIComponent(dialogArea, this.modelViewerProvider, this.localisedProcessModelClass);
        this.translationUI.getControl().setLayoutData((Object)"w 0:n, h 0:300lp");
        if (this.defaultLocales != null) {
            this.translationUI.setDefaultLocales(this.defaultLocales);
        }
        if (this.pluginData != null) {
            this.translationUI.setPluginData(this.pluginData);
        }
        return dialogArea;
    }

    public void setDefaultLocales(Locale ... locales) {
        if (locales != null) {
            this.defaultLocales = Arrays.asList(locales);
        }
    }

    public void setDefaultLocales(Collection<Locale> locales) {
        this.defaultLocales = locales;
    }

    public Map<String, PluginData> getPluginDatas() {
        return this.translationUI.getPluginDatas();
    }

    public void setPluginDatas(Collection<PluginData> pluginData) {
        this.pluginData = pluginData;
    }
}

