/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.i18n;

import de.aristaflow.adept2.Activator;
import de.aristaflow.adept2.model.common.ModelViewerProvider;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.ui.i18n.AddLocaleDialogue;
import de.aristaflow.adept2.ui.i18n.DialogTextCellEditor;
import de.aristaflow.adept2.ui.i18n.ModifiablePluginData;
import de.aristaflow.adept2.ui.i18n.TranslationDataAdapter;
import de.aristaflow.adept2.ui.util.UIComponent;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.ListUIComponent;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LocaleTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class TranslationUIComponent
extends UIComponent {
    private ModelViewerProvider modelViewerProvider;
    Class<?> localisedProcessModelClass;
    final Set<Locale> locales = new HashSet<Locale>();
    private boolean allowMoreLocales;
    private final Set<Locale> detectedLocales = new HashSet<Locale>();
    Locale selectedLocale;
    Map<String, ModifiablePluginData> pluginDatas;
    private Map<String, TranslationDataAdapter> adapters = new LinkedHashMap<String, TranslationDataAdapter>();
    ComboViewer localesCombo;
    private Button localeAdd;
    Button localeRemove;
    TranslationTableUIComponent translationTableUI;

    public TranslationUIComponent(Composite parent, ModelViewerProvider modelViewerProvider) {
        this(parent, modelViewerProvider, null);
    }

    public TranslationUIComponent(Composite parent, ModelViewerProvider modelViewerProvider, Class<?> localisedProcessModelClass) {
        ArgChecks.checkForNull(parent, "parent");
        ArgChecks.checkForNull(modelViewerProvider, "modelViewerProvider");
        this.modelViewerProvider = modelViewerProvider;
        this.locales.add(Locale.getDefault());
        this.localisedProcessModelClass = localisedProcessModelClass;
        this.initControl(this.createControl(parent));
    }

    private Control createControl(final Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new MigLayout("insets 0, wrap", "[grow, fill]", "[][grow, fill]"));
        Label localesLabel = new Label(control, 0);
        localesLabel.setLayoutData((Object)"split 4");
        localesLabel.setText("Locale:");
        this.localesCombo = new ComboViewer(control);
        this.localesCombo.getCombo().setLayoutData((Object)"growx");
        this.localesCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    TranslationUIComponent.this.localeRemove.setEnabled(false);
                } else {
                    Locale locale;
                    TranslationUIComponent.this.localeRemove.setEnabled(true);
                    TranslationUIComponent.this.selectedLocale = locale = (Locale)((StructuredSelection)TranslationUIComponent.this.localesCombo.getSelection()).getFirstElement();
                    TranslationUIComponent.this.translationTableUI.getColumnViewer().refresh();
                }
            }
        });
        this.localesCombo.setComparator(new ViewerComparator());
        this.localesCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String text;
                Locale locale = (Locale)element;
                if (locale.getDisplayCountry() != null && locale.getDisplayCountry().length() > 0) {
                    text = "%s (%s) [%s]";
                    text = String.format(text, locale.getDisplayLanguage(), locale.getDisplayCountry(), locale.toString());
                } else {
                    text = "%s [%s]";
                    text = String.format(text, locale.getDisplayLanguage(), locale.toString());
                }
                return text;
            }
        });
        this.localesCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.localesCombo.setInput(this.locales);
        this.localeAdd = new Button(control, 0);
        this.localeAdd.setToolTipText("Add new Locale");
        this.localeAdd.setImage(Activator.getImage("icons/i18n/locale_add.gif"));
        this.localeAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Locale locale;
                AddLocaleDialogue dialogue = new AddLocaleDialogue(parent.getShell());
                ArrayList<Locale> commonLocales = new ArrayList<Locale>();
                commonLocales.addAll(Arrays.asList(LocaleTools.getCommonLocales()));
                commonLocales.removeAll(TranslationUIComponent.this.locales);
                dialogue.setCommonLocales(commonLocales);
                if (dialogue.open() == 0 && (locale = dialogue.getLocale()) != null) {
                    TranslationUIComponent.this.locales.add(locale);
                    TranslationUIComponent.this.refreshLocalesCombo();
                    TranslationUIComponent.this.localesCombo.setSelection((ISelection)new StructuredSelection((Object)locale));
                }
            }
        });
        this.localeRemove = new Button(control, 0);
        this.localeRemove.setToolTipText("Remove selected Locale");
        this.localeRemove.setImage(Activator.getImage("icons/i18n/locale_remove.gif"));
        this.localeRemove.setEnabled(false);
        this.localeRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String msg = "Do you really want to remove the locale '%s' and all associated translations for all listed plugins?";
                msg = String.format(msg, TranslationUIComponent.this.selectedLocale);
                if (MessageDialog.openConfirm((Shell)parent.getShell(), (String)"Remove Locale", (String)msg)) {
                    for (String pluginID : TranslationUIComponent.this.pluginDatas.keySet()) {
                        TranslationDataAdapter adapter = TranslationUIComponent.this.getTranslationDataAdapter(pluginID);
                        adapter.removeTranslations(TranslationUIComponent.this.selectedLocale);
                    }
                    TranslationUIComponent.this.locales.remove(TranslationUIComponent.this.selectedLocale);
                    TranslationUIComponent.this.refreshLocalesCombo();
                }
            }
        });
        this.translationTableUI = new TranslationTableUIComponent(control);
        this.translationTableUI.getControl().setLayoutData((Object)"spanx, w 0:n");
        this.setDefaultLocales(Locale.getDefault());
        return control;
    }

    public void setDefaultLocales(Locale ... locales) {
        ArgChecks.checkForNulls(locales, "locales");
        this.setDefaultLocales(Arrays.asList(locales));
    }

    public void setDefaultLocales(Collection<Locale> locales) {
        ArgChecks.checkForNulls(locales, "locales");
        this.locales.clear();
        if (locales.size() > 0) {
            for (Locale locale : locales) {
                this.locales.add(locale);
            }
        } else {
            this.locales.add(Locale.getDefault());
        }
        this.refreshLocalesCombo();
    }

    public void setAllowNonDefaultLocales(boolean allowNonDefaultLocales) {
        this.allowMoreLocales = allowNonDefaultLocales;
    }

    public Map<String, PluginData> getPluginDatas() {
        HashMap<String, PluginData> result = new HashMap<String, PluginData>();
        for (String pluginID : this.pluginDatas.keySet()) {
            result.put(pluginID, new DefaultPluginData(pluginID, this.pluginDatas.get(pluginID).getPluginData()));
        }
        return result;
    }

    public void setPluginData(Collection<PluginData> pluginData) {
        ArgChecks.checkForNulls(pluginData, "pluginData");
        this.pluginDatas = new HashMap<String, ModifiablePluginData>();
        for (PluginData data : pluginData) {
            ModifiablePluginData modPluginData = new ModifiablePluginData(data.getPluginID(), data.getPluginData());
            this.pluginDatas.put(data.getPluginID(), modPluginData);
        }
        if (this.localisedProcessModelClass != null && !this.pluginDatas.containsKey("ProcessLocalisation")) {
            this.pluginDatas.put("ProcessLocalisation", new ModifiablePluginData("ProcessLocalisation"));
        }
        this.translationTableUI.setInput(this.pluginDatas);
        if (this.pluginDatas.size() > 0) {
            this.translationTableUI.getColumnViewer().setSelection((ISelection)new StructuredSelection((Object)this.pluginDatas.values().iterator().next()));
        }
        for (String pluginID : this.pluginDatas.keySet()) {
            TranslationDataAdapter adapter = this.getTranslationDataAdapter(pluginID);
            Locale[] localeArray = adapter.getUsedLocales();
            int n = localeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Locale detectedLocale = localeArray[n2];
                this.detectedLocales.add(detectedLocale);
                ++n2;
            }
        }
        this.refreshLocalesCombo();
    }

    void refreshLocalesCombo() {
        this.locales.addAll(this.detectedLocales);
        this.localesCombo.refresh();
        if (this.locales.size() > 0 && this.localesCombo.getSelection().isEmpty()) {
            this.localesCombo.setSelection((ISelection)new StructuredSelection(this.localesCombo.getElementAt(0)));
        }
        this.localesCombo.getCombo().setVisibleItemCount(this.locales.size());
    }

    TranslationDataAdapter getTranslationDataAdapter(String pluginID) {
        ModifiablePluginData data = this.pluginDatas.get(pluginID);
        if (data == null) {
            throw new IllegalArgumentException();
        }
        TranslationDataAdapter adapter = this.adapters.get(pluginID);
        if (adapter == null) {
            Class<?> viewInterface = pluginID.equals("ProcessLocalisation") ? this.localisedProcessModelClass : this.modelViewerProvider.getModelViewerClass(pluginID);
            adapter = new TranslationDataAdapter(pluginID, viewInterface, data.getModifiablePluginData());
            this.adapters.put(pluginID, adapter);
        }
        return adapter;
    }

    private static class AttributeEntry {
        private final TranslationDataAdapter adapter;
        private final String attrName;

        public AttributeEntry(TranslationDataAdapter translationDataAdapter, String attrName) {
            ArgChecks.checkForNull(translationDataAdapter, "translationDataAdapter");
            ArgChecks.checkForNull(attrName, "attrName");
            this.adapter = translationDataAdapter;
            this.attrName = attrName;
        }

        public TranslationDataAdapter getAdapter() {
            return this.adapter;
        }

        public String getAttrName() {
            return this.attrName;
        }
    }

    private class TranslationTableUIComponent
    extends ListUIComponent {
        public TranslationTableUIComponent(Composite parent) {
            super(Tree.class, parent, 67584);
            this.initColumns(null, null, "name", true);
            ((Tree)this.getColumnControl()).setLinesVisible(true);
            this.getColumnViewer().setContentProvider((IContentProvider)new ITreeContentProvider(){

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    if (element instanceof ModifiablePluginData) {
                        ModifiablePluginData data = (ModifiablePluginData)element;
                        TranslationDataAdapter adapter = TranslationUIComponent.this.getTranslationDataAdapter(data.getPluginID());
                        return adapter.getTranslatableAttributes().size() > 0;
                    }
                    return false;
                }

                public Object[] getChildren(Object element) {
                    if (element instanceof ModifiablePluginData) {
                        ModifiablePluginData data = (ModifiablePluginData)element;
                        TranslationDataAdapter adapter = TranslationUIComponent.this.getTranslationDataAdapter(data.getPluginID());
                        Object[] entries = new AttributeEntry[adapter.getTranslatableAttributes().size()];
                        int index = 0;
                        for (String attrName : adapter.getTranslatableAttributes()) {
                            entries[index] = new AttributeEntry(adapter, attrName);
                            ++index;
                        }
                        return entries;
                    }
                    return null;
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof PluginData[]) {
                        return (PluginData[])inputElement;
                    }
                    if (inputElement instanceof List) {
                        return ((List)inputElement).toArray();
                    }
                    if (inputElement instanceof Map) {
                        return ((Map)inputElement).values().toArray();
                    }
                    if (inputElement instanceof PluginData) {
                        return this.getChildren(inputElement);
                    }
                    throw new IllegalArgumentException();
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }
            });
            this.getColumnViewer().addSelectionChangedListener(new ISelectionChangedListener(){
                private TreePath path = new TreePath(new Object[0]);

                public void selectionChanged(SelectionChangedEvent event) {
                    TreePath parent;
                    TreeSelection selection = (TreeSelection)event.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    TreeViewer treeViewer = (TreeViewer)TranslationTableUIComponent.this.getColumnViewer();
                    TreePath oldPath = this.path;
                    if (oldPath.getLastSegment() instanceof AttributeEntry) {
                        oldPath = oldPath.getParentPath();
                    }
                    this.path = selection.getPaths()[0];
                    if (this.path.getLastSegment() instanceof AttributeEntry) {
                        this.path = this.path.getParentPath();
                    }
                    if (oldPath.equals((Object)this.path)) {
                        return;
                    }
                    TreePath oldParent = oldPath.getParentPath();
                    if (oldParent == (parent = this.path.getParentPath()) || oldParent != null && oldParent.equals((Object)parent)) {
                        treeViewer.setExpandedState((Object)oldPath, false);
                    }
                    if (treeViewer.isExpandable(selection.getFirstElement())) {
                        treeViewer.setExpandedState(selection.getFirstElement(), true);
                    }
                }
            });
        }

        @Override
        protected void fillContextMenu(MenuManager contextMenu) {
        }

        @Override
        protected void registerColumns() {
            this.registerColumn("name", "Attribute Name", 0, false, true, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof ModifiablePluginData) {
                        ModifiablePluginData pluginData = (ModifiablePluginData)element;
                        TranslationDataAdapter adapter = TranslationUIComponent.this.getTranslationDataAdapter(pluginData.getPluginID());
                        String label = "%s [%d]";
                        label = String.format(label, pluginData.getPluginID(), adapter.getTranslatableAttributes().size());
                        return label;
                    }
                    if (element instanceof AttributeEntry) {
                        AttributeEntry entry = (AttributeEntry)element;
                        return entry.getAttrName();
                    }
                    return null;
                }

                public Image getImage(Object element) {
                    if (element instanceof ModifiablePluginData) {
                        return Activator.getImage("icons/i18n/entry_plugin.gif");
                    }
                    if (element instanceof AttributeEntry) {
                        return Activator.getImage("icons/i18n/entry_attribute.gif");
                    }
                    return null;
                }
            }, null, null);
            this.registerColumn("default", "Default Value", 0, false, true, new ColumnData(150, 1.0f), (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof AttributeEntry) {
                        AttributeEntry entry = (AttributeEntry)element;
                        String value = entry.getAdapter().getValue(entry.getAttrName(), null);
                        if (((TranslationTableUIComponent)TranslationTableUIComponent.this).TranslationUIComponent.this.localisedProcessModelClass != null && entry.getAdapter().getPluginID().equals("ProcessLocalisation")) {
                            return String.format("<see %s properties>", ((TranslationTableUIComponent)TranslationTableUIComponent.this).TranslationUIComponent.this.localisedProcessModelClass.getSimpleName());
                        }
                        if (value == null) {
                            return "<not set>";
                        }
                        return value;
                    }
                    return null;
                }
            }, null, new EditingSupport(this.getColumnViewer()){
                private CellEditor cellEditor;

                protected boolean canEdit(Object element) {
                    AttributeEntry entry;
                    return element instanceof AttributeEntry && !(entry = (AttributeEntry)element).getAdapter().getPluginID().equals("ProcessLocalisation");
                }

                protected Object getValue(Object element) {
                    AttributeEntry entry = (AttributeEntry)element;
                    String value = entry.getAdapter().getValue(entry.getAttrName(), null);
                    return value == null ? "" : value;
                }

                protected void setValue(Object element, Object value) {
                    AttributeEntry entry = (AttributeEntry)element;
                    String string = (String)value;
                    if (string.length() == 0) {
                        entry.getAdapter().removeValue(entry.getAttrName(), null);
                    } else {
                        entry.getAdapter().setValue(entry.getAttrName(), string, null);
                    }
                    this.getViewer().refresh();
                }

                protected CellEditor getCellEditor(Object element) {
                    if (this.cellEditor == null) {
                        this.cellEditor = new DialogTextCellEditor((Composite)this.getViewer().getControl());
                    }
                    return this.cellEditor;
                }
            });
            this.registerColumn("translation", "Translated Value", 0, false, true, new ColumnData(150, 1.0f), (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof AttributeEntry) {
                        AttributeEntry entry = (AttributeEntry)element;
                        String value = entry.getAdapter().getValue(entry.getAttrName(), ((TranslationTableUIComponent)TranslationTableUIComponent.this).TranslationUIComponent.this.selectedLocale);
                        if (value == null) {
                            return "<not set>";
                        }
                        return value;
                    }
                    return null;
                }
            }, null, new EditingSupport(this.getColumnViewer()){
                private CellEditor cellEditor;

                protected boolean canEdit(Object element) {
                    return element instanceof AttributeEntry && ((TranslationTableUIComponent)TranslationTableUIComponent.this).TranslationUIComponent.this.selectedLocale != null;
                }

                protected Object getValue(Object element) {
                    AttributeEntry entry = (AttributeEntry)element;
                    String value = entry.getAdapter().getValue(entry.getAttrName(), ((TranslationTableUIComponent)TranslationTableUIComponent.this).TranslationUIComponent.this.selectedLocale);
                    return value == null ? "" : value;
                }

                protected void setValue(Object element, Object value) {
                    AttributeEntry entry = (AttributeEntry)element;
                    String string = (String)value;
                    if (string.length() == 0) {
                        entry.getAdapter().removeValue(entry.getAttrName(), ((TranslationTableUIComponent)TranslationTableUIComponent.this).TranslationUIComponent.this.selectedLocale);
                    } else {
                        entry.getAdapter().setValue(entry.getAttrName(), string, ((TranslationTableUIComponent)TranslationTableUIComponent.this).TranslationUIComponent.this.selectedLocale);
                    }
                    this.getViewer().refresh();
                }

                protected CellEditor getCellEditor(Object element) {
                    if (this.cellEditor == null) {
                        this.cellEditor = new DialogTextCellEditor((Composite)this.getViewer().getControl());
                    }
                    return this.cellEditor;
                }
            });
        }
    }
}

