/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.icons;

import de.aristaflow.adept2.ui.icons.worklist.WorklistImages;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;

public final class TypeImages
implements WorklistImages {
    private static Map<String, ImageDescriptor> typeImages = new HashMap<String, ImageDescriptor>();

    public static ImageDescriptor getDescriptor(String type, IconSize iconSize) {
        String iconFileName;
        String iconName;
        ArgChecks.checkForNull(type, "type");
        ArgChecks.checkForNull((Object)iconSize, "iconSize");
        switch (iconSize) {
            case x16: {
                iconName = String.valueOf(type) + "16";
                break;
            }
            case x24: {
                iconName = String.valueOf(type) + "24";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (typeImages.containsKey(iconName)) {
            return typeImages.get(iconName);
        }
        ImageDescriptor typeImage = null;
        if (iconSize == IconSize.x16) {
            iconFileName = String.valueOf(iconName) + ".png";
            typeImage = TypeImages.getIcon(iconFileName);
        }
        if (typeImage == null) {
            iconFileName = String.valueOf(type) + ".png";
            typeImage = TypeImages.getIcon(iconFileName);
        }
        if (typeImage == null) {
            typeImage = TypeImages.getIcon("sample.png");
        }
        typeImages.put(iconName, typeImage);
        return typeImage;
    }

    private static ImageDescriptor getIcon(String iconFileName) {
        if (WorklistImages.class.getResource(iconFileName) != null) {
            return ImageDescriptor.createFromFile(WorklistImages.class, (String)iconFileName);
        }
        return null;
    }

    public static enum IconSize {
        x16,
        x24;

    }
}

