/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.licensing;

import de.aristaflow.adept2.Activator;
import de.aristaflow.adept2.base.licensing.LicenceManager;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.common.LicenceInformation;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.FileTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class LicenceInformationDialogue
extends TitleAreaDialog {
    private final ResourceBundle messages;
    private final Locale locale;

    public LicenceInformationDialogue(Shell parentShell, Locale locale) {
        super(parentShell);
        if (locale != null) {
            this.messages = ResourceBundle.getBundle("de.aristaflow.adept2.ui.licensing.LicenceBundle", locale);
            this.locale = locale;
        } else {
            this.messages = ResourceBundle.getBundle("de.aristaflow.adept2.ui.licensing.LicenceBundle");
            this.locale = Locale.getDefault();
        }
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.messages.getString("LIDTitle"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.messages.getString("LIDCloseBtn"), true);
    }

    protected Control createDialogArea(Composite parent) {
        String msg;
        Composite container = (Composite)super.createDialogArea(parent);
        Composite area_dialogue = new Composite(container, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = this.convertHorizontalDLUsToPixels(450);
        layoutData.heightHint = this.convertHorizontalDLUsToPixels(450);
        area_dialogue.setLayoutData((Object)layoutData);
        area_dialogue.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(12, 8).spacing(8, 8).create());
        this.setTitle(this.messages.getString("LIDTitle"));
        String licensee = "N/A";
        String licenceType = "N/A";
        String licenceEndTime = "N/A";
        try {
            SessionToken session = Activator.getAdministrationService().getSessionToken();
            LicenceManager licMan = Activator.getAdministrationService().getLicenceManager();
            LicenceInformation licInf = licMan.getLicenceInformation(session);
            licensee = licInf.getLicensee();
            licenceType = licInf.getLicenceType();
            if (licInf.getTimeLimitEnd() != null) {
                licenceEndTime = DateFormat.getDateInstance(1, this.locale).format(licInf.getTimeLimitEnd());
            }
        }
        catch (ServiceNotKnownException ex) {
            msg = "Could not retrieve licence information!";
            StatusTools.handleErrorStatus(Activator.getPluginID(), msg, ex);
        }
        catch (RuntimeException ex) {
            msg = "Could not retrieve licence information!";
            StatusTools.handleErrorStatus(Activator.getPluginID(), msg, ex);
        }
        this.setMessage(String.format(this.messages.getString("LIDMessage"), licensee, licenceType));
        Browser licenceTextBrowser = new Browser(area_dialogue, 2048);
        layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        layoutData.widthHint = 200;
        licenceTextBrowser.setLayoutData((Object)layoutData);
        licenceTextBrowser.setFocus();
        new Label(area_dialogue, 258).setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        new Label(area_dialogue, 0).setText(this.messages.getString("LIDExpiryDate"));
        Text txLicenceExpiryDate = new Text(area_dialogue, 8);
        txLicenceExpiryDate.setText(licenceEndTime);
        new Label(area_dialogue, 0).setText(this.messages.getString("LIDSWVersion"));
        Text txSoftwareVersion = new Text(area_dialogue, 8);
        String versionString = "N/A";
        Properties args = new Properties();
        InputStream versionStream = ((Object)((Object)this)).getClass().getResourceAsStream("/about.mappings");
        if (versionStream != null) {
            try {
                args.load(versionStream);
                String arg0 = args.getProperty("0");
                String arg1 = args.getProperty("1");
                String arg2 = args.getProperty("2");
                versionString = MessageFormat.format("{0} - r{1} ({2})", arg0, arg1, arg2);
            }
            catch (IOException iOException) {}
        }
        txSoftwareVersion.setText(versionString);
        Path licencePath = new Path("/licence.html");
        Bundle bundle = Activator.getDefault().getBundle();
        try {
            InputStream licenceIn = FileLocator.openStream((Bundle)bundle, (IPath)licencePath, (boolean)false);
            Reader reader = null;
            try {
                int charsRead;
                reader = new InputStreamReader(licenceIn, "UTF-8");
                StringBuilder licence = new StringBuilder();
                char[] buffer = new char[14];
                while ((charsRead = reader.read(buffer)) > -1) {
                    licence.append(buffer, 0, charsRead);
                }
                reader = FileTools.close(reader);
                licenceTextBrowser.setText(licence.toString());
            }
            catch (IOException ex) {
                FileTools.closeQuietly(reader);
                String msg2 = "Licence text (%s) could not be loaded.<br/><br/>(%s)";
                msg2 = String.format(msg2, licencePath.lastSegment(), ex.toString());
                licenceTextBrowser.setText(msg2);
            }
        }
        catch (IOException iOException) {
            String msg3 = "Licence text (%s) is missing.";
            msg3 = String.format(msg3, licencePath.lastSegment());
            licenceTextBrowser.setText(msg3);
        }
        return container;
    }
}

