/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.plugindata;

import de.aristaflow.adept2.ui.icons.MiscImages;
import de.aristaflow.adept2.ui.plugindata.PluginDataContainerController;
import de.aristaflow.adept2.ui.plugindata.PluginDataEditingPart;
import de.aristaflow.adept2.util.CheckReport;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DefaultPluginDataEditingPart
extends PluginDataEditingPart {
    protected final String pluginID;
    protected final PluginDataContainerController controller;
    protected final FormToolkit toolkit;
    private final Map<String, EntryWidget> entryWidgets = new HashMap<String, EntryWidget>();

    public DefaultPluginDataEditingPart(Composite parent, FormToolkit toolkit, PluginDataContainerController controller, String pluginID) {
        super(parent, toolkit);
        this.setLayout((Layout)new FillLayout());
        this.toolkit = toolkit;
        this.controller = controller;
        this.pluginID = pluginID;
        Composite container = toolkit.createComposite((Composite)this);
        container.setBackground(this.getBackground());
        container.setLayout((Layout)new GridLayout(1, false));
        Composite entryContainer = toolkit.createComposite(container);
        entryContainer.setLayout((Layout)new FillLayout(512));
        GridData gridData = new GridData(4, 4, true, false);
        entryContainer.setLayoutData((Object)gridData);
        HashSet<String> keys = new HashSet<String>();
        if (controller.getKnownPointFields().containsKey(pluginID)) {
            keys.addAll((Collection)controller.getKnownPointFields().get(pluginID));
        }
        Map<String, String> data = controller.getPluginData(pluginID);
        keys.addAll(data.keySet());
        for (String key : keys) {
            String value = data.get(key);
            if (value == null) {
                value = "";
            }
            EntryWidget entryWidget = new EntryWidget(entryContainer, key, value, CheckReport.ResultType.OK, "");
            this.entryWidgets.put(key, entryWidget);
        }
    }

    public class EntryWidget
    extends Composite {
        public EntryWidget(Composite parent, final String key, String value, CheckReport.ResultType icon, String iconToolTip) {
            String imageName;
            super(parent, 0);
            this.setLayout((Layout)new FillLayout());
            Composite container = DefaultPluginDataEditingPart.this.toolkit.createComposite((Composite)this);
            container.setBackground(this.getBackground());
            container.setLayout((Layout)new GridLayout(3, false));
            DefaultPluginDataEditingPart.this.toolkit.createLabel(container, key);
            final Text valueText = DefaultPluginDataEditingPart.this.toolkit.createText(container, value, 2052);
            GridData gridData = new GridData(4, -1, true, false);
            valueText.setLayoutData((Object)gridData);
            valueText.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    ((EntryWidget)EntryWidget.this).DefaultPluginDataEditingPart.this.controller.updatePluginEntry(((EntryWidget)EntryWidget.this).DefaultPluginDataEditingPart.this.pluginID, key, valueText.getText());
                }
            });
            Label iconLabel = DefaultPluginDataEditingPart.this.toolkit.createLabel(container, "", 0);
            switch (icon) {
                case OK: {
                    imageName = "";
                    break;
                }
                case INFO: {
                    imageName = "info_tsk.gif";
                    break;
                }
                case WARNING: {
                    imageName = "warning_tsk.gif";
                    break;
                }
                case FAILURE: {
                    imageName = "error_tsk.gif";
                    break;
                }
                default: {
                    imageName = "error_tsk.gif";
                }
            }
            iconLabel.setImage(MiscImages.getImage(imageName));
            iconLabel.setToolTipText(iconToolTip);
        }
    }
}

