/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.plugindata;

import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginDataContainer;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PluginDataContainerController {
    private final Map<String, String> knownPluginsPoints;
    private final Map<String, Set<String>> knownPointFields;
    private final Map<String, Set<String>> supportedPlugins = new HashMap<String, Set<String>>();
    private final Map<String, Map<String, String>> pluginData = new HashMap<String, Map<String, String>>();
    private final List<PluginDataListener> listeners = new LinkedList<PluginDataListener>();

    public PluginDataContainerController(Map<String, String> knownPluginsPoints, Map<String, Set<String>> knownPointFields) {
        this.knownPluginsPoints = knownPluginsPoints;
        this.knownPointFields = knownPointFields;
    }

    public void initPluginDataContainer(PluginDataContainer pluginDataContainer) {
        for (Map.Entry<String, Set<String>> entry : pluginDataContainer.getSupportedPlugins().entrySet()) {
            for (String pluginID : entry.getValue()) {
                HashMap<String, String> pluginDataData = new HashMap<String, String>(pluginDataContainer.getPluginData(pluginID).getPluginData());
                this.pluginData.put(pluginID, pluginDataData);
                this.addSupportedPlugin(entry.getKey(), pluginID, pluginDataData);
            }
        }
    }

    public PluginDataContainer createPluginDataContainer() {
        DefaultPluginDataContainer pluginDataContainer = new DefaultPluginDataContainer();
        for (Map.Entry<String, Set<String>> entry : this.supportedPlugins.entrySet()) {
            for (String pluginID : entry.getValue()) {
                DefaultPluginData data = new DefaultPluginData(pluginID, this.pluginData.get(pluginID));
                pluginDataContainer.addSupportedPlugin(entry.getKey(), pluginID, data);
            }
        }
        return pluginDataContainer;
    }

    public Map<String, String> getPluginData(String pluginID) {
        return Collections.unmodifiableMap(this.pluginData.get(pluginID));
    }

    public void addSupportedPlugin(String extensionPointID, String pluginID, Map<String, String> origData) {
        Set<Object> plugins;
        Map<String, String> data = origData;
        if (this.supportedPlugins.containsKey(extensionPointID)) {
            plugins = this.supportedPlugins.get(extensionPointID);
        } else {
            plugins = new HashSet();
            this.supportedPlugins.put(extensionPointID, plugins);
        }
        plugins.add(pluginID);
        data = data == null ? new HashMap<String, String>() : new HashMap<String, String>(data);
        this.pluginData.put(pluginID, data);
        LinkedList<PluginDataListener> listeners = new LinkedList<PluginDataListener>(this.listeners);
        for (PluginDataListener listener : listeners) {
            listener.supportedPluginAdded(extensionPointID, pluginID);
        }
    }

    public void removeSupportedPlugin(String pluginID) {
        for (Set<String> pluginSets : this.supportedPlugins.values()) {
            pluginSets.remove(pluginID);
        }
        this.pluginData.remove(pluginID);
        LinkedList<PluginDataListener> listeners = new LinkedList<PluginDataListener>(this.listeners);
        for (PluginDataListener listener : listeners) {
            listener.supportedPluginRemoved(pluginID);
        }
    }

    public void updatePluginEntry(String pluginID, String key, String value) {
        ArgChecks.checkForNull(pluginID, "pluginID");
        ArgChecks.checkForNull(key, "key");
        ArgChecks.checkForNull(value, "value");
        Map<String, String> data = this.pluginData.get(pluginID);
        data.put(key, value);
        LinkedList<PluginDataListener> listeners = new LinkedList<PluginDataListener>(this.listeners);
        for (PluginDataListener listener : listeners) {
            listener.pluginEntryUpdated(pluginID, key);
        }
    }

    public void supportedPluginSelected(String pluginID) {
        LinkedList<PluginDataListener> listeners = new LinkedList<PluginDataListener>(this.listeners);
        for (PluginDataListener listener : listeners) {
            listener.supportedPluginSelected(pluginID);
        }
    }

    public void addListener(PluginDataListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(PluginDataListener listener) {
        this.listeners.remove(listener);
    }

    public Map<String, String> getKnownPluginsPoints() {
        return Collections.unmodifiableMap(this.knownPluginsPoints);
    }

    public Map<String, Set<String>> getKnownPointFields() {
        return Collections.unmodifiableMap(this.knownPointFields);
    }

    public static class PluginDataListener {
        public void supportedPluginSelected(String pluginID) {
        }

        public void pluginEntryUpdated(String pluginID, String key) {
        }

        public void supportedPluginAdded(String pointID, String pluginID) {
        }

        public void supportedPluginRemoved(String pluginID) {
        }
    }
}

