/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.plugindata;

import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.ui.plugindata.DefaultPluginDataEditingPart;
import de.aristaflow.adept2.ui.plugindata.PluginDataContainerController;
import de.aristaflow.adept2.ui.plugindata.PluginDataEditingPart;
import de.aristaflow.adept2.ui.plugindata.SupportedPluginsWidget;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PluginDataWidget
extends Composite {
    protected final PluginDataContainerController controller;
    protected PluginDataEditingPart pluginDataEditing;
    protected final FormToolkit toolkit;

    public PluginDataWidget(Composite parent, FormToolkit toolkit, PluginDataContainer pluginDataContainer, Map<String, String> knownPluginsPoints, Map<String, Set<String>> knownPointFields) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(2, false));
        this.toolkit = toolkit;
        this.controller = new PluginDataContainerController(knownPluginsPoints, knownPointFields);
        this.controller.addListener(new Listener());
        SupportedPluginsWidget supportedPluginsWidget = new SupportedPluginsWidget(this, toolkit, this.controller);
        GridData gridData = new GridData(4, 4, false, true);
        supportedPluginsWidget.setLayoutData(gridData);
        this.controller.initPluginDataContainer(pluginDataContainer);
    }

    protected void updatePluginEditing(String pluginID) {
        if (this.pluginDataEditing != null) {
            this.pluginDataEditing.dispose();
            this.pluginDataEditing = null;
        }
        if (pluginID != null) {
            this.pluginDataEditing = new DefaultPluginDataEditingPart(this, this.toolkit, this.controller, pluginID);
            GridData gridData = new GridData(4, 4, true, false);
            this.pluginDataEditing.setLayoutData(gridData);
            this.layout();
        }
    }

    public PluginDataContainerController getController() {
        return this.controller;
    }

    protected class Listener
    extends PluginDataContainerController.PluginDataListener {
        protected Listener() {
        }

        @Override
        public void supportedPluginSelected(String pluginID) {
            PluginDataWidget.this.updatePluginEditing(pluginID);
        }

        @Override
        public void supportedPluginRemoved(String pluginID) {
            PluginDataWidget.this.updatePluginEditing(null);
        }
    }
}

