/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.plugindata;

import de.aristaflow.adept2.ui.plugindata.PluginDataContainerController;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SupportedPluginsWidget
extends Composite {
    private static final String POINT_ID = "PointID";
    private static final String PLUGIN_ID = "PluginID";
    protected final PluginDataContainerController controller;
    protected final Tree pluginList;
    protected final Map<String, TreeItem> pluginItems = new HashMap<String, TreeItem>();
    final Button removeButton;
    protected final Combo availableCombo;

    public SupportedPluginsWidget(Composite parent, FormToolkit toolkit, PluginDataContainerController controller) {
        super(parent, 0);
        this.controller = controller;
        this.setLayout((Layout)new FillLayout());
        controller.addListener(new Listener());
        Composite container = toolkit.createComposite((Composite)this);
        container.setBackground(this.getBackground());
        container.setLayout((Layout)new GridLayout(3, false));
        this.pluginList = toolkit.createTree(container, 67588);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        this.pluginList.setLayoutData((Object)gridData);
        this.pluginList.setLinesVisible(true);
        this.pluginList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String pluginID = (String)SupportedPluginsWidget.this.pluginList.getSelection()[0].getData(SupportedPluginsWidget.PLUGIN_ID);
                SupportedPluginsWidget.this.controller.supportedPluginSelected(pluginID);
            }
        });
        this.availableCombo = new Combo(container, 4);
        gridData = new GridData();
        this.availableCombo.setLayoutData((Object)gridData);
        Button addButton = toolkit.createButton(container, "+", 8);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = SupportedPluginsWidget.this.availableCombo.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                String item = SupportedPluginsWidget.this.availableCombo.getItem(i);
                String[] split = item.split(Pattern.quote(" / "));
                String extensionPointID = split[0];
                String pluginID = split[1];
                SupportedPluginsWidget.this.controller.addSupportedPlugin(extensionPointID, pluginID, new HashMap<String, String>());
            }
        });
        gridData = new GridData();
        addButton.setLayoutData((Object)gridData);
        this.removeButton = toolkit.createButton(container, " - ", 8);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (SupportedPluginsWidget.this.pluginList.getSelection().length < 1) {
                    return;
                }
                String pluginID = (String)SupportedPluginsWidget.this.pluginList.getSelection()[0].getData(SupportedPluginsWidget.PLUGIN_ID);
                SupportedPluginsWidget.this.controller.removeSupportedPlugin(pluginID);
            }
        });
        gridData = new GridData();
        this.removeButton.setLayoutData((Object)gridData);
        this.updateAvailablePlugins();
    }

    protected TreeItem addItem(String pointID, String pluginID) {
        String text = this.formatEntry(pointID, pluginID);
        TreeItem item = new TreeItem(this.pluginList, 0);
        item.setText(0, text);
        item.setData(POINT_ID, (Object)pointID);
        item.setData(PLUGIN_ID, (Object)pluginID);
        this.pluginItems.put(pluginID, item);
        return item;
    }

    private String formatEntry(String pointID, String pluginID) {
        return String.valueOf(pointID) + " / " + pluginID;
    }

    protected void updateAvailablePlugins() {
        LinkedList<String> available = new LinkedList<String>();
        Map<String, String> knownPointFields = this.controller.getKnownPluginsPoints();
        for (Map.Entry<String, String> entry : knownPointFields.entrySet()) {
            String pointID = entry.getValue();
            String pluginID = entry.getKey();
            String pp = this.formatEntry(pointID, pluginID);
            available.add(pp);
        }
        TreeItem[] treeItemArray = this.pluginList.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            available.remove(item.getText());
            ++n2;
        }
        this.availableCombo.setItems(available.toArray(new String[available.size()]));
    }

    protected class Listener
    extends PluginDataContainerController.PluginDataListener {
        protected Listener() {
        }

        @Override
        public void supportedPluginAdded(String pointID, String pluginID) {
            TreeItem item = SupportedPluginsWidget.this.addItem(pointID, pluginID);
            SupportedPluginsWidget.this.pluginList.setSelection(item);
            SupportedPluginsWidget.this.controller.supportedPluginSelected(pluginID);
            SupportedPluginsWidget.this.updateAvailablePlugins();
        }

        @Override
        public void supportedPluginRemoved(String pluginID) {
            SupportedPluginsWidget.this.pluginItems.get(pluginID).dispose();
            SupportedPluginsWidget.this.pluginItems.remove(pluginID);
            SupportedPluginsWidget.this.updateAvailablePlugins();
        }
    }
}

