/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.statushandling;

import de.aristaflow.adept2.ui.statushandling.ADEPT2StatusHandler;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class ADEPT2WorkbenchAdvisor
extends WorkbenchAdvisor {
    protected final Logger logger = LoggerTools.getLogger((Object)this);
    private boolean isWorkbenchStarted = false;

    protected abstract String getPluginID();

    public void postStartup() {
        super.postStartup();
        this.isWorkbenchStarted = true;
        ADEPT2StatusHandler.notifyWorkbenchStarted();
    }

    public void eventLoopException(Throwable exception) {
        String msg = this.isWorkbenchStarted ? "The action could not be successfully completed. See the log for more detailed information." : "The application could not be successfully started. See the log for more detailed information.";
        Status status = new Status(4, this.getPluginID(), Integer.MIN_VALUE, msg, exception);
        StatusManager.getManager().handle((IStatus)status, 3);
    }
}

