/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.statushandling;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public final class StatusTools {
    private static final int DEFAULT_STYLE = 7;

    public static void handleErrorStatus(String pluginID, String message, Throwable exception) {
        StatusAdapter status = StatusTools.createErrorStatus(pluginID, message, exception);
        StatusManager.getManager().handle(status, 7);
    }

    public static void handleErrorStatus(String pluginID, int code, String message, Throwable exception) {
        StatusAdapter status = StatusTools.createErrorStatus(pluginID, code, message, exception);
        StatusManager.getManager().handle(status, 7);
    }

    public static void handleErrorStatus(String pluginID, String title, String message, Throwable exception) {
        StatusAdapter status = StatusTools.createErrorStatus(pluginID, title, message, exception);
        StatusManager.getManager().handle(status, 7);
    }

    public static void handleErrorStatus(String pluginID, int code, String title, String message, Throwable exception) {
        StatusAdapter status = StatusTools.createErrorStatus(pluginID, code, title, message, exception);
        StatusManager.getManager().handle(status, 7);
    }

    public static StatusAdapter createErrorStatus(String pluginID, String message, Throwable exception) {
        return StatusTools.createErrorStatus(pluginID, null, message, exception);
    }

    public static StatusAdapter createErrorStatus(String pluginID, int code, String message, Throwable exception) {
        return StatusTools.createErrorStatus(pluginID, null, message, exception);
    }

    public static StatusAdapter createErrorStatus(String pluginID, String title, String message, Throwable exception) {
        return StatusTools.createErrorStatus(pluginID, 0, title, message, exception);
    }

    public static StatusAdapter createErrorStatus(String pluginID, int code, String title, String message, Throwable exception) {
        Status status = new Status(4, pluginID, code, message, exception);
        StatusAdapter sa = new StatusAdapter((IStatus)status);
        sa.setProperty(StatusAdapter.TITLE_PROPERTY, (Object)title);
        sa.setProperty(StatusAdapter.TIMESTAMP_PROPERTY, (Object)System.currentTimeMillis());
        return sa;
    }

    private StatusTools() {
    }
}

