/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.statushandling;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class WhiteErrorDialogue
extends Dialog {
    protected String title;
    protected Throwable throwable;
    protected IStatus status;
    protected Button button_details;
    protected boolean detailsShown;
    protected Control detailsArea;
    protected String stackTrace;
    protected Text text_stackTrace;
    protected StackTraceHeader[] headers;
    private Clipboard clipboard;
    private String message;
    private FormToolkit toolkit;

    private WhiteErrorDialogue(Shell parent, String title, IStatus status) {
        this(parent, title, status.getMessage(), status.getException());
        this.status = status;
    }

    private WhiteErrorDialogue(Shell parent, String title, String message, Throwable throwable) {
        super(parent);
        this.title = title;
        if (this.title == null) {
            this.title = "A Problem Occurred";
        }
        this.message = message;
        if (this.message == null || this.message.equals("")) {
            this.message = "The operation could not be successfully completed.";
        }
        this.throwable = throwable;
        Display display = parent != null ? parent.getDisplay() : PlatformUI.createDisplay();
        this.toolkit = new FormToolkit(display);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.throwable != null) {
            this.createDetailsButton(parent);
        }
    }

    protected Control createDialogArea(Composite parent) {
        GridData layoutData;
        Composite body = this.toolkit.createComposite(parent, 2048);
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.marginWidth = 20;
        containerLayout.marginHeight = 20;
        containerLayout.horizontalSpacing = 10;
        containerLayout.verticalSpacing = 7;
        body.setLayout((Layout)containerLayout);
        body.setLayoutData((Object)new GridData(4, 4, false, false));
        Image image = parent.getDisplay().getSystemImage(8);
        if (image != null) {
            Label imageLabel = this.toolkit.createLabel(body, "", 0);
            image.setBackground(imageLabel.getBackground());
            imageLabel.setImage(image);
        }
        if (this.message != null) {
            Label messageLabel = this.toolkit.createLabel(body, this.message, 64);
            layoutData = new GridData(0, 0, false, false);
            layoutData.widthHint = this.convertHorizontalDLUsToPixels(400);
            messageLabel.setLayoutData((Object)layoutData);
            messageLabel.setFont(JFaceResources.getBannerFont());
        }
        if (this.throwable != null) {
            Label reasonLabel = this.toolkit.createLabel(body, "Reason:", 64);
            layoutData = new GridData(4, 4, false, false);
            layoutData.verticalIndent = 15;
            layoutData.horizontalSpan = 2;
            layoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
            reasonLabel.setLayoutData((Object)layoutData);
            Label reasonText = this.toolkit.createLabel(body, "", 64);
            layoutData = new GridData(4, 4, false, false);
            layoutData.widthHint = this.convertHorizontalDLUsToPixels(400);
            layoutData.horizontalIndent = this.convertHorizontalDLUsToPixels(8);
            layoutData.horizontalSpan = 2;
            reasonText.setLayoutData((Object)layoutData);
            String reason = "";
            String message = this.throwable.getMessage();
            reason = message == null || message.equals("") ? String.valueOf(reason) + "<no message given in the exception>" : String.valueOf(reason) + message;
            reasonText.setText(reason);
        }
        Label spacer = this.toolkit.createLabel(body, "", 0);
        layoutData = new GridData(4, 4, false, false);
        layoutData.heightHint = this.convertVerticalDLUsToPixels(12);
        layoutData.horizontalSpan = 2;
        spacer.setLayoutData((Object)layoutData);
        return body;
    }

    protected void createDetailsButton(Composite parent) {
        this.button_details = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
    }

    protected Control createDetailsArea(Composite parent) {
        GridData layoutData;
        Group detailsArea = new Group(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        detailsArea.setLayout((Layout)layout);
        detailsArea.setText("Exception details:");
        StringWriter out = new StringWriter();
        this.throwable.printStackTrace(new PrintWriter(out));
        this.stackTrace = out.toString();
        if (this.throwable.getCause() != null) {
            Label overviewLabel = new Label((Composite)detailsArea, 0);
            overviewLabel.setText("Stack trace overview:");
            layoutData = new GridData(4, 4, false, false);
            overviewLabel.setLayoutData((Object)layoutData);
            String lineSep = System.getProperty("line.separator");
            String[] lines = this.stackTrace.split(Pattern.quote(lineSep));
            ArrayList<StackTraceHeader> headersList = new ArrayList<StackTraceHeader>();
            int offset = 0;
            int i = 0;
            while (i < lines.length) {
                String line = lines[i];
                if (line.startsWith("Caused by") || i == 0) {
                    headersList.add(new StackTraceHeader(offset, offset + line.length()));
                }
                offset += line.length() + lineSep.length();
                ++i;
            }
            this.headers = headersList.toArray(new StackTraceHeader[headersList.size()]);
            final List overviewList = new List((Composite)detailsArea, 2304);
            layoutData = new GridData(4, 4, true, true);
            overviewList.setLayoutData((Object)layoutData);
            ListViewer overviewListViewer = new ListViewer(overviewList);
            overviewListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            overviewListViewer.setInput((Object)this.headers);
            overviewList.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int index = overviewList.getSelectionIndex();
                    StackTraceHeader header = WhiteErrorDialogue.this.headers[index];
                    WhiteErrorDialogue.this.text_stackTrace.setSelection(header.end, header.start);
                    WhiteErrorDialogue.this.text_stackTrace.showSelection();
                    WhiteErrorDialogue.this.text_stackTrace.setFocus();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        Label stackTraceLabel = new Label((Composite)detailsArea, 0);
        stackTraceLabel.setText("Full stack trace:");
        layoutData = new GridData(4, 4, false, false);
        stackTraceLabel.setLayoutData((Object)layoutData);
        this.text_stackTrace = this.toolkit.createText((Composite)detailsArea, this.stackTrace, 2826);
        layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = this.text_stackTrace.getLineHeight() * 10;
        this.text_stackTrace.setLayoutData((Object)layoutData);
        Button copyToClipboardButton = new Button((Composite)detailsArea, 0);
        layoutData = new GridData(131072, 4, false, false);
        copyToClipboardButton.setLayoutData((Object)layoutData);
        copyToClipboardButton.setText("Copy stack trace to clipboard");
        copyToClipboardButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WhiteErrorDialogue.this.copyStackTraceToClipboard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return detailsArea;
    }

    void copyStackTraceToClipboard() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        this.clipboard = new Clipboard(this.getShell().getDisplay());
        this.clipboard.setContents(new Object[]{this.stackTrace}, new Transfer[]{TextTransfer.getInstance()});
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getShell().computeSize(-1, -1);
        if (this.detailsShown) {
            this.detailsArea.dispose();
            this.detailsShown = false;
            this.button_details.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.detailsArea = this.createDetailsArea((Composite)this.getContents());
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.horizontalSpan = 2;
            layoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
            this.detailsArea.setLayoutData((Object)layoutData);
            this.detailsShown = true;
            this.button_details.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    public boolean close() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        return super.close();
    }

    public static void openError(Shell parent, String title, IStatus status) {
        new WhiteErrorDialogue(parent, title, status).open();
    }

    public static void openError(Shell parent, StatusAdapter statusAdapter) {
        WhiteErrorDialogue.openError(parent, (String)statusAdapter.getProperty(StatusAdapter.TITLE_PROPERTY), statusAdapter.getStatus());
    }

    public static void openError(Shell parent, String title, String message, Throwable throwable) {
        new WhiteErrorDialogue(parent, title, message, throwable).open();
    }

    private class StackTraceHeader {
        int start;
        int end;

        StackTraceHeader(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return WhiteErrorDialogue.this.stackTrace.substring(this.start, this.end);
        }
    }
}

