/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.systemdata;

import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.Dependency;
import de.aristaflow.adept2.model.common.systemdata.DependencyProvider;
import de.aristaflow.adept2.ui.systemdata.MessageChangeListener;
import de.aristaflow.adept2.ui.util.UIComponent;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ParameterBindingsUIComponent
extends UIComponent
implements IMessageProvider {
    protected DependencyProvider dependencyProvider;
    protected Map<String, ParameterRef> referencedParameters = new HashMap<String, ParameterRef>();
    protected Set<String> erroneousParameters = new HashSet<String>();
    protected Map<String, Dependency> volatileBindings = new HashMap<String, Dependency>();
    protected Map<String, Dependency> resultBindings = new HashMap<String, Dependency>();
    protected int messageType = 0;
    protected String message;
    protected List<MessageChangeListener> messageChangeListeners = new ArrayList<MessageChangeListener>();
    protected TableViewer table;
    protected Color colour_errorBackground;
    protected Color colour_lowLightForeground;

    public ParameterBindingsUIComponent(Composite parent, DependencyProvider dependencyProvider) {
        ArgChecks.checkForNull(dependencyProvider, "dependencyProvider");
        this.dependencyProvider = dependencyProvider;
        ParameterRef[] parameterRefArray = dependencyProvider.getParameters();
        int n = parameterRefArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterRef ref = parameterRefArray[n2];
            Dependency dep = dependencyProvider.getDependencyOf(ref.getName());
            this.resultBindings.put(ref.getName(), dep);
            ++n2;
        }
        this.initControl(this.createControl(parent));
    }

    protected Control createControl(Composite parent) {
        this.colour_errorBackground = new Color((Device)parent.getDisplay(), 255, 200, 200);
        this.colour_lowLightForeground = new Color((Device)parent.getDisplay(), 130, 130, 130);
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Label label = new Label(area, 0);
        GridData layoutData = new GridData(4, 4, true, false);
        label.setLayoutData((Object)layoutData);
        label.setText("Parameters and Bindings:");
        Composite table_layoutContainer = new Composite(area, 0);
        this.table = new TableViewer(table_layoutContainer, 100352);
        this.table.getTable().setHeaderVisible(true);
        this.table.getTable().setLinesVisible(true);
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = this.table.getTable().getHeaderHeight() + this.table.getTable().getItemHeight() * 4;
        table_layoutContainer.setLayoutData((Object)layoutData);
        TableColumnLayout table_layout = new TableColumnLayout();
        table_layoutContainer.setLayout((Layout)table_layout);
        TableViewerColumn column_parameterName = new TableViewerColumn(this.table, 0);
        column_parameterName.getColumn().setText("Parameter Name");
        table_layout.setColumnData((Widget)column_parameterName.getColumn(), (ColumnLayoutData)new ColumnWeightData(20));
        column_parameterName.setLabelProvider((CellLabelProvider)new BindingTableColumnLabelProvider(){

            public String getText(Object element) {
                ParameterRef parameterRef = (ParameterRef)element;
                return parameterRef.getName();
            }
        });
        TableViewerColumn column_parameterDataType = new TableViewerColumn(this.table, 0);
        column_parameterDataType.getColumn().setText("Data Type");
        table_layout.setColumnData((Widget)column_parameterDataType.getColumn(), (ColumnLayoutData)new ColumnWeightData(10));
        column_parameterDataType.setLabelProvider((CellLabelProvider)new BindingTableColumnLabelProvider(){

            public String getText(Object element) {
                ParameterRef parameterRef = (ParameterRef)element;
                return parameterRef.getDataType().toString();
            }
        });
        TableViewerColumn column_dependencyType = new TableViewerColumn(this.table, 0);
        column_dependencyType.getColumn().setText("Dependency Type");
        table_layout.setColumnData((Widget)column_dependencyType.getColumn(), (ColumnLayoutData)new ColumnWeightData(25));
        column_dependencyType.setLabelProvider((CellLabelProvider)new BindingTableColumnLabelProvider(){

            public String getText(Object element) {
                ParameterRef parameterRef = (ParameterRef)element;
                Dependency dependency = ParameterBindingsUIComponent.this.getDependency(parameterRef.getName());
                Object depType = dependency == null ? null : dependency.getType();
                return ParameterBindingsUIComponent.this.dependencyProvider.getLabelForType(depType);
            }
        });
        column_dependencyType.setEditingSupport(new EditingSupport((ColumnViewer)this.table){
            private Object[] depTypeKeys;
            private String[] depTypeLabels;
            private ComboBoxCellEditor cellEditor;
            {
                this.cellEditor = new ComboBoxCellEditor((Composite)ParameterBindingsUIComponent.this.table.getTable(), new String[0]);
                CCombo combo = (CCombo)this.cellEditor.getControl();
                combo.setVisibleItemCount(Integer.MAX_VALUE);
                combo.setEditable(false);
            }

            protected boolean canEdit(Object element) {
                ParameterRef ref = (ParameterRef)element;
                return ParameterBindingsUIComponent.this.referencedParameters.containsKey(ref.getName());
            }

            protected Object getValue(Object element) {
                if (!this.canEdit(element)) {
                    throw new AssertionError((Object)"can't be edited");
                }
                ParameterRef ref = (ParameterRef)element;
                Dependency dep = ParameterBindingsUIComponent.this.getDependency(ref.getName());
                Object valueDepType = null;
                if (dep != null) {
                    valueDepType = dep.getType();
                }
                int value = 0;
                int i = 0;
                int size = this.depTypeKeys.length;
                while (i < size) {
                    if (valueDepType != null && valueDepType.equals(this.depTypeKeys[i])) {
                        value = i;
                    }
                    ++i;
                }
                return value;
            }

            protected void setValue(Object element, Object value) {
                if (!this.canEdit(element)) {
                    throw new AssertionError((Object)"can't be edited");
                }
                int index = (Integer)value;
                ParameterRef ref = (ParameterRef)element;
                Object depType = this.depTypeKeys[index];
                Map<Object, String> depTypeArgs = ParameterBindingsUIComponent.this.dependencyProvider.getDependencyTypeArguments(depType, ref.getDataType(), null);
                Object depTypeArg = ParameterBindingsUIComponent.this.getFirstElement(depTypeArgs.keySet());
                Dependency dep = new Dependency(depType, depTypeArg);
                ParameterBindingsUIComponent.this.volatileBindings.put(ref.getName(), dep);
                ParameterBindingsUIComponent.this.asyncUpdateParameters();
            }

            protected CellEditor getCellEditor(Object element) {
                if (!this.canEdit(element)) {
                    throw new AssertionError((Object)"can't be edited");
                }
                ParameterRef ref = (ParameterRef)element;
                Map<Object, String> depTypes = ParameterBindingsUIComponent.this.dependencyProvider.getDependencyTypes(ref.getDataType(), null);
                this.depTypeKeys = new Object[depTypes.size()];
                this.depTypeLabels = new String[depTypes.size()];
                int i = 0;
                for (Map.Entry<Object, String> depType : depTypes.entrySet()) {
                    this.depTypeKeys[i] = depType.getKey();
                    this.depTypeLabels[i] = depType.getValue();
                    ++i;
                }
                this.cellEditor.setItems(this.depTypeLabels);
                return this.cellEditor;
            }
        });
        TableViewerColumn column_dependencyTypeArgument = new TableViewerColumn(this.table, 0);
        column_dependencyTypeArgument.getColumn().setText("Dependency Type Argument");
        table_layout.setColumnData((Widget)column_dependencyTypeArgument.getColumn(), (ColumnLayoutData)new ColumnWeightData(25));
        column_dependencyTypeArgument.setLabelProvider((CellLabelProvider)new BindingTableColumnLabelProvider(){

            public String getText(Object element) {
                Object depTypeArg;
                Object depType;
                ParameterRef parameterRef = (ParameterRef)element;
                Dependency dependency = ParameterBindingsUIComponent.this.getDependency(parameterRef.getName());
                if (dependency == null) {
                    depType = null;
                    depTypeArg = null;
                } else {
                    depType = dependency.getType();
                    depTypeArg = dependency.getArgument();
                }
                return ParameterBindingsUIComponent.this.dependencyProvider.getLabelForArgument(depType, depTypeArg);
            }
        });
        column_dependencyTypeArgument.setEditingSupport(new EditingSupport((ColumnViewer)this.table){
            private Object[] depTypeArgKeys;
            private String[] depTypeArgLabels;
            private ComboBoxCellEditor cellEditor;
            {
                this.cellEditor = new ComboBoxCellEditor((Composite)ParameterBindingsUIComponent.this.table.getTable(), new String[0]);
                CCombo combo = (CCombo)this.cellEditor.getControl();
                combo.setVisibleItemCount(Integer.MAX_VALUE);
                combo.setEditable(false);
            }

            protected boolean canEdit(Object element) {
                ParameterRef ref = (ParameterRef)element;
                this.updateKeysAndLabels(ref);
                if (ParameterBindingsUIComponent.this.referencedParameters.containsKey(ref.getName())) {
                    return this.depTypeArgKeys.length != 0;
                }
                return false;
            }

            protected Object getValue(Object element) {
                if (!this.canEdit(element)) {
                    throw new AssertionError((Object)"can't be edited");
                }
                ParameterRef ref = (ParameterRef)element;
                Dependency dep = ParameterBindingsUIComponent.this.getDependency(ref.getName());
                Object valueDepTypeArg = null;
                if (dep != null) {
                    valueDepTypeArg = dep.getArgument();
                }
                int value = 0;
                int i = 0;
                int size = this.depTypeArgKeys.length;
                while (i < size) {
                    if (valueDepTypeArg != null && valueDepTypeArg.equals(this.depTypeArgKeys[i])) {
                        value = i;
                    }
                    ++i;
                }
                return value;
            }

            protected void setValue(Object element, Object value) {
                if (!this.canEdit(element)) {
                    throw new AssertionError((Object)"can't be edited");
                }
                int index = (Integer)value;
                ParameterRef ref = (ParameterRef)element;
                Dependency curDep = ParameterBindingsUIComponent.this.getDependency(ref.getName());
                Object depType = curDep.getType();
                Object depTypeArg = index > -1 ? this.depTypeArgKeys[index] : null;
                Dependency dep = new Dependency(depType, depTypeArg);
                ParameterBindingsUIComponent.this.volatileBindings.put(ref.getName(), dep);
                ParameterBindingsUIComponent.this.asyncUpdateParameters();
            }

            protected CellEditor getCellEditor(Object element) {
                if (!this.canEdit(element)) {
                    throw new AssertionError((Object)"can't be edited");
                }
                this.cellEditor.setItems(this.depTypeArgLabels);
                return this.cellEditor;
            }

            private void updateKeysAndLabels(ParameterRef ref) {
                Dependency curDep = ParameterBindingsUIComponent.this.getDependency(ref.getName());
                Map<Object, Object> depTypeArgs = curDep != null ? ParameterBindingsUIComponent.this.dependencyProvider.getDependencyTypeArguments(curDep.getType(), ref.getDataType(), null) : Collections.emptyMap();
                this.depTypeArgKeys = new Object[depTypeArgs.size()];
                this.depTypeArgLabels = new String[depTypeArgs.size()];
                int i = 0;
                for (Map.Entry<Object, Object> depTypeArg : depTypeArgs.entrySet()) {
                    this.depTypeArgKeys[i] = depTypeArg.getKey();
                    this.depTypeArgLabels[i] = (String)depTypeArg.getValue();
                    ++i;
                }
            }
        });
        return area;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.colour_errorBackground != null) {
            this.colour_errorBackground.dispose();
        }
        if (this.colour_lowLightForeground != null) {
            this.colour_lowLightForeground.dispose();
        }
    }

    protected ParameterRef getSelectedParameter() {
        IStructuredSelection selection = (IStructuredSelection)this.table.getSelection();
        ParameterRef parameterRef = (ParameterRef)selection.getFirstElement();
        return parameterRef;
    }

    protected Dependency getDependency(String parameterName) {
        Dependency dependency = this.volatileBindings.containsKey(parameterName) ? this.volatileBindings.get(parameterName) : this.dependencyProvider.getDependencyOf(parameterName);
        return dependency;
    }

    protected void updateParameters() {
        Object msg;
        this.volatileBindings.keySet().retainAll(this.referencedParameters.keySet());
        boolean errorFound = false;
        this.erroneousParameters.clear();
        for (ParameterRef ref : this.referencedParameters.values()) {
            if (this.dependencyProvider.parameterExists(ref.getName())) continue;
            Dependency dep = this.volatileBindings.get(ref.getName());
            if (dep == null) {
                this.erroneousParameters.add(ref.getName());
                String msg2 = "The parameter '%s' needs a dependency assigned to it!";
                msg2 = String.format(msg2, ref.getName());
                this.setMessage(3, msg2);
                errorFound = true;
                continue;
            }
            Map<Object, String> depTypeArgs = this.dependencyProvider.getDependencyTypeArguments(dep.getType(), ref.getDataType(), null);
            if (depTypeArgs.size() != 0) continue;
            this.erroneousParameters.add(ref.getName());
            msg = "The dependency type '%s' of parameter '%s' requires an argument but there's none available! Please select different dependency type.";
            msg = String.format((String)msg, this.dependencyProvider.getLabelForType(dep.getType()), ref.getName());
            this.setMessage(3, (String)msg);
            errorFound = true;
        }
        LinkedHashMap<String, ParameterRef> allParameters = new LinkedHashMap<String, ParameterRef>();
        msg = this.dependencyProvider.getParameters();
        int depTypeArgs = ((ParameterRef[])msg).length;
        int n = 0;
        while (n < depTypeArgs) {
            ParameterRef ref = msg[n];
            allParameters.put(ref.getName(), ref);
            ++n;
        }
        for (ParameterRef ref : this.referencedParameters.values()) {
            ParameterRef temp = (ParameterRef)allParameters.get(ref.getName());
            if (temp == null) {
                allParameters.put(ref.getName(), ref);
                continue;
            }
            if (temp.getDataType() == ref.getDataType()) continue;
            this.erroneousParameters.add(ref.getName());
            msg = "The parameter '%s' is used multiple times but with different data types!";
            msg = String.format((String)msg, ref.getName());
            this.setMessage(3, (String)msg);
            errorFound = true;
        }
        if (!errorFound) {
            this.setMessage(3, null);
            for (String paramName : this.referencedParameters.keySet()) {
                this.resultBindings.put(paramName, this.getDependency(paramName));
            }
        }
        this.table.setInput((Object)allParameters.values().toArray(new ParameterRef[allParameters.size()]));
    }

    protected void asyncUpdateParameters() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                ParameterBindingsUIComponent.this.updateParameters();
            }
        });
    }

    public int getMessageType() {
        return this.messageType;
    }

    public String getMessage() {
        return this.message;
    }

    protected void setMessage(int messageType, String message) {
        if (messageType != 0 && messageType != 1 && messageType != 2 && messageType != 3) {
            throw new IllegalArgumentException();
        }
        if (messageType == 0) {
            this.messageType = 0;
            this.message = null;
        } else {
            this.messageType = messageType;
            this.message = message;
        }
        for (MessageChangeListener listener : this.messageChangeListeners) {
            listener.messageChanged(this.messageType, this.message);
        }
    }

    public void addMessageChangeListener(MessageChangeListener listener) {
        if (!this.messageChangeListeners.contains(listener)) {
            this.messageChangeListeners.add(listener);
        }
    }

    public void removeMessageChangeListener(MessageChangeListener listener) {
        this.messageChangeListeners.remove(listener);
    }

    public void setParameterReferences(ParameterRef[] paramRefs) {
        ArgChecks.checkForNulls(paramRefs, "paramRefs");
        this.referencedParameters.clear();
        ParameterRef[] parameterRefArray = paramRefs;
        int n = paramRefs.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterRef ref = parameterRefArray[n2];
            this.referencedParameters.put(ref.getName(), ref);
            ++n2;
        }
        this.updateParameters();
    }

    public void setParameterBindings(Map<String, Dependency> parameterBindings) {
        ArgChecks.checkForNulls(parameterBindings, "parameterBindings");
        this.volatileBindings.clear();
        for (String parameterName : parameterBindings.keySet()) {
            Dependency existingDependency;
            Dependency dependency = parameterBindings.get(parameterName);
            if (dependency.equals(existingDependency = this.dependencyProvider.getDependencyOf(parameterName))) continue;
            this.volatileBindings.put(parameterName, dependency);
        }
        this.updateParameters();
    }

    public Map<String, Dependency> getParameterBindings() {
        return new HashMap<String, Dependency>(this.resultBindings);
    }

    <T> T getFirstElement(Collection<T> collection) {
        Iterator<T> it = collection.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    static Font deriveFontStyle(Font originalFont, int style) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = originalFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontDataElement = fontDataArray[n2];
            fontDataElement.setStyle(style);
            ++n2;
        }
        Font derivedFont = new Font(originalFont.getDevice(), fontData);
        return derivedFont;
    }

    class BindingTableColumnLabelProvider
    extends ColumnLabelProvider {
        private Font cachedFor;
        private Font cachedFont;

        BindingTableColumnLabelProvider() {
        }

        public Color getBackground(Object element) {
            ParameterRef parameterRef = (ParameterRef)element;
            if (ParameterBindingsUIComponent.this.erroneousParameters.contains(parameterRef.getName())) {
                return ParameterBindingsUIComponent.this.colour_errorBackground;
            }
            return null;
        }

        public Color getForeground(Object element) {
            ParameterRef parameterRef = (ParameterRef)element;
            if (ParameterBindingsUIComponent.this.referencedParameters.containsKey(parameterRef.getName())) {
                return null;
            }
            return ParameterBindingsUIComponent.this.colour_lowLightForeground;
        }

        public void update(ViewerCell cell) {
            super.update(cell);
            ParameterRef parameterRef = (ParameterRef)cell.getElement();
            if (!ParameterBindingsUIComponent.this.dependencyProvider.parameterExists(parameterRef.getName())) {
                Font font = cell.getViewerRow().getFont(cell.getColumnIndex());
                if (font.equals((Object)this.cachedFor)) {
                    font = this.cachedFont;
                } else {
                    if (this.cachedFont != null) {
                        this.cachedFont.dispose();
                    }
                    this.cachedFor = font;
                    font = this.cachedFont = ParameterBindingsUIComponent.deriveFontStyle(font, 1);
                }
                cell.setFont(font);
            }
        }

        public void dispose() {
            super.dispose();
            if (this.cachedFont != null) {
                this.cachedFont.dispose();
            }
        }
    }
}

