/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.updatemanager;

import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.updatemanager.ChangeListener;
import de.aristaflow.adept2.core.updatemanager.PropertyChangeEvent;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;
import org.eclipse.swt.widgets.Display;

public class PVPUpdateManager
extends AbstractADEPT2Service
implements UpdateManager {
    private Map<Object, SortedMap<Integer, List<ChangeListener>>> observedObjects;
    private Map<ChangeListener, Map<Object, Set<Integer>>> registeredListeners;
    private Queue<EventQueueItem> eventQueue = new ConcurrentLinkedQueue<EventQueueItem>();

    public PVPUpdateManager(Configuration configuration, Registry registry) {
        super(configuration, registry);
        this.observedObjects = new HashMap<Object, SortedMap<Integer, List<ChangeListener>>>();
        this.registeredListeners = new HashMap<ChangeListener, Map<Object, Set<Integer>>>();
    }

    @Override
    public void addListener(Object what, ChangeListener callback) {
        this.addListener(what, callback, 10000);
    }

    @Override
    public synchronized void addListener(Object what, ChangeListener callback, int priority) {
        Set<Integer> set;
        Map<Object, Object> map;
        SortedMap<Object, Object> priorityListener = null;
        List<ChangeListener> listeners = null;
        if (this.observedObjects.containsKey(what)) {
            priorityListener = this.observedObjects.get(what);
            if (priorityListener.containsKey(priority)) {
                listeners = (List)priorityListener.get(priority);
            } else {
                listeners = new ArrayList();
                priorityListener.put(priority, listeners);
            }
        } else {
            priorityListener = new TreeMap();
            listeners = new ArrayList();
            priorityListener.put(priority, listeners);
            this.observedObjects.put(what, priorityListener);
        }
        listeners.add(callback);
        if (this.registeredListeners.containsKey(callback)) {
            map = this.registeredListeners.get(callback);
        } else {
            map = new HashMap();
            this.registeredListeners.put(callback, map);
        }
        if (map.containsKey(what)) {
            set = (Set)map.get(what);
        } else {
            set = new HashSet();
            map.put(what, set);
        }
        set.add(priority);
    }

    @Override
    public synchronized void removeListener(Object what, ChangeListener callback) {
        if (!this.registeredListeners.containsKey(callback) || !this.observedObjects.containsKey(what)) {
            return;
        }
        if (!this.registeredListeners.get(callback).containsKey(what)) {
            String msg = String.format("The given change listener (%s) is not registered  for the object %s. Ignoring.", callback, what.toString());
            this.logger.log(Level.WARNING, msg);
            return;
        }
        Set<Integer> priorities = this.registeredListeners.get(callback).get(what);
        for (Integer prio : priorities) {
            Map priorityMap = this.observedObjects.get(what);
            List list = (List)priorityMap.get(prio);
            list.remove(callback);
            if (list.isEmpty()) {
                priorityMap.remove(prio);
            }
            if (!priorityMap.isEmpty()) continue;
            this.observedObjects.remove(what);
        }
        Map<Object, Set<Integer>> objectMap = this.registeredListeners.get(callback);
        objectMap.remove(what);
        if (objectMap.isEmpty()) {
            this.registeredListeners.remove(callback);
        }
    }

    @Override
    public void firePropertyChange(Object procElement, Object prop) {
        this.logger.info("Got property change for " + procElement + " (property " + prop + ")");
        this.firePropertyChange(procElement, prop, null, null);
    }

    @Override
    public void firePropertyChange(Object procElement, Object prop, Object newValue) {
        this.firePropertyChange(procElement, prop, null, newValue);
    }

    @Override
    public void firePropertyChange(Object procElement, Object prop, Object oldValue, Object newValue) {
        PropertyChangeEvent pce = new PropertyChangeEvent(procElement, prop, oldValue, newValue);
        this.queuePropertyChanges(procElement, pce);
    }

    protected void queuePropertyChanges(Object procElement, PropertyChangeEvent pce) {
        if (!this.eventQueue.offer(new EventQueueItem(procElement, pce))) {
            this.logger.severe("Capacity of property changed queue is achieved. Had to drop property changed event!");
        }
    }

    @Override
    public void sendPropertyChanges() {
        if (Display.getDefault().getThread().equals(Thread.currentThread())) {
            new UpdateRequest().run();
        } else {
            new Thread((Runnable)new UpdateRequest(), "PVPUpdateManager.sendPropertyChanges-Thread").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void asyncSendPropertyChanges() {
        EventQueueItem item = null;
        item = this.eventQueue.poll();
        while (item != null) {
            boolean globalListenersPresent;
            PVPUpdateManager pVPUpdateManager = this;
            synchronized (pVPUpdateManager) {
                globalListenersPresent = this.observedObjects.containsKey(null);
            }
            if (globalListenersPresent) {
                this.callListenersForQueueItem(new EventQueueItem(null, item.pce));
            }
            pVPUpdateManager = this;
            synchronized (pVPUpdateManager) {
                globalListenersPresent = this.observedObjects.containsKey(item.procElement);
            }
            if (globalListenersPresent) {
                this.callListenersForQueueItem(item);
            }
            item = this.eventQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callListenersForQueueItem(EventQueueItem item) {
        SortedMap<Integer, List<ChangeListener>> priorityListeners;
        PVPUpdateManager pVPUpdateManager = this;
        synchronized (pVPUpdateManager) {
            priorityListeners = this.observedObjects.get(item.procElement);
        }
        for (int priority : priorityListeners.keySet()) {
            ArrayList listenersCopy;
            PVPUpdateManager pVPUpdateManager2 = this;
            synchronized (pVPUpdateManager2) {
                List listeners = (List)priorityListeners.get(priority);
                listenersCopy = new ArrayList(listeners);
            }
            for (ChangeListener listener : listenersCopy) {
                try {
                    listener.propertyChange(item.pce);
                }
                catch (RuntimeException re) {
                    String message = String.format("PropertyChange of change listener '%s' failed while executing property change event '%s' with exception '%s'.", listener.getClass().getName(), item.pce.getClass(), re.getClass().getName());
                    this.logger.log(Level.SEVERE, message, re);
                }
            }
        }
    }

    private static class EventQueueItem {
        public Object procElement;
        public PropertyChangeEvent pce;

        public EventQueueItem(Object procElement, PropertyChangeEvent pce) {
            this.procElement = procElement;
            this.pce = pce;
        }
    }

    protected class UpdateRequest
    implements Runnable {
        @Override
        public void run() {
            PVPUpdateManager.this.asyncSendPropertyChanges();
        }
    }
}

