/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util;

import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;

public class CalendarToolTip
extends ToolTip {
    protected final DateTime dateWidget;
    protected volatile boolean changed;
    protected boolean shown;
    protected final Set<ToolTipListener> listener;

    public CalendarToolTip(Control control, DateTime dateWidget) {
        super(control, 2, false);
        this.dateWidget = dateWidget;
        this.shown = false;
        this.listener = new HashSet<ToolTipListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToolTipListener(ToolTipListener listener) {
        ArgChecks.checkForNull(listener, "listener");
        ToolTipListener toolTipListener = listener;
        synchronized (toolTipListener) {
            this.listener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToolTipListener(ToolTipListener listener) {
        ArgChecks.checkForNull(listener, "listener");
        ToolTipListener toolTipListener = listener;
        synchronized (toolTipListener) {
            this.listener.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Composite createToolTipContentArea(Event event, Composite parent) {
        ToolTipListener[] current;
        final DateTime ret = new DateTime(parent, 1024);
        ret.setYear(this.dateWidget.getYear());
        ret.setMonth(this.dateWidget.getMonth());
        ret.setDay(this.dateWidget.getDay());
        ret.setEnabled(true);
        this.changed = false;
        this.shown = true;
        ret.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean bl = CalendarToolTip.this.changed = CalendarToolTip.this.dateWidget.getDay() != ret.getDay() || CalendarToolTip.this.dateWidget.getMonth() != ret.getMonth() || CalendarToolTip.this.dateWidget.getYear() != ret.getYear();
                if (CalendarToolTip.this.changed) {
                    CalendarToolTip.this.dateWidget.setYear(ret.getYear());
                    CalendarToolTip.this.dateWidget.setMonth(ret.getMonth());
                    CalendarToolTip.this.dateWidget.setDay(ret.getDay());
                }
            }
        });
        Set<ToolTipListener> set = this.listener;
        synchronized (set) {
            current = this.listener.toArray(new ToolTipListener[this.listener.size()]);
        }
        ToolTipListener[] toolTipListenerArray = current;
        int n = current.length;
        int n2 = 0;
        while (n2 < n) {
            ToolTipListener listener = toolTipListenerArray[n2];
            listener.toolTipCreated();
            ++n2;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterHideToolTip(Event event) {
        super.afterHideToolTip(event);
        if (this.shown) {
            ToolTipListener[] current;
            Set<ToolTipListener> set = this.listener;
            synchronized (set) {
                current = this.listener.toArray(new ToolTipListener[this.listener.size()]);
            }
            ToolTipListener[] toolTipListenerArray = current;
            int n = current.length;
            int n2 = 0;
            while (n2 < n) {
                ToolTipListener listener = toolTipListenerArray[n2];
                listener.toolTipHidden(this.changed);
                ++n2;
            }
            this.shown = false;
        }
    }

    public static interface ToolTipListener {
        public void toolTipCreated();

        public void toolTipHidden(boolean var1);
    }
}

