/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util;

import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public class CheckBoxManager {
    private SelectionListener internalListener;
    private Map<Button, List<Control>> controls = new HashMap<Button, List<Control>>();

    public CheckBoxManager() {
        this.internalListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    CheckBoxManager.this.check((Button)e.widget, true);
                } else {
                    CheckBoxManager.this.check((Button)e.widget, false);
                }
            }
        };
    }

    public void add(Button checkButton, Control ... controls) {
        ArgChecks.checkForNull(checkButton, "checkButton");
        ArgChecks.checkForNulls(controls, "controls");
        if ((checkButton.getStyle() & 0x20) == 0) {
            throw new IllegalArgumentException("button must be a check button!");
        }
        if (!this.controls.containsKey(checkButton)) {
            this.controls.put(checkButton, new ArrayList());
            checkButton.addSelectionListener(this.internalListener);
        }
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            List<Control> list = this.controls.get(checkButton);
            if (!list.contains(control)) {
                list.add(control);
                if (!checkButton.getSelection()) {
                    control.setEnabled(false);
                }
            }
            ++n2;
        }
    }

    public void check(Button checkButton, boolean isChecked) {
        ArgChecks.checkForNull(checkButton, "checkButton");
        this.checkButton(checkButton);
        for (Button checkTemp : this.controls.keySet()) {
            if (checkTemp != checkButton) continue;
            checkButton.setSelection(isChecked);
            for (Control control : this.controls.get(checkButton)) {
                control.setEnabled(isChecked);
            }
        }
    }

    private void checkButton(Button checkButton) {
        if (!this.controls.containsKey(checkButton)) {
            throw new IllegalArgumentException("check button is not registered in this manager");
        }
    }
}

