/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util;

import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FocusGroup {
    List<FocusListener> listeners = new ArrayList<FocusListener>();
    boolean hadFocus = false;
    boolean hasFocus = false;
    FocusEvent latestEvent;
    private Shell shell;
    private FocusListener internalListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
            FocusGroup.this.hasFocus = false;
            FocusGroup.this.latestEvent = e;
            FocusGroup.this.queueFocusCheck();
        }

        public void focusGained(FocusEvent e) {
            FocusGroup.this.hasFocus = true;
            FocusGroup.this.latestEvent = e;
            FocusGroup.this.queueFocusCheck();
        }
    };
    boolean focusCheckPending = false;

    public void add(Control control) {
        ArgChecks.checkForNull(control, "control");
        this.initShell(control);
        if (control instanceof Composite) {
            this.add((Composite)control);
        } else {
            control.addFocusListener(this.internalListener);
        }
    }

    public void add(Composite composite) {
        ArgChecks.checkForNull(composite, "composite");
        this.initShell((Control)composite);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            this.add(child);
            ++n2;
        }
    }

    private void initShell(Control control) {
        if (this.shell == null) {
            this.shell = control.getShell();
        } else if (!this.shell.equals(control.getShell())) {
            throw new IllegalArgumentException("The controls in a FocusGroup must all be children of the same shell!");
        }
    }

    void queueFocusCheck() {
        if (!this.focusCheckPending) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!FocusGroup.this.hadFocus && FocusGroup.this.hasFocus) {
                        for (FocusListener listener : FocusGroup.this.listeners) {
                            listener.focusGained(FocusGroup.this.latestEvent);
                        }
                    } else if (FocusGroup.this.hadFocus && !FocusGroup.this.hasFocus) {
                        for (FocusListener listener : FocusGroup.this.listeners) {
                            listener.focusLost(FocusGroup.this.latestEvent);
                        }
                    }
                    FocusGroup.this.hadFocus = FocusGroup.this.hasFocus;
                    FocusGroup.this.focusCheckPending = false;
                }
            });
        }
    }

    public void addFocusListener(FocusListener listener) {
        ArgChecks.checkForNull(listener, "listener");
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeFocusListener(FocusListener listener) {
        ArgChecks.checkForNull(listener, "listener");
        this.listeners.remove(listener);
    }
}

