/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;

public class FontTools {
    private FontTools() {
    }

    public static Font deriveFontStyle(Font originalFont, int style) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = originalFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontDataElement = fontDataArray[n2];
            fontDataElement.setStyle(style);
            ++n2;
        }
        Font derivedFont = new Font(originalFont.getDevice(), fontData);
        return derivedFont;
    }

    public static Font deriveFont(Font originalFont, int height, int style) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = originalFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontDataElement = fontDataArray[n2];
            fontDataElement.setHeight(height);
            fontDataElement.setStyle(style);
            ++n2;
        }
        Font derivedFont = new Font(originalFont.getDevice(), fontData);
        return derivedFont;
    }

    public static Font deriveFontHeightDelta(Font originalFont, int heightDelta, int style) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = originalFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontDataElement = fontDataArray[n2];
            fontDataElement.setHeight(fontDataElement.getHeight() + heightDelta);
            fontDataElement.setStyle(style);
            ++n2;
        }
        Font derivedFont = new Font(originalFont.getDevice(), fontData);
        return derivedFont;
    }

    public static void changeFont(Control control, int heightDelta, int style) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = control.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontDataElement = fontDataArray[n2];
            fontDataElement.setHeight(fontDataElement.getHeight() + heightDelta);
            if (style != -1) {
                fontDataElement.setStyle(style);
            }
            ++n2;
        }
        final Font derivedFont = new Font((Device)control.getDisplay(), fontData);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                derivedFont.dispose();
            }
        });
        control.setFont(derivedFont);
    }
}

