/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util;

import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;

public class RAPDisplayTools {
    protected static final Logger staticLogger = LoggerTools.getLogger(RAPDisplayTools.class);
    public static long STATIC_CREATE_TIMEOUT = 50000L;
    public static long STATIC_FINISH_TIMEOUT = 30000L;
    public static long STATIC_NOTIFICATION_TIMEOUT = 15000L;
    public static long STATIC_TIMEOUT = 20000L;
    protected final Display display;
    protected Workbench workbench;
    protected final Logger logger;
    private final long CREATE_TIMEOUT;
    private final long FINISH_TIMEOUT;
    private final long NOTIFICATION_TIMEOUT;
    private final long TIMEOUT;
    private static final long CREATE_NOT_EXECUTED = 17800001L;
    private static final long CREATE_INTERRUPTED = 17800002L;
    private static final long FINISH_NOT_EXECUTED = 17800003L;
    private static final long FINISH_INTERRUPTED = 17800004L;
    private static final long NOTIFICATION_NOT_EXECUTED = 17800005L;
    private static final long NOTIFICATION_INTERRUPTED = 17800006L;
    private static final long NOT_EXECUTED = 17800007L;
    private static final long INTERRUPTED = 17800008L;
    private static final String CREATE_SYNC_EXEC_NOT_SUCCESSFUL = "CREATE_SYNC_EXEC_NOT_SUCCESSFUL";
    private static final String CREATE_SYNC_EXEC_INTERRUPTED = "CREATE_SYNC_EXEC_INTERRUPTED";
    private static final String FINISH_SYNC_EXEC_NOT_SUCCESSFUL = "FINISH_SYNC_EXEC_NOT_SUCCESSFUL";
    private static final String FINISH_SYNC_EXEC_INTERRUPTED = "FINISH_SYNC_EXEC_INTERRUPTED";
    private static final String NOTIFICATION_SYNC_EXEC_NOT_SUCCESSFUL = "NOTIFICATION_SYNC_EXEC_NOT_SUCCESSFUL";
    private static final String NOTIFICATION_SYNC_EXEC_INTERRUPTED = "NOTIFICATION_SYNC_EXEC_INTERRUPTED";
    private static final String SYNC_EXEC_NOT_SUCCESSFUL = "SYNC_EXEC_NOT_SUCCESSFUL";
    private static final String SYNC_EXEC_INTERRUPTED = "SYNC_EXEC_INTERRUPTED";

    public static boolean syncExecuted(Display display, final Runnable runnable, long timeout) throws InterruptedException {
        boolean ret;
        final boolean[] waiting = new boolean[]{true};
        final CountDownLatch asyncExecTermination = new CountDownLatch(1);
        if (Thread.currentThread() == display.getThread()) {
            display.syncExec(runnable);
            ret = true;
        } else {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (waiting[0]) {
                        runnable.run();
                        asyncExecTermination.countDown();
                    }
                }
            });
            try {
                ret = asyncExecTermination.await(timeout, TimeUnit.MILLISECONDS);
                waiting[0] = false;
            }
            catch (InterruptedException ie) {
                waiting[0] = false;
                throw ie;
            }
        }
        return ret;
    }

    public static void syncExecutedForCreationAFE(Display display, Runnable runnable) {
        try {
            if (!RAPDisplayTools.syncExecuted(display, runnable, STATIC_CREATE_TIMEOUT)) {
                String msg = "Sync execution for creation was not successful.";
                throw new ApplicationFailedException(msg, CREATE_SYNC_EXEC_NOT_SUCCESSFUL, 17800001L);
            }
        }
        catch (InterruptedException e) {
            String msg = "Sync execution for creation was interrupted.";
            throw new ApplicationFailedException(msg, CREATE_SYNC_EXEC_INTERRUPTED, 17800002L, e);
        }
    }

    public static boolean syncExecutedForFinish(Display display, Runnable runnable) {
        boolean executed = false;
        try {
            executed = RAPDisplayTools.syncExecuted(display, runnable, STATIC_FINISH_TIMEOUT);
        }
        catch (InterruptedException interruptedException) {}
        return executed;
    }

    public static boolean syncExecutedForNotification(Display display, Runnable runnable) {
        boolean executed = false;
        try {
            executed = RAPDisplayTools.syncExecuted(display, runnable, STATIC_NOTIFICATION_TIMEOUT);
        }
        catch (InterruptedException interruptedException) {}
        return executed;
    }

    public static boolean syncExecuted(Display display, Runnable runnable) {
        boolean executed = false;
        try {
            executed = RAPDisplayTools.syncExecuted(display, runnable, STATIC_TIMEOUT);
        }
        catch (InterruptedException interruptedException) {}
        return executed;
    }

    public static void syncExecutedIgnored(Display display, Runnable runnable) {
        try {
            if (!RAPDisplayTools.syncExecuted(display, runnable, STATIC_TIMEOUT)) {
                String msg = String.format("The runnable '%s' could not be executed synchronously. It will be ignored!", runnable);
                staticLogger.warning(msg);
            } else {
                staticLogger.fine(String.format("The runnable '%s' was executed successfully.", runnable));
            }
        }
        catch (InterruptedException interruptedException) {
            String msg = String.format("The runnable '%s' was interrupted during synchronous execution. It will be ignored!", runnable);
            staticLogger.warning(msg);
        }
    }

    public RAPDisplayTools(Display display) {
        this(display, 50000L, 30000L, 15000L, 20000L);
    }

    public RAPDisplayTools(Display display, long createTimeout, long finishTimeout, long notificationTimeout, long timeout) {
        this.display = display;
        this.CREATE_TIMEOUT = createTimeout;
        this.FINISH_TIMEOUT = finishTimeout;
        this.NOTIFICATION_TIMEOUT = notificationTimeout;
        this.TIMEOUT = timeout;
        this.logger = LoggerTools.getLogger(this);
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                RAPDisplayTools.this.workbench = (Workbench)PlatformUI.getWorkbench();
                RAPDisplayTools.this.logger.info("Set workbench to " + RAPDisplayTools.this.workbench);
            }
        });
    }

    public boolean asyncExec(Runnable runnable) {
        boolean ret = false;
        if (this.isDisplayThreadDispatching()) {
            this.display.asyncExec(runnable);
            ret = true;
        } else {
            this.logger.warning("Ignored asyncExec! " + runnable);
        }
        return ret;
    }

    public boolean syncExec(Runnable runnable) {
        boolean ret = false;
        if (this.isDisplayThreadDispatching()) {
            this.display.syncExec(runnable);
            ret = true;
        } else {
            this.logger.warning("Ignored syncExec! " + runnable);
        }
        return ret;
    }

    public boolean syncExecuted(final Runnable runnable, long timeout) throws InterruptedException {
        boolean ret = false;
        final boolean[] waiting = new boolean[]{true};
        final CountDownLatch asyncExecTermination = new CountDownLatch(1);
        if (this.isDisplayThreadDispatching()) {
            if (Thread.currentThread() == this.display.getThread()) {
                this.display.syncExec(runnable);
                ret = true;
            } else {
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (waiting[0]) {
                            runnable.run();
                            asyncExecTermination.countDown();
                        }
                    }
                });
                try {
                    ret = asyncExecTermination.await(timeout, TimeUnit.MILLISECONDS);
                    waiting[0] = false;
                }
                catch (InterruptedException ie) {
                    waiting[0] = false;
                    throw ie;
                }
            }
        } else {
            this.logger.warning("Ignored syncExecuted! " + runnable);
        }
        return ret;
    }

    public void syncExecutedForCreationAFE(Runnable runnable) {
        try {
            if (!this.syncExecuted(runnable, this.CREATE_TIMEOUT)) {
                String msg = "Sync execution for creation was not successful.";
                throw new ApplicationFailedException(msg, CREATE_SYNC_EXEC_NOT_SUCCESSFUL, 17800001L);
            }
        }
        catch (InterruptedException e) {
            String msg = "Sync execution for creation was interrupted.";
            throw new ApplicationFailedException(msg, CREATE_SYNC_EXEC_INTERRUPTED, 17800002L, e);
        }
    }

    public boolean syncExecutedForFinish(Runnable runnable) {
        boolean executed = false;
        try {
            executed = this.syncExecuted(runnable, this.FINISH_TIMEOUT);
        }
        catch (InterruptedException interruptedException) {}
        return executed;
    }

    public boolean syncExecutedForNotification(Runnable runnable) {
        boolean executed = false;
        try {
            executed = this.syncExecuted(runnable, this.NOTIFICATION_TIMEOUT);
        }
        catch (InterruptedException interruptedException) {}
        return executed;
    }

    public boolean syncExecuted(Runnable runnable) {
        boolean executed = false;
        try {
            executed = this.syncExecuted(runnable, this.TIMEOUT);
        }
        catch (InterruptedException interruptedException) {}
        return executed;
    }

    public void syncExecutedIgnored(Runnable runnable) {
        try {
            if (!this.syncExecuted(runnable, this.TIMEOUT)) {
                String msg = String.format("The runnable '%s' could not be executed synchronously. It will be ignored!", runnable);
                this.logger.warning(msg);
            } else {
                this.logger.fine(String.format("The runnable '%s' was executed successfully.", runnable));
            }
        }
        catch (InterruptedException interruptedException) {
            String msg = String.format("The runnable '%s' was interrupted during synchronous execution. It will be ignored!", runnable);
            this.logger.warning(msg);
        }
    }

    public boolean isDisplayThreadDispatching() {
        return this.workbench == null || !this.workbench.isClosing() && this.workbench.isRunning();
    }
}

