/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util;

import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RadioGroupManager {
    private Composite radioGroup;
    private SelectionListener internalListener;
    private Map<Button, List<Control>> controls = new HashMap<Button, List<Control>>();
    private Button selectedRadio;

    public RadioGroupManager(Composite radioGroup) {
        ArgChecks.checkForNull(radioGroup, "radioGroup");
        this.radioGroup = radioGroup;
        this.internalListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RadioGroupManager.this.radioSelected((Button)e.widget);
            }
        };
        Control[] controlArray = radioGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Button && (control.getStyle() & 0x10) != 0) {
                this.add((Button)control, new Control[0]);
            }
            ++n2;
        }
    }

    public void select(Button radio) {
        ArgChecks.checkForNull(radio, "radio");
        this.checkRadio(radio);
        for (Button radioTemp : this.controls.keySet()) {
            if (radioTemp == radio) {
                radioTemp.setSelection(true);
                continue;
            }
            radioTemp.setSelection(false);
        }
        this.radioSelected(radio);
    }

    public void add(Button radio, Control ... controls) {
        ArgChecks.checkForNull(radio, "radio");
        ArgChecks.checkForNulls(controls, "controls");
        if ((radio.getStyle() & 0x10) == 0) {
            throw new IllegalArgumentException("button must be a radio button!");
        }
        if (radio.getParent() != this.radioGroup) {
            throw new IllegalArgumentException("button is not part of this radio group!");
        }
        if (!this.controls.containsKey(radio)) {
            this.controls.put(radio, new ArrayList());
            radio.addSelectionListener(this.internalListener);
        }
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            List<Control> list = this.controls.get(radio);
            if (!list.contains(control)) {
                list.add(control);
                if (!radio.getSelection()) {
                    control.setEnabled(false);
                }
            }
            ++n2;
        }
    }

    private void checkRadio(Button radio) {
        if (!this.controls.containsKey(radio)) {
            throw new IllegalArgumentException("radio button is not registered for this radio group");
        }
    }

    void radioSelected(Button radio) {
        if (radio != this.selectedRadio) {
            if (this.selectedRadio != null) {
                for (Control control : this.controls.get(this.selectedRadio)) {
                    control.setEnabled(false);
                }
            }
            this.selectedRadio = radio;
            for (Control control : this.controls.get(this.selectedRadio)) {
                control.setEnabled(true);
            }
        }
    }
}

