/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util;

import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class UIComponent {
    Control control;

    protected UIComponent() {
    }

    protected final void initControl(Control control) {
        ArgChecks.checkForNull(control, "control");
        if (this.control != null) {
            throw new IllegalStateException("UI component was already initialised!");
        }
        this.control = control;
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UIComponent.this.control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UIComponent.this.dispose();
                    }
                });
            }
        });
    }

    public final Control getControl() {
        if (this.control == null) {
            throw new IllegalStateException("initControl(..) was not called!");
        }
        return this.control;
    }

    public boolean setFocus() {
        return this.getControl().setFocus();
    }

    public boolean hasFocus() {
        if (this.getControl().isFocusControl()) {
            return true;
        }
        if (this.getControl() instanceof Composite) {
            ArrayList<Composite> composites = new ArrayList<Composite>();
            composites.add((Composite)this.getControl());
            while (!composites.isEmpty()) {
                Composite composite = (Composite)composites.remove(composites.size() - 1);
                Control[] controlArray = composite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    if (child.isFocusControl()) {
                        return true;
                    }
                    if (child instanceof Composite) {
                        composites.add((Composite)child);
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    public void dispose() {
        if (this.control != null) {
            this.control.dispose();
        }
    }
}

