/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util;

import de.aristaflow.adept2.ui.icons.AristaFlowImageRegistry;
import de.aristaflow.adept2.ui.icons.customer.CustomImageRegistry;
import de.aristaflow.adept2.ui.icons.customer.IPointImageRegistry;
import de.aristaflow.adept2.ui.icons.customer.WJPImageRegistry;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;

public final class UIConstants {
    private static Theme THEME = Theme.ARISTAFLOW;
    public static boolean FMC_LABELS;
    private static final Image ECLIPSE_STANDARD_BANNER;
    private static final Image ARISTAFLOW_BANNER;
    private static final Image ARISTAFLOW_SLIM_BANNER;
    private static final Image IPOINT_BANNER;
    private static final Image WJP_BANNER;
    private static final Image CUSTOM_BANNER;
    private static final Image ECLIPSE_STANDARD_SIDE_BAR;
    private static final Image ARISTAFLOW_SIDE_BAR;
    private static final Image ARISTAFLOW_SLIM_SIDE_BAR;
    private static final Image IPOINT_SIDE_BAR;
    private static final Image WJP_SIDE_BAR;
    private static final Image CUSTOM_SIDE_BAR;
    private static final Image ECLIPSE_STANDARD_BANNER_FILL;
    private static final Image ARISTAFLOW_BANNER_FILL;
    private static final Image ARISTAFLOW_SLIM_BANNER_FILL;
    private static final Image IPOINT_BANNER_FILL;
    private static final Image WJP_BANNER_FILL;
    private static final Image CUSTOM_BANNER_FILL;
    public static final Font SUBHEADER_FONT;
    public static final Font FORM_HEADER_FONT;
    public static final Color LIGHT_GREY_COLOR;
    public static final Color WHITE_COLOR;
    public static final Color BLACK_COLOR;
    public static final Color DARK_GREY_COLOR;
    public static final Color ORANGE_COLOR;
    public static final Color RED_COLOR;
    public static final Color GREEN_COLOR;
    public static final Color BLUE_COLOR;
    public static final Color LIGHT_BLUE_COLOR;
    public static final Color YELLOW_COLOR;
    private static FormColors formColors;
    private static FormColors aristaFlowColors;
    private static FormColors wjpColors;
    private static FormColors iPointColors;
    private static FormColors customColors;
    private static Color foregroundColor;

    static {
        ECLIPSE_STANDARD_BANNER = AristaFlowImageRegistry.getImage("aristaflow-logo.png");
        ARISTAFLOW_BANNER = AristaFlowImageRegistry.getImage("aristaflow-logo.png");
        ARISTAFLOW_SLIM_BANNER = AristaFlowImageRegistry.getImage("arflow-right-slim.png");
        IPOINT_BANNER = IPointImageRegistry.getImage("key-and-logo.png");
        WJP_BANNER = WJPImageRegistry.getImage("wjp-jobrouter.png");
        CUSTOM_BANNER = CustomImageRegistry.getImage("custom-bannerright.png");
        ECLIPSE_STANDARD_SIDE_BAR = AristaFlowImageRegistry.getImage("aristaflow-bannerleft.png");
        ARISTAFLOW_SIDE_BAR = AristaFlowImageRegistry.getImage("aristaflow-bannerleft.png");
        ARISTAFLOW_SLIM_SIDE_BAR = AristaFlowImageRegistry.getImage("arflow-left-slim.png");
        IPOINT_SIDE_BAR = IPointImageRegistry.getImage("ipoint-bannerleft.png");
        WJP_SIDE_BAR = WJPImageRegistry.getImage("wjp-bannerleft.png");
        CUSTOM_SIDE_BAR = CustomImageRegistry.getImage("custom-bannerleft.png");
        ECLIPSE_STANDARD_BANNER_FILL = AristaFlowImageRegistry.getImage("aristaflow-fill.png");
        ARISTAFLOW_BANNER_FILL = AristaFlowImageRegistry.getImage("aristaflow-fill.png");
        ARISTAFLOW_SLIM_BANNER_FILL = AristaFlowImageRegistry.getImage("arflow-fill-slim.png");
        IPOINT_BANNER_FILL = IPointImageRegistry.getImage("ipoint-fill.png");
        WJP_BANNER_FILL = WJPImageRegistry.getImage("wjp-fill.png");
        CUSTOM_BANNER_FILL = CustomImageRegistry.getImage("custom-fill.png");
        SUBHEADER_FONT = new Font(null, "Arial", 10, 1);
        FORM_HEADER_FONT = new Font(null, "Arial", 18, 1);
        LIGHT_GREY_COLOR = new Color(null, 229, 229, 229);
        WHITE_COLOR = new Color(null, 255, 255, 255);
        BLACK_COLOR = new Color(null, 0, 0, 0);
        DARK_GREY_COLOR = new Color(null, 102, 102, 102);
        ORANGE_COLOR = new Color(null, 255, 207, 123);
        RED_COLOR = new Color(null, 255, 0, 0);
        GREEN_COLOR = new Color(null, 0, 128, 0);
        BLUE_COLOR = new Color(null, 0, 0, 128);
        LIGHT_BLUE_COLOR = new Color(null, 0, 127, 255);
        YELLOW_COLOR = new Color(null, 255, 205, 52);
        foregroundColor = BLUE_COLOR;
    }

    public static void initialiseColours(Configuration configuration) {
        String themeString = configuration.getString("Theme");
        if (themeString != null) {
            Theme theme;
            try {
                theme = Theme.valueOf(themeString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                theme = Theme.ARISTAFLOW;
            }
            THEME = theme;
        } else {
            THEME = Theme.ARISTAFLOW;
        }
        FMC_LABELS = Boolean.parseBoolean(configuration.getString("FMCLabels"));
    }

    public static FormColors getFormColors(Display display) {
        if (formColors == null) {
            formColors = new FormColors(display);
        }
        switch (THEME) {
            case ECLIPSE_STANDARD: {
                break;
            }
            case ARISTAFLOW: {
                formColors = UIConstants.getAristaFlowColors();
                break;
            }
            case ARISTAFLOW_SLIM: {
                formColors = UIConstants.getAristaFlowSlimColors();
                break;
            }
            case WJP: {
                formColors = UIConstants.getWJPColors();
                break;
            }
            case IPOINT: {
                formColors = UIConstants.getIPointColors();
                break;
            }
            case CUSTOM: {
                formColors = UIConstants.getCustomColors();
            }
        }
        return formColors;
    }

    public static Image getBannerImage() {
        Image image = null;
        switch (THEME) {
            case ECLIPSE_STANDARD: {
                image = ECLIPSE_STANDARD_BANNER;
                break;
            }
            case ARISTAFLOW: {
                image = ARISTAFLOW_BANNER;
                break;
            }
            case ARISTAFLOW_SLIM: {
                image = ARISTAFLOW_SLIM_BANNER;
                break;
            }
            case WJP: {
                image = WJP_BANNER;
                break;
            }
            case IPOINT: {
                image = IPOINT_BANNER;
                break;
            }
            case CUSTOM: {
                image = CUSTOM_BANNER;
            }
        }
        return image;
    }

    public static Image getBannerSideBar() {
        Image image = null;
        switch (THEME) {
            case ECLIPSE_STANDARD: {
                image = ECLIPSE_STANDARD_SIDE_BAR;
                break;
            }
            case ARISTAFLOW: {
                image = ARISTAFLOW_SIDE_BAR;
                break;
            }
            case ARISTAFLOW_SLIM: {
                image = ARISTAFLOW_SLIM_SIDE_BAR;
                break;
            }
            case WJP: {
                image = WJP_SIDE_BAR;
                break;
            }
            case IPOINT: {
                image = IPOINT_SIDE_BAR;
                break;
            }
            case CUSTOM: {
                image = CUSTOM_SIDE_BAR;
            }
        }
        return image;
    }

    public static Image getBannerFill() {
        Image image = null;
        switch (THEME) {
            case ECLIPSE_STANDARD: {
                image = ECLIPSE_STANDARD_BANNER_FILL;
                break;
            }
            case ARISTAFLOW: {
                image = ARISTAFLOW_BANNER_FILL;
                break;
            }
            case ARISTAFLOW_SLIM: {
                image = ARISTAFLOW_SLIM_BANNER_FILL;
                break;
            }
            case WJP: {
                image = WJP_BANNER_FILL;
                break;
            }
            case IPOINT: {
                image = IPOINT_BANNER_FILL;
                break;
            }
            case CUSTOM: {
                image = CUSTOM_BANNER_FILL;
            }
        }
        return image;
    }

    public static void setColors(Control control) {
        control.setForeground(foregroundColor);
        control.setFont(FORM_HEADER_FONT);
    }

    public static Color getForegroundColor() {
        return foregroundColor;
    }

    private static FormColors getAristaFlowColors() {
        if (aristaFlowColors == null) {
            formColors.createColor("org.eclipse.ui.forms.H_GRADIENT_START", WHITE_COLOR.getRGB());
            formColors.createColor("org.eclipse.ui.forms.H_GRADIENT_END", ORANGE_COLOR.getRGB());
            formColors.createColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", WHITE_COLOR.getRGB());
            formColors.createColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", WHITE_COLOR.getRGB());
            formColors.initializeSectionToolBarColors();
            formColors.createColor("org.eclipse.ui.forms.TB_BG", ORANGE_COLOR.getRGB());
            foregroundColor = BLUE_COLOR;
            aristaFlowColors = formColors;
        }
        return aristaFlowColors;
    }

    private static FormColors getAristaFlowSlimColors() {
        if (aristaFlowColors == null) {
            formColors.createColor("org.eclipse.ui.forms.H_GRADIENT_START", WHITE_COLOR.getRGB());
            formColors.createColor("org.eclipse.ui.forms.H_GRADIENT_END", LIGHT_GREY_COLOR.getRGB());
            formColors.createColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", WHITE_COLOR.getRGB());
            formColors.createColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", WHITE_COLOR.getRGB());
            formColors.initializeSectionToolBarColors();
            formColors.createColor("org.eclipse.ui.forms.TB_BG", LIGHT_GREY_COLOR.getRGB());
            foregroundColor = BLUE_COLOR;
            aristaFlowColors = formColors;
        }
        return aristaFlowColors;
    }

    private static FormColors getWJPColors() {
        if (wjpColors == null) {
            formColors.createColor("org.eclipse.ui.forms.H_GRADIENT_START", WHITE_COLOR.getRGB());
            formColors.createColor("org.eclipse.ui.forms.H_GRADIENT_END", YELLOW_COLOR.getRGB());
            formColors.createColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", YELLOW_COLOR.getRGB());
            formColors.initializeSectionToolBarColors();
            formColors.createColor("org.eclipse.ui.forms.TB_BG", YELLOW_COLOR.getRGB());
            foregroundColor = BLUE_COLOR;
            wjpColors = formColors;
        }
        return wjpColors;
    }

    private static FormColors getIPointColors() {
        if (iPointColors == null) {
            formColors.createColor("org.eclipse.ui.forms.H_GRADIENT_START", WHITE_COLOR.getRGB());
            formColors.createColor("org.eclipse.ui.forms.H_GRADIENT_END", LIGHT_GREY_COLOR.getRGB());
            formColors.createColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", LIGHT_GREY_COLOR.getRGB());
            formColors.initializeSectionToolBarColors();
            formColors.createColor("org.eclipse.ui.forms.TB_BG", LIGHT_GREY_COLOR.getRGB());
            foregroundColor = BLUE_COLOR;
            iPointColors = formColors;
        }
        return iPointColors;
    }

    private static FormColors getCustomColors() {
        if (customColors == null) {
            Color foreground;
            RGB font;
            RGB tbbg;
            RGB keyLine;
            RGB gradEnd;
            RGB gradStart;
            Properties prop = new Properties();
            try {
                prop.load(UIConstants.class.getResourceAsStream("colour.properties"));
                int r = Integer.parseInt(prop.getProperty("gradStart.R"));
                int g = Integer.parseInt(prop.getProperty("gradStart.G"));
                int b = Integer.parseInt(prop.getProperty("gradStart.B"));
                gradStart = new Color(null, r, g, b).getRGB();
                r = Integer.parseInt(prop.getProperty("gradEnd.R"));
                g = Integer.parseInt(prop.getProperty("gradEnd.G"));
                b = Integer.parseInt(prop.getProperty("gradEnd.B"));
                gradEnd = new Color(null, r, g, b).getRGB();
                r = Integer.parseInt(prop.getProperty("keyLine.R"));
                g = Integer.parseInt(prop.getProperty("keyLine.G"));
                b = Integer.parseInt(prop.getProperty("keyLine.B"));
                keyLine = new Color(null, r, g, b).getRGB();
                r = Integer.parseInt(prop.getProperty("tbbg.R"));
                g = Integer.parseInt(prop.getProperty("tbbg.G"));
                b = Integer.parseInt(prop.getProperty("tbbg.B"));
                tbbg = new Color(null, r, g, b).getRGB();
                r = Integer.parseInt(prop.getProperty("font.R"));
                g = Integer.parseInt(prop.getProperty("font.G"));
                b = Integer.parseInt(prop.getProperty("font.B"));
                font = new Color(null, r, g, b).getRGB();
                r = Integer.parseInt(prop.getProperty("foreground.R"));
                g = Integer.parseInt(prop.getProperty("foreground.G"));
                b = Integer.parseInt(prop.getProperty("foreground.B"));
                foreground = new Color(null, r, g, b);
            }
            catch (IOException iOException) {
                gradStart = WHITE_COLOR.getRGB();
                gradEnd = LIGHT_GREY_COLOR.getRGB();
                keyLine = LIGHT_GREY_COLOR.getRGB();
                tbbg = LIGHT_GREY_COLOR.getRGB();
                font = BLACK_COLOR.getRGB();
                foreground = BLUE_COLOR;
            }
            formColors.createColor("org.eclipse.ui.forms.H_GRADIENT_START", gradStart);
            formColors.createColor("org.eclipse.ui.forms.H_GRADIENT_END", gradEnd);
            formColors.createColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", keyLine);
            formColors.initializeSectionToolBarColors();
            formColors.createColor("org.eclipse.ui.forms.TB_BG", tbbg);
            formColors.createColor("org.eclipse.ui.forms.TITLE", font);
            formColors.createColor("org.eclipse.ui.forms.TB_FG", font);
            formColors.createColor("org.eclipse.ui.forms.TB_TOGGLE", font);
            foregroundColor = foreground;
            customColors = formColors;
        }
        return customColors;
    }

    private static enum Theme {
        ECLIPSE_STANDARD,
        ARISTAFLOW,
        ARISTAFLOW_SLIM,
        WJP,
        IPOINT,
        CUSTOM;

    }
}

