/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.columnlayout;

import de.aristaflow.adept2.util.ArgChecks;

public class ColumnData {
    private boolean isUserResizable = true;
    private int minWidth = 0;
    private int prefWidth = -1;
    private int maxWidth = Integer.MAX_VALUE;
    private float weight = 0.0f;
    boolean resizedByUser = false;
    float temp_sortIndex;
    int temp_columnIndex;

    public ColumnData() {
    }

    public ColumnData(int prefWidth) {
        this.setPrefWidth(prefWidth);
    }

    public ColumnData(int minWidth, int prefWidth) {
        this.setMinWidth(minWidth);
        this.setPrefWidth(prefWidth);
    }

    public ColumnData(int minWidth, int prefWidth, int maxWidth) {
        this.setMinWidth(minWidth);
        this.setPrefWidth(prefWidth);
        this.setMaxWidth(maxWidth);
    }

    public ColumnData(float weight) {
        this.setWeight(weight);
    }

    public ColumnData(int prefWidth, float weight) {
        this.setPrefWidth(prefWidth);
        this.setWeight(weight);
    }

    public ColumnData(float weight, int maxWidth) {
        this.setWeight(weight);
        this.setMaxWidth(maxWidth);
    }

    public ColumnData(int prefWidth, float weight, int maxWidth) {
        this.setPrefWidth(prefWidth);
        this.setWeight(weight);
        this.setMaxWidth(maxWidth);
    }

    public boolean isUserResizable() {
        return this.isUserResizable;
    }

    public ColumnData setUserResizable(boolean isUserResizable) {
        this.isUserResizable = isUserResizable;
        return this;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    private void setMinWidth(int minWidth) {
        ArgChecks.checkForNegative(minWidth, "minWidth");
        this.minWidth = minWidth;
    }

    public int getPrefWidth() {
        return this.prefWidth;
    }

    private void setPrefWidth(int prefWidth) {
        ArgChecks.check(prefWidth < 0 && prefWidth != -1, "prefWidth", "The parameter '%s' must either be non-negative or SWT.DEFAULT!");
        this.prefWidth = prefWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    private void setMaxWidth(int maxWidth) {
        ArgChecks.check(maxWidth <= 0 && maxWidth != -1, "maxWidth", "The parameter '%s' must either be positive or SWT.DEFAULT!");
        this.maxWidth = maxWidth;
    }

    public float getWeight() {
        return this.weight;
    }

    private void setWeight(float weight) {
        ArgChecks.checkForNegative(weight, "weight");
        this.weight = weight;
    }
}

