/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.columnlayout;

import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class ColumnLayout<C extends Item>
extends Layout {
    protected static final String WIDGETDATA_LISTENER_REGISTERED = String.valueOf(ColumnLayout.class.getName()) + "#ListenerRegistered";
    protected static final String WIDGETDATA_LAYOUT_DATA = String.valueOf(ColumnLayout.class.getName()) + "#ColumnLayoutData";
    protected static final String WIDGETDATA_CACHED_PACKED_WIDTH = String.valueOf(ColumnLayout.class.getName()) + "#ColumnCachedPackedWidth";
    private boolean extendToAvailableWidth = true;
    private volatile boolean isUpdatingColumnWidths = false;
    private Listener resizeListener = new Listener(){

        public void handleEvent(Event event) {
            if (!ColumnLayout.this.isUpdatingColumnWidths) {
                ColumnData layoutData = (ColumnData)event.widget.getData(WIDGETDATA_LAYOUT_DATA);
                if (!"gtk".equals(SWT.getPlatform()) || !ColumnLayout.this.isLastColumn(event.widget)) {
                    layoutData.resizedByUser = true;
                }
                ColumnLayout.this.columnResized((Item)event.widget);
            }
        }
    };
    protected List<Item> disposedColumns = new ArrayList<Item>();
    private Listener disposeListener = new Listener(){

        public void handleEvent(Event event) {
            ColumnLayout.this.disposedColumns.add((Item)event.widget);
        }
    };
    private Comparator<ColumnData> sortIndexComparator = new Comparator<ColumnData>(){

        @Override
        public int compare(ColumnData ld1, ColumnData ld2) {
            if (ld1.temp_sortIndex < ld2.temp_sortIndex) {
                return -1;
            }
            if (ld1.temp_sortIndex > ld2.temp_sortIndex) {
                return 1;
            }
            return 0;
        }
    };

    protected Point computeSize(Composite columnContainer, int wHint, int hHint, boolean flushCache) {
        return new Point(wHint, hHint);
    }

    protected void layout(Composite columnContainer, boolean flushCache) {
        int packedWidth;
        int width;
        if (this.isUpdatingColumnWidths) {
            return;
        }
        int columnCount = this.getColumnCount(columnContainer);
        int[] widths = new int[columnCount];
        int[] maxWidths = new int[columnCount];
        this.isUpdatingColumnWidths = true;
        int i = 0;
        while (i < columnCount) {
            Item column = this.getColumn(columnContainer, i);
            if (!this.disposedColumns.contains(column)) {
                ColumnData data = this.getLayoutData(columnContainer, i);
                if (column.getData(WIDGETDATA_LISTENER_REGISTERED) == null) {
                    column.addListener(11, this.resizeListener);
                    column.addListener(12, this.disposeListener);
                    column.setData(WIDGETDATA_LISTENER_REGISTERED, (Object)Boolean.TRUE);
                }
                if (data.resizedByUser) {
                    width = this.getColumnWidth(columnContainer, i);
                } else {
                    int maxWidth;
                    int prefWidth;
                    int minWidth;
                    packedWidth = -1;
                    if (data.getMinWidth() == -1 || data.getPrefWidth() == -1 || data.getMaxWidth() == -1) {
                        Integer temp;
                        if (!flushCache && (temp = (Integer)column.getData(WIDGETDATA_CACHED_PACKED_WIDTH)) != null) {
                            packedWidth = temp;
                        }
                        if (packedWidth == -1) {
                            packedWidth = this.getPackedWidth(columnContainer, i);
                            if (!columnContainer.getBounds().isEmpty() && packedWidth != 0) {
                                column.setData(WIDGETDATA_CACHED_PACKED_WIDTH, (Object)packedWidth);
                            } else {
                                column.setData(WIDGETDATA_CACHED_PACKED_WIDTH, null);
                            }
                        }
                    }
                    if ((minWidth = data.getMinWidth()) == -1) {
                        minWidth = packedWidth;
                    }
                    if ((prefWidth = data.getPrefWidth()) == -1) {
                        prefWidth = packedWidth;
                    }
                    if ((maxWidth = data.getMaxWidth()) == -1) {
                        maxWidth = packedWidth;
                    }
                    maxWidths[i] = maxWidth;
                    width = prefWidth;
                    width = Math.max(width, minWidth);
                    width = Math.min(width, maxWidth);
                }
                widths[i] = width;
            }
            ++i;
        }
        if (this.extendToAvailableWidth) {
            int availableWidth = columnContainer.getClientArea().width;
            int totalUsedWidth = 0;
            int[] minWidth = widths;
            packedWidth = widths.length;
            width = 0;
            while (width < packedWidth) {
                int width2 = minWidth[width];
                if (width2 > -1) {
                    totalUsedWidth += width2;
                }
                ++width;
            }
            int freeWidth = availableWidth - totalUsedWidth;
            if (freeWidth > 0) {
                int maxWidth;
                ArrayList<ColumnData> growingColumns = new ArrayList<ColumnData>();
                float weightSum = 0.0f;
                int i2 = 0;
                while (i2 < columnCount) {
                    Item column = this.getColumn(columnContainer, i2);
                    if (!this.disposedColumns.contains(column)) {
                        ColumnData data = this.getLayoutData(columnContainer, i2);
                        if (!data.resizedByUser && data.getWeight() > 0.0f) {
                            weightSum += data.getWeight();
                            maxWidth = maxWidths[i2];
                            data.temp_sortIndex = (float)(maxWidth - widths[i2]) / data.getWeight();
                            data.temp_columnIndex = i2;
                            growingColumns.add(data);
                        }
                    }
                    ++i2;
                }
                Collections.sort(growingColumns, this.sortIndexComparator);
                for (ColumnData data : growingColumns) {
                    if (data.resizedByUser) continue;
                    float ratio = 1.0f / weightSum;
                    maxWidth = maxWidths[data.temp_columnIndex];
                    int width3 = widths[data.temp_columnIndex];
                    int bonus = Math.min((int)((float)freeWidth * (data.getWeight() * ratio)), maxWidth - width3);
                    widths[data.temp_columnIndex] = Math.min(width3 + bonus, maxWidth);
                    weightSum -= data.getWeight();
                    freeWidth -= bonus;
                }
            }
        }
        this.setColumnWidths(columnContainer, widths);
        columnContainer.update();
        this.isUpdatingColumnWidths = false;
    }

    protected ColumnData getLayoutData(Composite columnContainer, int columnIndex) {
        Item column = this.getColumn(columnContainer, columnIndex);
        ColumnData layoutData = (ColumnData)column.getData(WIDGETDATA_LAYOUT_DATA);
        if (layoutData == null) {
            layoutData = new ColumnData();
            column.setData(WIDGETDATA_LAYOUT_DATA, (Object)layoutData);
        }
        return layoutData;
    }

    protected abstract int getColumnCount(Composite var1);

    protected abstract Item getColumn(Composite var1, int var2);

    protected abstract boolean isLastColumn(Widget var1);

    protected abstract int getColumnWidth(Composite var1, int var2);

    protected abstract int getPackedWidth(Composite var1, int var2);

    protected abstract void setColumnWidths(Composite var1, int[] var2);

    protected abstract void columnResized(C var1);

    public void setExtendToAvailableWidth(boolean extendToAvailableWidth) {
        this.extendToAvailableWidth = extendToAvailableWidth;
    }

    public void setColumnData(C column, ColumnData data) {
        column.setData(WIDGETDATA_LAYOUT_DATA, (Object)data);
    }

    public void flushCache(Composite columnContainer) {
        int i = 0;
        while (i < this.getColumnCount(columnContainer)) {
            this.getColumn(columnContainer, i).setData(WIDGETDATA_CACHED_PACKED_WIDTH, null);
            ++i;
        }
    }

    public void resetLayout(Composite columnContainer) {
        int i = 0;
        while (i < this.getColumnCount(columnContainer)) {
            this.getLayoutData((Composite)columnContainer, (int)i).resizedByUser = false;
            ++i;
        }
        columnContainer.layout();
    }
}

