/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.columnlayout;

import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TableColumnLayout
extends ColumnLayout<TableColumn> {
    @Override
    protected void layout(Composite columnContainer, boolean flushCache) {
        super.layout(columnContainer, flushCache);
        Table table = (Table)columnContainer;
        int i = 0;
        while (i < table.getColumnCount()) {
            Item column = this.getColumn(columnContainer, i);
            if (!this.disposedColumns.contains(column)) {
                ColumnData data = this.getLayoutData(columnContainer, i);
                table.getColumn(i).setResizable(data.isUserResizable());
            }
            ++i;
        }
        this.disposedColumns.clear();
    }

    @Override
    protected int getColumnCount(Composite columnContainer) {
        Table table = (Table)columnContainer;
        return table.getColumnCount();
    }

    @Override
    protected Item getColumn(Composite columnContainer, int columnIndex) {
        return ((Table)columnContainer).getColumn(columnIndex);
    }

    @Override
    protected boolean isLastColumn(Widget column) {
        Table columnContainer = ((TableColumn)column).getParent();
        return columnContainer.indexOf((TableColumn)column) == columnContainer.getColumnCount() - 1;
    }

    @Override
    protected int getColumnWidth(Composite columnContainer, int columnIndex) {
        Table table = (Table)columnContainer;
        return table.getColumn(columnIndex).getWidth();
    }

    @Override
    protected int getPackedWidth(Composite columnContainer, int columnIndex) {
        Table table = (Table)columnContainer;
        TableColumn column = table.getColumn(columnIndex);
        columnContainer.getParent().setRedraw(false);
        int width = column.getWidth();
        column.pack();
        int packedWidth = column.getWidth();
        column.setWidth(width);
        columnContainer.getParent().setRedraw(true);
        return packedWidth;
    }

    @Override
    protected void setColumnWidths(Composite columnContainer, int[] columnWidths) {
        Table table = (Table)columnContainer;
        int columnCount = table.getColumnCount();
        if (columnCount != columnWidths.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < columnCount) {
            int width = columnWidths[i];
            TableColumn column = table.getColumn(i);
            if (width > -1) {
                column.setWidth(width);
            }
            ++i;
        }
    }

    @Override
    protected void columnResized(TableColumn column) {
        this.layout((Composite)column.getParent(), true);
    }
}

