/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.columnlayout;

import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class TreeColumnLayout
extends ColumnLayout<TreeColumn> {
    @Override
    protected void layout(Composite columnContainer, boolean flushCache) {
        super.layout(columnContainer, flushCache);
        Tree tree = (Tree)columnContainer;
        int i = 0;
        while (i < tree.getColumnCount()) {
            Item column = this.getColumn(columnContainer, i);
            if (!this.disposedColumns.contains(column)) {
                ColumnData data = this.getLayoutData(columnContainer, i);
                tree.getColumn(i).setResizable(data.isUserResizable());
                this.disposedColumns.clear();
            }
            ++i;
        }
    }

    @Override
    protected int getColumnCount(Composite columnContainer) {
        Tree tree = (Tree)columnContainer;
        return tree.getColumnCount();
    }

    @Override
    protected Item getColumn(Composite columnContainer, int columnIndex) {
        return ((Tree)columnContainer).getColumn(columnIndex);
    }

    @Override
    protected boolean isLastColumn(Widget column) {
        Tree columnContainer = ((TreeColumn)column).getParent();
        return columnContainer.indexOf((TreeColumn)column) == columnContainer.getColumnCount() - 1;
    }

    @Override
    protected int getColumnWidth(Composite columnContainer, int columnIndex) {
        Tree tree = (Tree)columnContainer;
        return tree.getColumn(columnIndex).getWidth();
    }

    @Override
    protected int getPackedWidth(Composite columnContainer, int columnIndex) {
        Tree tree = (Tree)columnContainer;
        TreeColumn column = tree.getColumn(columnIndex);
        columnContainer.getParent().setRedraw(false);
        int width = column.getWidth();
        column.pack();
        int packedWidth = column.getWidth();
        column.setWidth(width);
        columnContainer.getParent().setRedraw(true);
        return packedWidth;
    }

    @Override
    protected void setColumnWidths(Composite columnContainer, int[] columnWidths) {
        Tree tree = (Tree)columnContainer;
        int columnCount = tree.getColumnCount();
        if (columnCount != columnWidths.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < columnCount) {
            int width = columnWidths[i];
            TreeColumn column = tree.getColumn(i);
            if (width > -1) {
                column.setWidth(width);
            }
            ++i;
        }
    }

    @Override
    protected void columnResized(TreeColumn column) {
        TreeColumn treeColumn = column;
        this.layout((Composite)treeColumn.getParent(), true);
    }
}

