/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.columnsort;

import de.aristaflow.adept2.ui.util.columnsort.ColumnComparator;
import de.aristaflow.adept2.ui.util.columnsort.LabelColumnComparator;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.NullArgumentException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public abstract class ColumnSortManager {
    protected ColumnViewer columnViewer;
    private ColumnComparator defaultComparator;
    boolean rememberSortDirection;
    Map<Item, ManagedColumnData> managedColumns = new HashMap<Item, ManagedColumnData>();
    final SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            boolean sortAscending;
            Item sortColumn;
            Item selectedColumn = (Item)e.widget;
            ManagedColumnData columnData = ColumnSortManager.this.managedColumns.get(selectedColumn);
            if (columnData == null) {
                return;
            }
            Item prevSortColumn = ColumnSortManager.this.getSortColumn();
            if (selectedColumn == prevSortColumn) {
                if (columnData.sortAscending == columnData.defaultSortAscending) {
                    sortColumn = selectedColumn;
                    sortAscending = !columnData.defaultSortAscending;
                } else {
                    sortColumn = null;
                    sortAscending = columnData.defaultSortAscending;
                }
            } else if (ColumnSortManager.this.rememberSortDirection) {
                sortColumn = selectedColumn;
                sortAscending = columnData.sortAscending;
            } else {
                sortColumn = selectedColumn;
                sortAscending = columnData.defaultSortAscending;
            }
            ColumnSortManager.this.setSorting(sortColumn, sortAscending);
        }
    };
    private final DisposeListener columnDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            Item column = (Item)e.widget;
            column.removeDisposeListener((DisposeListener)this);
            ColumnSortManager.this._removeSelectionListener(column, ColumnSortManager.this.columnSelectionListener);
            ColumnSortManager.this.managedColumns.remove(column);
        }
    };

    public ColumnSortManager(ColumnViewer columnViewer) {
        this(columnViewer, null);
    }

    public ColumnSortManager(ColumnViewer columnViewer, ColumnComparator defaultComparator) {
        ArgChecks.checkForNull(columnViewer, "columnViewer");
        Control control = columnViewer.getControl();
        if (!(control instanceof Table) && !(control instanceof Tree)) {
            throw new IllegalArgumentException();
        }
        this.columnViewer = columnViewer;
        this.defaultComparator = defaultComparator == null ? new LabelColumnComparator() : defaultComparator;
    }

    public void addColumn(Item column) {
        this.addColumn(column, true);
    }

    public void addColumn(Item column, ColumnComparator comparator) {
        this.addColumn(column, true, comparator);
    }

    public void addColumn(Item column, boolean defaultSortAscending) {
        this.addColumn(column, defaultSortAscending, null);
    }

    public void addColumn(Item column, boolean defaultSortAscending, ColumnComparator comparator) {
        ArgChecks.checkForNull(column, "column");
        this.checkColumnType(column);
        if (this.defaultComparator == null && comparator == null) {
            String msg = "The column needs a comparator if the TableSortManager has no default comparator.";
            throw new NullArgumentException(msg);
        }
        this._addSelectionListener(column, this.columnSelectionListener);
        column.addDisposeListener(this.columnDisposeListener);
        ManagedColumnData managedColumn = new ManagedColumnData(column, defaultSortAscending, comparator);
        this.managedColumns.put(column, managedColumn);
    }

    public void removeColumn(Item column) {
        ArgChecks.checkForNull(column, "column");
        this._removeSelectionListener(column, this.columnSelectionListener);
        this.managedColumns.remove(column);
    }

    public void clearColumns() {
        if (this.columnViewer.getControl() instanceof Table) {
            for (Item column : this.managedColumns.keySet()) {
                ((TableColumn)column).removeSelectionListener(this.columnSelectionListener);
            }
        } else if (this.columnViewer.getControl() instanceof Tree) {
            for (Item column : this.managedColumns.keySet()) {
                ((TreeColumn)column).removeSelectionListener(this.columnSelectionListener);
            }
        } else {
            throw new AssertionError();
        }
        this.managedColumns.clear();
    }

    public void setSorting(Item column, boolean sortAscending) {
        this.checkColumnType(column);
        this._setSortColumn(column);
        if (column == null) {
            this.columnViewer.setComparator(null);
        } else {
            ManagedColumnData columnData = this.managedColumns.get(column);
            columnData.sortAscending = sortAscending;
            int sortDirection = sortAscending ? 128 : 1024;
            this._setSortDirection(sortDirection);
            ColumnComparator comparator = this.getViewerComparator(column);
            comparator.setAscending(sortAscending);
            if (this.columnViewer.getComparator() == comparator) {
                this.columnViewer.refresh();
            }
            this.columnViewer.setComparator((ViewerComparator)comparator);
        }
    }

    public void clearSorting() {
        this.setSorting(null, true);
    }

    private ColumnComparator getViewerComparator(Item column) {
        ManagedColumnData columnData = this.managedColumns.get(column);
        if (columnData.comparator != null) {
            return columnData.comparator;
        }
        return this.defaultComparator;
    }

    public abstract Item getSortColumn();

    public boolean getSortAscending() {
        return this._getSortDirection() == 128;
    }

    abstract void _setSortColumn(Item var1);

    abstract int _getSortDirection();

    abstract void _setSortDirection(int var1);

    abstract void _addSelectionListener(Item var1, SelectionListener var2);

    abstract void _removeSelectionListener(Item var1, SelectionListener var2);

    abstract void checkColumnType(Item var1);

    private static class ManagedColumnData {
        final Item column;
        boolean defaultSortAscending;
        boolean sortAscending;
        ColumnComparator comparator;

        public ManagedColumnData(Item column, boolean defaultSortAscending) {
            this(column, defaultSortAscending, null);
        }

        public ManagedColumnData(Item column, boolean defaultSortAscending, ColumnComparator comparator) {
            this.column = column;
            this.defaultSortAscending = defaultSortAscending;
            this.sortAscending = defaultSortAscending;
            this.comparator = comparator;
        }
    }
}

