/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.columnsort;

import de.aristaflow.adept2.ui.util.columnsort.ColumnComparator;
import java.lang.reflect.Method;
import java.text.Collator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class LabelColumnComparator
extends ColumnComparator {
    private Collator collator = Collator.getInstance();
    private boolean skipReflection = false;
    private Method doFindItemMethod;

    public LabelColumnComparator() {
        this.collator.setStrength(1);
    }

    @Override
    protected int compareAscending(ColumnViewer tableViewer, Object e1, Object e2) {
        String e1String = this.getLabel(tableViewer, e1);
        if (e1String == null) {
            return 1;
        }
        String e2String = this.getLabel(tableViewer, e2);
        if (e2String == null) {
            return -1;
        }
        return this.collator.compare(e1String, e2String);
    }

    private String getLabel(ColumnViewer columnViewer, Object element) {
        int index;
        TableColumn sortColumn;
        if (columnViewer.getControl() instanceof Table) {
            Table table = (Table)columnViewer.getControl();
            sortColumn = table.getSortColumn();
            if (sortColumn == null) {
                return null;
            }
            index = table.indexOf(sortColumn);
        } else if (columnViewer.getControl() instanceof Tree) {
            Tree tree = (Tree)columnViewer.getControl();
            sortColumn = tree.getSortColumn();
            if (sortColumn == null) {
                return null;
            }
            index = tree.indexOf((TreeColumn)sortColumn);
        } else {
            String msg = "The %s does not support %s widgets!";
            msg = String.format(msg, ((Object)((Object)this)).getClass().getSimpleName(), columnViewer.getControl().getClass().getSimpleName());
            throw new IllegalArgumentException(msg);
        }
        ITableLabelProvider tableLabelProvider = null;
        int columnIndex = 0;
        ILabelProvider columnLabelProvider = null;
        if (columnViewer.getLabelProvider() instanceof ITableLabelProvider) {
            tableLabelProvider = (ITableLabelProvider)columnViewer.getLabelProvider();
            columnIndex = index;
        } else if (columnViewer.getLabelProvider(index) instanceof ILabelProvider) {
            columnLabelProvider = (ILabelProvider)columnViewer.getLabelProvider(index);
        }
        if (tableLabelProvider != null) {
            return tableLabelProvider.getColumnText(element, columnIndex);
        }
        if (columnLabelProvider != null) {
            return columnLabelProvider.getText(element);
        }
        return this.getLabelByReflection(columnViewer, element);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getLabelByReflection(ColumnViewer columnViewer, Object element) {
        block17: {
            Widget item;
            block16: {
                if (this.skipReflection) return null;
                if (this.doFindItemMethod == null) {
                    this.doFindItemMethod = StructuredViewer.class.getDeclaredMethod("doFindItem", Object.class);
                }
                this.doFindItemMethod.setAccessible(true);
                item = (Widget)this.doFindItemMethod.invoke((Object)columnViewer, element);
                if (!(item instanceof TableItem)) break block16;
                String string = ((TableItem)item).getText();
                if (this.doFindItemMethod == null) return string;
                try {
                    this.doFindItemMethod.setAccessible(false);
                    return string;
                }
                catch (SecurityException securityException) {}
                return string;
            }
            if (!(item instanceof TreeItem)) break block17;
            String string = ((TreeItem)item).getText();
            if (this.doFindItemMethod == null) return string;
            try {
                this.doFindItemMethod.setAccessible(false);
                return string;
            }
            catch (SecurityException securityException) {}
            return string;
            catch (Exception exception) {
                try {
                    this.skipReflection = true;
                    if (this.doFindItemMethod == null) return null;
                }
                catch (Throwable throwable) {
                    if (this.doFindItemMethod == null) throw throwable;
                    try {
                        this.doFindItemMethod.setAccessible(false);
                        throw throwable;
                    }
                    catch (SecurityException securityException) {}
                    throw throwable;
                }
                try {
                    this.doFindItemMethod.setAccessible(false);
                    return null;
                }
                catch (SecurityException securityException) {}
                return null;
            }
        }
        if (this.doFindItemMethod == null) return null;
        try {
            this.doFindItemMethod.setAccessible(false);
            return null;
        }
        catch (SecurityException securityException) {}
        return null;
    }
}

