/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.components;

import de.aristaflow.adept2.ui.util.UIComponent;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LocaleTools;
import java.util.Locale;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class LocaleUIComponent
extends UIComponent {
    ComboViewer localesCombo;

    public LocaleUIComponent(Composite parent) {
        this.localesCombo = new ComboViewer(parent, 0);
        this.localesCombo.getCombo().setVisibleItemCount(1000);
        this.localesCombo.setComparator(new ViewerComparator());
        this.localesCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Locale locale = (Locale)element;
                return LocaleUIComponent.getLocaleDisplayString(locale);
            }
        });
        this.localesCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.localesCombo.setInput((Object)LocaleTools.getCommonLocales());
        this.localesCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Locale locale = (Locale)selection.getFirstElement();
                if (locale != null) {
                    LocaleUIComponent.this.localesCombo.getCombo().setText(locale.toString());
                }
            }
        });
        this.localesCombo.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Combo combo = LocaleUIComponent.this.localesCombo.getCombo();
                Locale locale = LocaleTools.parseLocaleString(combo.getText());
                if (locale == null) {
                    combo.setToolTipText(null);
                } else {
                    combo.setToolTipText(LocaleUIComponent.getLocaleDisplayString(locale));
                }
            }
        });
        this.initControl(this.localesCombo.getControl());
    }

    public Combo getCombo() {
        return this.localesCombo.getCombo();
    }

    public void setLocales(Locale[] locales) {
        ArgChecks.checkForNulls(locales, "locales");
        this.localesCombo.setInput(locales.clone());
    }

    public Locale getSelectedLocale() {
        return LocaleTools.parseLocaleString(this.localesCombo.getCombo().getText());
    }

    static String getLocaleDisplayString(Locale locale) {
        String text;
        if (locale.getDisplayCountry() != null && locale.getDisplayCountry().length() > 0) {
            text = "%s (%s) [%s]";
            text = String.format(text, locale.getDisplayLanguage(), locale.getDisplayCountry(), locale.toString());
        } else {
            text = "%s [%s]";
            text = String.format(text, locale.getDisplayLanguage(), locale.toString());
        }
        return text;
    }
}

