/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.execution;

import de.aristaflow.adept2.ui.util.execution.ConsumingRunnable;
import de.aristaflow.adept2.ui.util.execution.ProducingRunnable;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.ExecutorTools;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;

public class DisplayExecutor {
    protected final ExecutorService executor;
    protected final Display display;

    public DisplayExecutor(String name, Display display, Logger logger) {
        ArgChecks.checkForBlank(name, "name");
        ArgChecks.checkForNull(display, "display");
        ArgChecks.checkForNull(logger, "logger");
        this.display = display;
        this.executor = Executors.newCachedThreadPool(new Adept2ThreadFactory(name, logger));
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    public void awaitTermination() {
        if (!this.executor.isShutdown()) {
            throw new IllegalStateException("Cannot await termination of executor service unless it has been shut down.");
        }
        ExecutorTools.awaitTermination(this.executor);
    }

    public <T, E extends Exception> void runSynchronously(ProducingRunnable<T, E> producer, ConsumingRunnable<T, ? super E> consumer) {
        CombiningRunnable<T, E> combined = new CombiningRunnable<T, E>(producer, consumer, false);
        combined.run();
    }

    public <T, E extends Exception> void runAsynchronously(ProducingRunnable<T, E> producer, ConsumingRunnable<T, ? super E> consumer) {
        CombiningRunnable<T, ? super E> combined = new CombiningRunnable<T, E>(producer, consumer, true);
        this.executor.execute(combined);
    }

    protected class CombiningRunnable<T, E extends Exception>
    implements Runnable {
        protected final ProducingRunnable<T, E> producer;
        protected final ConsumingRunnable<T, ? super E> consumer;
        protected final boolean async;

        public CombiningRunnable(ProducingRunnable<T, E> producer, ConsumingRunnable<T, ? super E> consumer, boolean async) {
            this.producer = producer;
            this.consumer = consumer;
            this.async = async;
        }

        @Override
        public void run() {
            Object result = null;
            Exception thrown = null;
            try {
                result = this.producer.call();
            }
            catch (Exception e) {
                thrown = e;
            }
            FinalRunnable<Object, Exception> runnable = new FinalRunnable<Object, Exception>((ConsumingRunnable<Object, Exception>)this.consumer, result, thrown);
            if (!DisplayExecutor.this.display.isDisposed()) {
                if (this.async) {
                    DisplayExecutor.this.display.asyncExec(runnable);
                } else {
                    DisplayExecutor.this.display.syncExec(runnable);
                }
            }
        }
    }

    protected static class FinalRunnable<T, E extends Exception>
    implements Runnable {
        private final ConsumingRunnable<T, ? super E> consumer;
        private final T finResult;
        private final E finThrown;

        public FinalRunnable(ConsumingRunnable<T, ? super E> consumer, T finResult, E finThrown) {
            this.consumer = consumer;
            this.finResult = finResult;
            this.finThrown = finThrown;
        }

        @Override
        public void run() {
            if (this.finResult != null) {
                this.consumer.consumeResult(this.finResult);
            } else {
                this.consumer.consumeException(this.finThrown);
            }
        }
    }
}

