/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.list;

import de.aristaflow.adept2.ui.icons.MiscImages;
import de.aristaflow.adept2.ui.util.MenuManagerWithIcon;
import de.aristaflow.adept2.ui.util.list.ListUIComponent;
import de.aristaflow.adept2.ui.util.list.QuickSearchFilterProvider;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import l10n.de.aristaflow.adept2.ui.util.list.ListUIMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FilteredListUIComponent
extends ListUIComponent {
    public static final int AUTO_SEARCH_WAIT_TIME = 1000;
    public static final String FILTER_ID_SEARCH = "search";
    protected Map<String, FilterDef> filterDefs = new LinkedHashMap<String, FilterDef>();
    protected Map<String, ViewerFilter> activeFilters = new HashMap<String, ViewerFilter>();
    protected final ViewerFilter viewerFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (FilteredListUIComponent.this.matchAnyFilter) {
                for (ViewerFilter filter : FilteredListUIComponent.this.activeFilters.values()) {
                    if (!filter.select(viewer, parentElement, element)) continue;
                    return true;
                }
                return false;
            }
            for (ViewerFilter filter : FilteredListUIComponent.this.activeFilters.values()) {
                if (filter.select(viewer, parentElement, element)) continue;
                return false;
            }
            return true;
        }
    };
    protected MenuManager filterContextMenu;
    protected boolean allowMultipleFilters = false;
    protected boolean matchAnyFilter = true;
    protected QuickSearchFilterProvider filterProvider;
    protected long lastModification = -1L;
    private Composite searchComposite;

    public FilteredListUIComponent(Composite parent, int style) {
        this(parent, style, null);
    }

    public FilteredListUIComponent(Class<? extends Control> columnContainerClass, Composite parent, int style) {
        this(columnContainerClass, parent, style, null);
    }

    public FilteredListUIComponent(Composite parent, int style, QuickSearchFilterProvider filterProvider) {
        super(parent, filterProvider == null ? style : style | 0x800);
        if (filterProvider != null) {
            this.filterProvider = filterProvider;
            ((GridData)this.searchComposite.getLayoutData()).exclude = false;
            this.searchComposite.setVisible(true);
            parent.layout();
        }
        this.getColumnControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public FilteredListUIComponent(Class<? extends Control> columnContainerClass, Composite parent, int style, QuickSearchFilterProvider filterProvider) {
        super(columnContainerClass, parent, style | 0x800);
        if (filterProvider != null) {
            this.filterProvider = filterProvider;
            ((GridData)this.searchComposite.getLayoutData()).exclude = false;
            this.searchComposite.setVisible(true);
            parent.layout();
        }
        this.getColumnControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public MenuManager createFilterMenu() {
        MenuManagerWithIcon filterMenu = new MenuManagerWithIcon(ListUIMessages.getString("FilteredListUIComponent.Filters"), "configFilters");
        filterMenu.setImageDescriptor(ImageDescriptor.createFromFile(FilteredListUIComponent.class, (String)"icons/filters.png"));
        filterMenu.add((IAction)new SetSingleFilterModeAction());
        filterMenu.setRemoveAllWhenShown(true);
        filterMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new ClearAllFiltersAction());
                manager.add((IContributionItem)new Separator());
                if (FilteredListUIComponent.this.filterDefs.size() > 0) {
                    for (String filterKey : FilteredListUIComponent.this.filterDefs.keySet()) {
                        String filterTitle = FilteredListUIComponent.this.filterDefs.get((Object)filterKey).title;
                        manager.add((IAction)new ToggleFilterAction(filterKey, filterTitle));
                    }
                } else {
                    manager.add((IAction)new Action(ListUIMessages.getString("FilteredListUIComponent.NoFiltersAvailable"), 2){
                        {
                            this.setEnabled(false);
                        }
                    });
                }
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new SetSingleFilterModeAction());
                manager.add((IAction)new SetMatchAnyFilterAction());
                manager.add((IAction)new SetMatchAllFiltersAction());
            }
        });
        return filterMenu;
    }

    @Override
    protected void fillContextMenu(MenuManager contextMenu) {
        super.fillContextMenu(contextMenu);
        contextMenu.prependToGroup("listConfigGroup", (IContributionItem)this.getFilterContextMenu());
    }

    protected MenuManager getFilterContextMenu() {
        if (this.filterContextMenu == null) {
            this.filterContextMenu = this.createFilterMenu();
        }
        return this.filterContextMenu;
    }

    public void registerFilter(String key, String title, ViewerFilter filter) {
        ArgChecks.checkForNull(key, "key");
        ArgChecks.checkForNull(title, "title");
        ArgChecks.checkForNull(filter, "filter");
        if (this.filterDefs.containsKey(key)) {
            String msg = "filter with key '%s' already registered";
            msg = String.format(msg, key);
            throw new IllegalArgumentException(msg);
        }
        this.filterDefs.put(key, new FilterDef(key, title, filter));
    }

    public void deregisterFilter(String filterKey) {
        this.deactivateFilter(filterKey);
        this.filterDefs.remove(filterKey);
    }

    public void setAllowMultipleFilters(boolean allow, boolean matchAnyFilter) {
        if (this.allowMultipleFilters != allow || this.allowMultipleFilters && this.matchAnyFilter != matchAnyFilter) {
            this.allowMultipleFilters = allow;
            if (this.allowMultipleFilters) {
                this.matchAnyFilter = matchAnyFilter;
            } else if (this.activeFilters.size() > 0) {
                this.deactivateAllFilters();
                return;
            }
            this.getColumnViewer().refresh();
        }
    }

    public boolean getAllowMultipleFilters() {
        return this.allowMultipleFilters;
    }

    public boolean getMatchAnyFilter() {
        return this.matchAnyFilter;
    }

    public void activateFilter(String key) {
        ArgChecks.checkForNull(key, "key");
        FilterDef filterDef = this.filterDefs.get(key);
        if (filterDef == null) {
            String msg = "filter with key '%s' does not exist!";
            msg = String.format(msg, key);
            throw new IllegalArgumentException(msg);
        }
        if (this.isFilterActive(key) && (this.allowMultipleFilters || this.activeFilters.size() == 1)) {
            return;
        }
        if (this.activeFilters.size() == 0) {
            this.activeFilters.put(key, filterDef.filter);
            this.getColumnViewer().addFilter(this.viewerFilter);
        } else {
            if (!this.allowMultipleFilters) {
                this.activeFilters.clear();
            }
            this.activeFilters.put(key, filterDef.filter);
            this.getColumnViewer().refresh();
        }
    }

    public void deactivateFilter(String key) {
        ArgChecks.checkForNull(key, "key");
        if (!this.filterDefs.containsKey(key)) {
            String msg = "filter with key '%s' does not exist!";
            msg = String.format(msg, key);
            throw new IllegalArgumentException(msg);
        }
        if (this.activeFilters.remove(key) == null) {
            return;
        }
        if (this.activeFilters.size() == 0) {
            this.getColumnViewer().removeFilter(this.viewerFilter);
        } else {
            this.getColumnViewer().refresh();
        }
    }

    public void deactivateAllFilters() {
        this.activeFilters.clear();
        this.getColumnViewer().resetFilters();
    }

    public boolean isFilterActive(String key) {
        return this.activeFilters.containsKey(key);
    }

    @Override
    public void dispose() {
        if (this.filterContextMenu != null) {
            this.filterContextMenu.dispose();
        }
        super.dispose();
    }

    @Override
    protected Composite getParentReplacement(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout(1, false);
        containerLayout.horizontalSpacing = 0;
        containerLayout.verticalSpacing = 0;
        containerLayout.marginHeight = 0;
        containerLayout.marginWidth = 0;
        container.setLayout((Layout)containerLayout);
        this.searchComposite = new Composite(container, 0);
        GridData gridData = new GridData(4, -1, true, false);
        gridData.exclude = true;
        this.searchComposite.setVisible(false);
        this.searchComposite.setLayoutData((Object)gridData);
        GridLayout searchLayout = new GridLayout(3, false);
        searchLayout.marginHeight = 0;
        this.searchComposite.setLayout((Layout)searchLayout);
        Label lblSearch = new Label(this.searchComposite, 0);
        lblSearch.setText(String.valueOf(ListUIMessages.getString("FilteredListUIComponent.QuickSearch")) + ":");
        gridData = new GridData(16384, 0x1000000, false, false);
        lblSearch.setLayoutData((Object)gridData);
        final Text text = new Text(this.searchComposite, 2432);
        gridData = new GridData(4, 0x1000000, true, false);
        text.setLayoutData((Object)gridData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilteredListUIComponent.this.lastModification = System.currentTimeMillis();
            }
        });
        final Runnable reFilter = new Runnable(){

            @Override
            public void run() {
                if (text.isDisposed()) {
                    return;
                }
                try {
                    FilteredListUIComponent.this.deregisterFilter(FilteredListUIComponent.FILTER_ID_SEARCH);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                String searchString = text.getText();
                if (searchString.length() == 0) {
                    return;
                }
                ViewerFilter searchFilter = FilteredListUIComponent.this.filterProvider.getQuickSearchFilter(searchString);
                FilteredListUIComponent.this.registerFilter(FilteredListUIComponent.FILTER_ID_SEARCH, "(" + ListUIMessages.getString("FilteredListUIComponent.QuickSearch") + ")", searchFilter);
                FilteredListUIComponent.this.activateFilter(FilteredListUIComponent.FILTER_ID_SEARCH);
                FilteredListUIComponent.this.lastModification = -1L;
            }
        };
        if ((text.getStyle() & 0x100) == 0) {
            Label btnRemove = new Label(this.searchComposite, 0);
            btnRemove.setImage(MiscImages.getImage("deleteTextContent.png"));
            btnRemove.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    text.setText("");
                    text.setFocus();
                    reFilter.run();
                }
            });
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (text.isDisposed()) {
                    this.cancel();
                    return;
                }
                if (FilteredListUIComponent.this.lastModification == -1L || System.currentTimeMillis() - FilteredListUIComponent.this.lastModification <= 1000L) {
                    return;
                }
                text.getDisplay().asyncExec(reFilter);
            }
        };
        text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    text.setText("");
                }
                reFilter.run();
            }
        });
        if ((text.getStyle() & 0x100) == 0) {
            text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 27) {
                        text.setText("");
                        reFilter.run();
                    }
                }
            });
        }
        Timer timer = new Timer("FilteredListUIComponentAutoSearch");
        timer.schedule(task, 0L, 1000L);
        return container;
    }

    public Composite getSearchComposite() {
        return this.searchComposite;
    }

    protected class ClearAllFiltersAction
    extends Action {
        public ClearAllFiltersAction() {
            super(ListUIMessages.getString("FilteredListUIComponent.ClearFilters"), 1);
        }

        public void run() {
            FilteredListUIComponent.this.deactivateAllFilters();
        }
    }

    protected static class FilterDef {
        public final String key;
        public final String title;
        public final ViewerFilter filter;

        public FilterDef(String key, String title, ViewerFilter filter) {
            this.key = key;
            this.title = title;
            this.filter = filter;
        }
    }

    protected class SetMatchAllFiltersAction
    extends Action {
        public SetMatchAllFiltersAction() {
            super(ListUIMessages.getString("FilteredListUIComponent.MatchAllFilters"), 8);
            this.setChecked(FilteredListUIComponent.this.getAllowMultipleFilters() && !FilteredListUIComponent.this.getMatchAnyFilter());
        }

        public void run() {
            if (this.isChecked()) {
                FilteredListUIComponent.this.setAllowMultipleFilters(true, false);
            }
        }
    }

    protected class SetMatchAnyFilterAction
    extends Action {
        public SetMatchAnyFilterAction() {
            super(ListUIMessages.getString("FilteredListUIComponent.MatchAnyFilter"), 8);
            this.setChecked(FilteredListUIComponent.this.getAllowMultipleFilters() && FilteredListUIComponent.this.getMatchAnyFilter());
        }

        public void run() {
            if (this.isChecked()) {
                FilteredListUIComponent.this.setAllowMultipleFilters(true, true);
            }
        }
    }

    protected class SetSingleFilterModeAction
    extends Action {
        public SetSingleFilterModeAction() {
            super(ListUIMessages.getString("FilteredListUIComponent.SingleFilterMode"), 8);
            this.setChecked(!FilteredListUIComponent.this.getAllowMultipleFilters());
        }

        public void run() {
            if (this.isChecked()) {
                FilteredListUIComponent.this.setAllowMultipleFilters(false, true);
            }
        }
    }

    protected class ToggleFilterAction
    extends Action {
        private String filterKey;

        public ToggleFilterAction(String filterKey, String filterTitle) {
            super(filterTitle, FilteredListUIComponent.this.getAllowMultipleFilters() ? 2 : 8);
            this.filterKey = filterKey;
            this.setChecked(FilteredListUIComponent.this.isFilterActive(this.filterKey));
        }

        public void run() {
            if (FilteredListUIComponent.this.getAllowMultipleFilters() && FilteredListUIComponent.this.isFilterActive(this.filterKey)) {
                FilteredListUIComponent.this.deactivateFilter(this.filterKey);
            } else {
                FilteredListUIComponent.this.activateFilter(this.filterKey);
            }
        }
    }
}

