/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.list;

import de.aristaflow.adept2.ui.util.list.ListUIComponent;
import de.aristaflow.adept2.util.StringTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;

public final class ListStatePersistenceTools {
    private static final String STATE_HIDDEN_COLUMNS = "HiddenColumns";
    private static final String STATE_COLUMN_ORDER = "ColumnOrder";
    private static final String STATE_SORT_COLUMN = "SortColumn";
    private static final String STATE_SORT_ASCENDING = "SortAscending";

    public static void saveState(ListUIComponent list, IMemento memento) {
        memento.putString(STATE_HIDDEN_COLUMNS, StringTools.join(", ", list.getHiddenColumns()));
        memento.putString(STATE_COLUMN_ORDER, StringTools.join(", ", list.getColumnOrder()));
        if (list.getSortColumn() != null) {
            memento.putString(STATE_SORT_COLUMN, list.getSortColumn());
            memento.putString(STATE_SORT_ASCENDING, Boolean.toString(list.getSortAscending()));
        } else {
            memento.putString(STATE_SORT_COLUMN, null);
            memento.putString(STATE_SORT_ASCENDING, null);
        }
    }

    public static void loadState(ListUIComponent list, IMemento memento) {
        String sortColumn;
        String[] columnOrder;
        String[] hiddenColumns = ListStatePersistenceTools.getHiddenColumns(memento);
        if (hiddenColumns != null) {
            list.setHiddenColumns(hiddenColumns);
        }
        if ((columnOrder = ListStatePersistenceTools.getColumnOrder(memento)) != null) {
            list.setColumnOrder(columnOrder);
        }
        if ((sortColumn = ListStatePersistenceTools.getSortColumn(memento)) != null) {
            boolean sortAscending = ListStatePersistenceTools.getSortAscending(memento);
            list.setSortColumn(sortColumn, sortAscending);
        }
    }

    public static String[] getHiddenColumns(IMemento memento) {
        String columnsString = memento.getString(STATE_HIDDEN_COLUMNS);
        if (columnsString == null) {
            return null;
        }
        return columnsString.split(", ");
    }

    public static String[] getColumnOrder(IMemento memento) {
        String columnsString = memento.getString(STATE_COLUMN_ORDER);
        if (columnsString == null) {
            return null;
        }
        return columnsString.split(", ");
    }

    public static String getSortColumn(IMemento memento) {
        return memento.getString(STATE_SORT_COLUMN);
    }

    public static boolean getSortAscending(IMemento memento) {
        return Boolean.parseBoolean(memento.getString(STATE_SORT_ASCENDING));
    }

    public static void saveState(ListUIComponent list, IPreferenceStore prefStore, String prefix) {
        prefStore.setValue(ListStatePersistenceTools.prefixKey(STATE_HIDDEN_COLUMNS, prefix), StringTools.join(", ", list.getHiddenColumns()));
        prefStore.setValue(ListStatePersistenceTools.prefixKey(STATE_COLUMN_ORDER, prefix), StringTools.join(", ", list.getColumnOrder()));
        if (list.getSortColumn() != null) {
            prefStore.setValue(ListStatePersistenceTools.prefixKey(STATE_SORT_COLUMN, prefix), list.getSortColumn());
            prefStore.setValue(ListStatePersistenceTools.prefixKey(STATE_SORT_ASCENDING, prefix), list.getSortAscending());
        } else {
            prefStore.setValue(ListStatePersistenceTools.prefixKey(STATE_SORT_COLUMN, prefix), null);
            prefStore.setValue(ListStatePersistenceTools.prefixKey(STATE_SORT_ASCENDING, prefix), null);
        }
    }

    public static void loadState(ListUIComponent list, IPreferenceStore prefStore, String prefix) {
        String sortColumn;
        String[] columnOrder;
        String[] hiddenColumns = ListStatePersistenceTools.getHiddenColumns(prefStore, prefix);
        if (hiddenColumns != null) {
            list.setHiddenColumns(hiddenColumns);
        }
        if ((columnOrder = ListStatePersistenceTools.getColumnOrder(prefStore, prefix)) != null) {
            list.setColumnOrder(columnOrder);
        }
        if ((sortColumn = ListStatePersistenceTools.getSortColumn(prefStore, prefix)) != null) {
            boolean sortAscending = ListStatePersistenceTools.getSortAscending(prefStore, prefix);
            list.setSortColumn(sortColumn, sortAscending);
        }
    }

    public static String[] getHiddenColumns(IPreferenceStore prefStore, String prefix) {
        String columnsString = prefStore.getString(STATE_HIDDEN_COLUMNS);
        if (columnsString == null || columnsString.length() == 0) {
            return null;
        }
        return columnsString.split(", ");
    }

    public static String[] getColumnOrder(IPreferenceStore prefStore, String prefix) {
        String columnsString = prefStore.getString(STATE_COLUMN_ORDER);
        if (columnsString == null || columnsString.length() == 0) {
            return null;
        }
        return columnsString.split(", ");
    }

    public static String getSortColumn(IPreferenceStore prefStore, String prefix) {
        return prefStore.getString(STATE_SORT_COLUMN);
    }

    public static boolean getSortAscending(IPreferenceStore prefStore, String prefix) {
        return prefStore.getBoolean(ListStatePersistenceTools.prefixKey(STATE_SORT_ASCENDING, prefix));
    }

    private static String prefixKey(String key, String prefix) {
        if (prefix == null) {
            return key;
        }
        return String.valueOf(prefix) + key;
    }

    private ListStatePersistenceTools() {
    }
}

