/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.list;

import de.aristaflow.adept2.ui.util.MenuManagerWithIcon;
import de.aristaflow.adept2.ui.util.UIComponent;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.columnsort.ColumnComparator;
import de.aristaflow.adept2.ui.util.list.ColumnContainerAdapter;
import de.aristaflow.adept2.ui.util.list.TableAdapter;
import de.aristaflow.adept2.ui.util.list.TreeAdapter;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import l10n.de.aristaflow.adept2.ui.util.list.ListUIMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class ListUIComponent
extends UIComponent {
    public static final String CONTEXT_GROUP_LIST_CONFIG = "listConfigGroup";
    public static final String CONTEXT_GROUP_COPY = "listCopy";
    protected static final String WIDGETDATA_COLUMNKEY = String.valueOf(ListUIComponent.class.getName()) + "#columnKey";
    protected static final String WIDGETDATA_FIXEDPOS = String.valueOf(ListUIComponent.class.getName()) + "#fixedPos";
    protected ColumnContainerAdapter cca;
    private Listener columnMoveListener = new Listener(){
        int[] previousOrder = new int[0];

        public void handleEvent(Event event) {
            Item movedColumn = (Item)event.widget;
            int[] newOrder = ListUIComponent.this.cca.getColumnOrder();
            if (newOrder.length != this.previousOrder.length) {
                Item[] columns = ListUIComponent.this.cca.getColumns();
                int i = 0;
                while (i < columns.length) {
                    Item column = columns[i];
                    if (ListUIComponent.this.cca.columnGetMoveable(column)) {
                        column.setData(WIDGETDATA_FIXEDPOS, null);
                    } else {
                        column.setData(WIDGETDATA_FIXEDPOS, (Object)i);
                    }
                    ++i;
                }
            } else if (!Arrays.equals(this.previousOrder, newOrder)) {
                Integer fixedPos = (Integer)movedColumn.getData(WIDGETDATA_FIXEDPOS);
                if (fixedPos != null && newOrder[fixedPos] != fixedPos) {
                    ListUIComponent.this.cca.setColumnOrder(this.previousOrder);
                }
                ListUIComponent.this.getColumnControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ListUIComponent.this.getColumnViewer().getControl().isDisposed()) {
                            ListUIComponent.this.getColumnViewer().refresh();
                        }
                    }
                });
            }
            this.previousOrder = newOrder;
        }
    };
    protected Map<String, ColumnDef> columnDefs = new LinkedHashMap<String, ColumnDef>();
    protected Map<String, Item> shownColumns = new HashMap<String, Item>();
    protected boolean columnsInitialized = false;
    protected MenuManager contextMenu;
    protected MenuManager columnsContextMenu;
    protected Clipboard clipboard;

    public ListUIComponent(Composite parent, int style) {
        this(Table.class, parent, style);
    }

    public ListUIComponent(Class<? extends Control> columnContainerClass, Composite parent, int style) {
        ArgChecks.checkForNull(parent, "parent");
        Composite parentReplacement = this.getParentReplacement(parent);
        if (parentReplacement != null) {
            parent = parentReplacement;
        }
        if (columnContainerClass == Table.class) {
            this.cca = new TableAdapter(parent, style);
        } else if (columnContainerClass == Tree.class) {
            this.cca = new TreeAdapter(parent, style);
        } else {
            throw new IllegalArgumentException(String.valueOf(columnContainerClass.getName()) + " not supported!");
        }
        if (parentReplacement != null) {
            this.initControl((Control)parentReplacement);
        } else {
            this.initControl((Control)this.cca.getControl());
        }
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getColumnViewer());
        this.cca.setHeaderVisible(true);
        this.createAndHookContextMenu();
        this.registerColumns();
    }

    protected Composite getParentReplacement(Composite parent) {
        return null;
    }

    private void createAndHookContextMenu() {
        this.contextMenu = new MenuManager("#ContextMenu");
        this.contextMenu.setRemoveAllWhenShown(true);
        this.contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ListUIComponent.this.fillContextMenu(ListUIComponent.this.contextMenu);
            }
        });
        Menu menu = this.contextMenu.createContextMenu((Control)this.getColumnControl());
        this.getColumnControl().setMenu(menu);
    }

    public MenuManager createColumnsMenu() {
        MenuManagerWithIcon columnsMenu = new MenuManagerWithIcon(ListUIMessages.getString("ListUIComponent.Columns"), "configColumns");
        columnsMenu.setImageDescriptor(ImageDescriptor.createFromFile(ListUIComponent.class, (String)"icons/columns.png"));
        columnsMenu.add((IAction)new ShowAllColumnsAction());
        columnsMenu.setRemoveAllWhenShown(true);
        columnsMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                boolean hasOptionalColumns = false;
                int hasMoveableColumns = 0;
                for (String columnKey : ListUIComponent.this.columnDefs.keySet()) {
                    ColumnDef columnDef = ListUIComponent.this.columnDefs.get(columnKey);
                    if (!columnDef.isMandatory) {
                        hasOptionalColumns = true;
                    }
                    if (!columnDef.isMoveable) continue;
                    ++hasMoveableColumns;
                }
                if (ListUIComponent.this.columnDefs.size() > 0) {
                    if (hasOptionalColumns) {
                        for (String columnKey : ListUIComponent.this.columnDefs.keySet()) {
                            String columnTitle = ListUIComponent.this.columnDefs.get((Object)columnKey).title;
                            if (columnTitle == null || columnTitle.equals("")) {
                                columnTitle = "<" + columnKey + ">";
                            }
                            manager.add((IAction)new ShowHideColumnAction(columnKey, columnTitle));
                        }
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ShowAllColumnsAction());
                        manager.add((IContributionItem)new Separator());
                    }
                    if (hasOptionalColumns || hasMoveableColumns > 0) {
                        manager.add((IAction)new RestoreDefaultColumnOrderAction());
                    }
                    manager.add((IAction)new RestoreDefaultColumnWidths());
                } else {
                    manager.add((IAction)new Action("No Columns available", 2){
                        {
                            this.setEnabled(false);
                        }
                    });
                }
            }
        });
        return columnsMenu;
    }

    protected void fillContextMenu(MenuManager contextMenu) {
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.add((IContributionItem)new Separator(CONTEXT_GROUP_COPY));
        contextMenu.add((IAction)new CopyCellTextAction());
        contextMenu.add((IContributionItem)new Separator(CONTEXT_GROUP_LIST_CONFIG));
        contextMenu.add((IContributionItem)this.getColumnsContextMenu());
    }

    protected void registerColumns() {
    }

    public void initColumns(String[] columnOrder, String[] hiddenColumns, String sortColumn, boolean sortAscending) {
        this.getColumnControl().getParent().setRedraw(false);
        List<Object> initHiddenColumnsList = hiddenColumns == null ? Collections.emptyList() : Arrays.asList(hiddenColumns);
        ArrayList<String> remainingColumns = new ArrayList<String>(this.columnDefs.keySet());
        ArrayList<String> actualColumnOrder = new ArrayList<String>(this.columnDefs.size());
        if (columnOrder != null) {
            String[] stringArray = columnOrder;
            int n = columnOrder.length;
            int n2 = 0;
            while (n2 < n) {
                String columnKey = stringArray[n2];
                if (this.isColumnRegistered(columnKey)) {
                    if (this.columnDefs.get((Object)columnKey).isMandatory || !initHiddenColumnsList.contains(columnKey)) {
                        this.showColumn(columnKey);
                        remainingColumns.remove(columnKey);
                    }
                    actualColumnOrder.add(columnKey);
                }
                ++n2;
            }
        }
        for (String columnKey : remainingColumns) {
            if (initHiddenColumnsList.contains(columnKey)) continue;
            this.showColumn(columnKey);
            actualColumnOrder.add(columnKey);
        }
        if (sortColumn != null) {
            this.setSortColumn(sortColumn, sortAscending);
        }
        this.getColumnViewer().setColumnProperties(actualColumnOrder.toArray(new String[actualColumnOrder.size()]));
        this.columnsInitialized = true;
        this.getColumnControl().getParent().setRedraw(true);
    }

    public ColumnViewer getColumnViewer() {
        return this.cca.getViewer();
    }

    public Composite getColumnControl() {
        return this.cca.getControl();
    }

    public MenuManager getContextMenu() {
        return this.contextMenu;
    }

    protected MenuManager getColumnsContextMenu() {
        if (this.columnsContextMenu == null) {
            this.columnsContextMenu = this.createColumnsMenu();
        }
        return this.columnsContextMenu;
    }

    public void registerColumn(String columnKey, String title, int style, ColumnData layoutData, CellLabelProvider labelProvider, ColumnComparator viewerComparator) {
        this.registerColumn(columnKey, title, style, layoutData, labelProvider, viewerComparator, null);
    }

    public void registerColumn(String columnKey, String title, int style, ColumnData layoutData, CellLabelProvider labelProvider, ColumnComparator viewerComparator, EditingSupport editingSupport) {
        this.registerColumn(columnKey, title, style, true, false, layoutData, labelProvider, viewerComparator, editingSupport);
    }

    public void registerColumn(String columnKey, String title, int style, boolean isMoveable, boolean isMandatory, ColumnData layoutData, CellLabelProvider labelProvider, ColumnComparator viewerComparator, EditingSupport editingSupport) {
        ArgChecks.checkForNull(columnKey, "columnKey");
        ArgChecks.checkForNull(title, "title");
        ArgChecks.checkForNull(labelProvider, "labelProvider");
        if (this.columnDefs.containsKey(columnKey)) {
            String msg = "column with key '%s' already registered";
            msg = String.format(msg, columnKey);
            throw new IllegalArgumentException(msg);
        }
        this.columnDefs.put(columnKey, new ColumnDef(columnKey, title, style, isMoveable, isMandatory, layoutData, labelProvider, viewerComparator, editingSupport));
        if (this.columnsInitialized) {
            this.showColumn(columnKey);
        }
    }

    public void deregisterColumn(String columnKey) {
        this.hideColumn(columnKey);
        this.columnDefs.remove(columnKey);
    }

    public boolean isColumnRegistered(String columnKey) {
        return this.columnDefs.containsKey(columnKey);
    }

    public void showColumn(final String columnKey) {
        ArgChecks.checkForNull(columnKey, "key");
        ColumnDef columnDef = this.columnDefs.get(columnKey);
        if (columnDef == null) {
            String msg = "column with key '%s' does not exist!";
            msg = String.format(msg, columnKey);
            throw new IllegalArgumentException(msg);
        }
        if (this.shownColumns.containsKey(columnKey)) {
            return;
        }
        ViewerColumn viewerColumn = this.cca.createColumn(columnDef.style, columnDef.title, columnDef.isMoveable);
        if (columnDef.labelProvider != null) {
            viewerColumn.setLabelProvider(columnDef.labelProvider);
        }
        if (columnDef.editingSupport != null) {
            viewerColumn.setEditingSupport(columnDef.editingSupport);
        }
        Item column = this.cca.getColumnWidget(viewerColumn);
        column.addListener(10, this.columnMoveListener);
        column.setData(WIDGETDATA_COLUMNKEY, (Object)columnDef.key);
        if (!columnDef.isMoveable) {
            column.setData(WIDGETDATA_FIXEDPOS, (Object)this.cca.indexOf(column));
        }
        this.getColumnViewer().refresh();
        this.cca.getColumnLayout().setColumnData(column, columnDef.columnLayoutData);
        this.cca.layout();
        this.cca.getColumnSortManager().addColumn(column, columnDef.viewerComparator);
        this.shownColumns.put(columnKey, column);
        column.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ListUIComponent.this.shownColumns.remove(columnKey);
            }
        });
    }

    public void hideColumn(String columnKey) {
        ArgChecks.checkForNull(columnKey, "key");
        ColumnDef columnDef = this.columnDefs.get(columnKey);
        if (columnDef == null) {
            String msg = "column with key '%s' does not exist!";
            msg = String.format(msg, columnKey);
            throw new IllegalArgumentException(msg);
        }
        if (columnDef.isMandatory) {
            return;
        }
        Item column = this.shownColumns.get(columnKey);
        if (column == null) {
            return;
        }
        column.dispose();
        this.shownColumns.remove(columnKey);
        this.cca.layout();
    }

    public boolean isColumnShown(String columnKey) {
        return this.shownColumns.containsKey(columnKey);
    }

    public void restoreDefaultColumnOrder() {
        ArrayList<Integer> defaultColumnOrderList = new ArrayList<Integer>();
        for (String columnKey : this.columnDefs.keySet()) {
            Item column = this.shownColumns.get(columnKey);
            if (column == null) continue;
            int index = this.cca.indexOf(column);
            defaultColumnOrderList.add(index);
        }
        int[] defaultColumnOrder = new int[defaultColumnOrderList.size()];
        int i = 0;
        while (i < defaultColumnOrderList.size()) {
            defaultColumnOrder[i] = (Integer)defaultColumnOrderList.get(i);
            ++i;
        }
        this.cca.setColumnOrder(defaultColumnOrder);
    }

    public String[] getHiddenColumns() {
        HashSet<String> hiddenColumns = new HashSet<String>();
        hiddenColumns.addAll(this.columnDefs.keySet());
        hiddenColumns.removeAll(this.shownColumns.keySet());
        return hiddenColumns.toArray(new String[hiddenColumns.size()]);
    }

    public void setHiddenColumns(String[] columnKeys) {
        ArgChecks.checkForNull(columnKeys, "hiddenColumns");
        List<String> hiddenColumnsList = Arrays.asList(columnKeys);
        for (String columnKey : this.columnDefs.keySet()) {
            if (this.columnDefs.get((Object)columnKey).isMandatory || !hiddenColumnsList.contains(columnKey)) {
                this.showColumn(columnKey);
                continue;
            }
            this.hideColumn(columnKey);
        }
    }

    public String[] getColumnOrder() {
        ArrayList<String> columnOrder = new ArrayList<String>();
        int[] columnOrderIndices = this.cca.getColumnOrder();
        int i = 0;
        while (i < columnOrderIndices.length) {
            Object data = this.cca.getColumn(columnOrderIndices[i]).getData(WIDGETDATA_COLUMNKEY);
            if (data instanceof String) {
                columnOrder.add((String)data);
            }
            ++i;
        }
        return columnOrder.toArray(new String[columnOrder.size()]);
    }

    public void setColumnOrder(String[] columnKeys) {
        ArgChecks.checkForNull(columnKeys, "columnKeys");
        ArrayList<String> remainingColumns = new ArrayList<String>(this.shownColumns.keySet());
        int[] columnOrder = new int[this.cca.getColumnCount()];
        int i = 0;
        String[] stringArray = columnKeys;
        int n = columnKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Item column;
            String columnKey = stringArray[n2];
            if (remainingColumns.contains(columnKey) && (column = this.shownColumns.get(columnKey)) != null) {
                columnOrder[i] = this.cca.indexOf(column);
                remainingColumns.remove(columnKey);
                ++i;
            }
            ++n2;
        }
        for (String columnKey : remainingColumns) {
            columnOrder[i] = this.cca.indexOf(this.shownColumns.get(columnKey));
            ++i;
        }
        this.cca.setColumnOrder(columnOrder);
    }

    public String getSortColumn() {
        Item column = this.cca.getColumnSortManager().getSortColumn();
        if (column == null) {
            return null;
        }
        return (String)column.getData(WIDGETDATA_COLUMNKEY);
    }

    public boolean getSortAscending() {
        return this.cca.getColumnSortManager().getSortAscending();
    }

    public void setSortColumn(String columnKey, boolean sortAscending) {
        ArgChecks.checkForNull(columnKey, "columnKey");
        Item column = null;
        if (columnKey != null) {
            if (!this.columnDefs.containsKey(columnKey)) {
                String msg = "column with key '%s' does not exist!";
                msg = String.format(msg, columnKey);
                throw new IllegalArgumentException(msg);
            }
            column = this.shownColumns.get(columnKey);
            if (column == null) {
                return;
            }
        }
        this.cca.getColumnSortManager().setSorting(column, sortAscending);
    }

    public void setInput(Object input) {
        if (!this.columnsInitialized) {
            this.initColumns(null, null, null, true);
        }
        this.getColumnViewer().setInput(input);
        this.cca.layout();
    }

    @Override
    public boolean setFocus() {
        return this.getColumnControl().setFocus();
    }

    @Override
    public void dispose() {
        this.contextMenu.dispose();
        if (this.columnsContextMenu != null) {
            this.columnsContextMenu.dispose();
        }
        super.dispose();
    }

    protected static class ColumnDef {
        public final String key;
        public final String title;
        public final int style;
        public final boolean isMoveable;
        public final boolean isMandatory;
        public final ColumnData columnLayoutData;
        public final CellLabelProvider labelProvider;
        public final ColumnComparator viewerComparator;
        public final EditingSupport editingSupport;

        public ColumnDef(String key, String title, int style, boolean isMoveable, boolean isMandatory, ColumnData columnLayoutData, CellLabelProvider labelProvider, ColumnComparator viewerComparator, EditingSupport editingSupport) {
            this.key = key;
            this.title = title;
            this.style = style;
            this.isMoveable = isMoveable;
            this.isMandatory = isMandatory;
            this.columnLayoutData = columnLayoutData;
            this.labelProvider = labelProvider;
            this.viewerComparator = viewerComparator;
            this.editingSupport = editingSupport;
        }
    }

    protected class CopyCellTextAction
    extends Action {
        private String cellText;

        public CopyCellTextAction() {
            super("", 1);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
            Point point = ListUIComponent.this.getColumnControl().toControl(Display.getCurrent().getCursorLocation());
            this.update(point);
        }

        public void update(Point point) {
            String columnName = null;
            Item item = ListUIComponent.this.cca.getItem(point);
            if (item != null) {
                int i = 0;
                while (i < ListUIComponent.this.cca.getColumnCount()) {
                    Rectangle rect = ListUIComponent.this.cca.cellGetBounds(item, i);
                    if (rect.contains(point)) {
                        this.cellText = ListUIComponent.this.cca.cellGetText(item, i);
                        columnName = ListUIComponent.this.cca.getColumn(i).getText();
                        break;
                    }
                    ++i;
                }
            }
            if (this.cellText != null && this.cellText.trim().length() > 0) {
                this.setText(ListUIMessages.getFormattedString("ListUIComponent.CopyCellText", columnName, this.cellText));
            } else {
                this.setText(ListUIMessages.getString("ListUIComponent.CopyCellTextNoValue"));
                this.setEnabled(false);
            }
        }

        public void run() {
            if (ListUIComponent.this.clipboard != null) {
                ListUIComponent.this.clipboard.dispose();
            }
            ListUIComponent.this.clipboard = new Clipboard(ListUIComponent.this.getControl().getDisplay());
            ListUIComponent.this.clipboard.setContents(new Object[]{this.cellText}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    protected class RestoreDefaultColumnOrderAction
    extends Action {
        public RestoreDefaultColumnOrderAction() {
            super(ListUIMessages.getString("ListUIComponent.RestoreDefaultColumnOrder"), 1);
        }

        public void run() {
            ListUIComponent.this.restoreDefaultColumnOrder();
        }
    }

    protected class RestoreDefaultColumnWidths
    extends Action {
        public RestoreDefaultColumnWidths() {
            super(ListUIMessages.getString("ListUIComponent.RestoreDefaultColumnWidths"), 1);
        }

        public void run() {
            ListUIComponent.this.cca.getColumnLayout().resetLayout(ListUIComponent.this.cca.getControl());
        }
    }

    protected class ShowAllColumnsAction
    extends Action {
        public ShowAllColumnsAction() {
            super(ListUIMessages.getString("ListUIComponent.ShowAllColumns"), 1);
        }

        public void run() {
            for (String columnKey : ListUIComponent.this.columnDefs.keySet()) {
                ListUIComponent.this.showColumn(columnKey);
            }
        }
    }

    protected class ShowHideColumnAction
    extends Action {
        private String columnKey;

        public ShowHideColumnAction(String columnKey, String columnTitle) {
            super(columnTitle, 2);
            this.columnKey = columnKey;
            this.setChecked(ListUIComponent.this.isColumnShown(columnKey));
            if (ListUIComponent.this.columnDefs.get((Object)columnKey).isMandatory) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (this.isChecked()) {
                ListUIComponent.this.showColumn(this.columnKey);
            } else {
                ListUIComponent.this.hideColumn(this.columnKey);
            }
        }
    }
}

