/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.list;

import de.aristaflow.adept2.ui.util.columnlayout.TableColumnLayout;
import de.aristaflow.adept2.ui.util.columnsort.TableColumnSortManager;
import de.aristaflow.adept2.ui.util.list.ColumnContainerAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class TableAdapter
implements ColumnContainerAdapter {
    private TableViewer tableViewer;
    private Table table;
    private TableColumnLayout tableColumnLayout;
    private TableColumnSortManager tableColumnSortManager;

    public TableAdapter(Composite parent, int style) {
        this.tableViewer = (style & 0x20) > 0 ? CheckboxTableViewer.newCheckList((Composite)parent, (int)style) : new TableViewer(parent, style);
        this.table = this.tableViewer.getTable();
        this.tableColumnLayout = new TableColumnLayout();
        this.table.setLayout((Layout)this.tableColumnLayout);
        this.tableColumnSortManager = new TableColumnSortManager(this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    public Table getControl() {
        return this.table;
    }

    @Override
    public TableColumnLayout getColumnLayout() {
        return this.tableColumnLayout;
    }

    @Override
    public TableColumnSortManager getColumnSortManager() {
        return this.tableColumnSortManager;
    }

    @Override
    public boolean getHeaderVisible() {
        return this.table.getHeaderVisible();
    }

    @Override
    public void setHeaderVisible(boolean show) {
        this.table.setHeaderVisible(show);
    }

    @Override
    public int getColumnCount() {
        return this.table.getColumnCount();
    }

    public TableColumn[] getColumns() {
        return this.table.getColumns();
    }

    public TableColumn getColumn(int index) {
        return this.table.getColumn(index);
    }

    @Override
    public int indexOf(Item column) {
        return this.table.indexOf((TableColumn)column);
    }

    public TableItem getItem(Point point) {
        return this.table.getItem(point);
    }

    @Override
    public int[] getColumnOrder() {
        return this.table.getColumnOrder();
    }

    @Override
    public void setColumnOrder(int[] columnOrder) {
        this.table.setColumnOrder(columnOrder);
    }

    @Override
    public void layout() {
        this.table.layout();
    }

    public TableViewerColumn createColumn(int style, String title, boolean isMovable) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, style);
        TableColumn tableColumn = viewerColumn.getColumn();
        tableColumn.setText(title);
        tableColumn.setMoveable(isMovable);
        return viewerColumn;
    }

    public TableColumn getColumnWidget(ViewerColumn viewerColumn) {
        return ((TableViewerColumn)viewerColumn).getColumn();
    }

    @Override
    public boolean columnGetMoveable(Item column) {
        return ((TableColumn)column).getMoveable();
    }

    @Override
    public void columnSetMoveable(Item column, boolean moveable) {
        ((TableColumn)column).setMoveable(moveable);
    }

    @Override
    public Rectangle itemGetBounds(Item item) {
        return ((TableItem)item).getBounds();
    }

    @Override
    public Rectangle cellGetBounds(Item item, int columnIndex) {
        return ((TableItem)item).getBounds(columnIndex);
    }

    @Override
    public String cellGetText(Item item, int columnIndex) {
        return ((TableItem)item).getText(columnIndex);
    }
}

