/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.list;

import de.aristaflow.adept2.ui.util.columnlayout.TreeColumnLayout;
import de.aristaflow.adept2.ui.util.columnsort.TreeColumnSortManager;
import de.aristaflow.adept2.ui.util.list.ColumnContainerAdapter;
import java.util.Collection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

class TreeAdapter
implements ColumnContainerAdapter {
    private TreeViewer treeViewer;
    private Tree tree;
    private TreeColumnLayout treeColumnLayout;
    private TreeColumnSortManager treeColumnSortManager;

    public TreeAdapter(Composite parent, int style) {
        this.treeViewer = (style & 0x20) > 0 ? new CheckboxTreeViewer(parent, style) : new TreeViewer(parent, style);
        this.tree = this.treeViewer.getTree();
        this.treeColumnLayout = new TreeColumnLayout();
        this.tree.setLayout((Layout)this.treeColumnLayout);
        this.treeColumnSortManager = new TreeColumnSortManager((ColumnViewer)this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Object[]) {
                    return (Object[])inputElement;
                }
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                throw new IllegalArgumentException("The default content provider of the ListUIComponent only supports arrays and collections, found: " + inputElement.getClass());
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                TreeAdapter.this.treeColumnLayout.flushCache((Composite)TreeAdapter.this.tree);
            }

            public void treeExpanded(TreeExpansionEvent event) {
                TreeAdapter.this.treeColumnLayout.flushCache((Composite)TreeAdapter.this.tree);
            }
        });
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public Tree getControl() {
        return this.tree;
    }

    @Override
    public TreeColumnLayout getColumnLayout() {
        return this.treeColumnLayout;
    }

    @Override
    public TreeColumnSortManager getColumnSortManager() {
        return this.treeColumnSortManager;
    }

    @Override
    public boolean getHeaderVisible() {
        return this.tree.getHeaderVisible();
    }

    @Override
    public void setHeaderVisible(boolean show) {
        this.tree.setHeaderVisible(show);
    }

    @Override
    public int getColumnCount() {
        return this.tree.getColumnCount();
    }

    public TreeColumn[] getColumns() {
        return this.tree.getColumns();
    }

    public TreeColumn getColumn(int index) {
        return this.tree.getColumn(index);
    }

    @Override
    public int indexOf(Item column) {
        return this.tree.indexOf((TreeColumn)column);
    }

    public TreeItem getItem(Point point) {
        return this.tree.getItem(point);
    }

    @Override
    public int[] getColumnOrder() {
        return this.tree.getColumnOrder();
    }

    @Override
    public void setColumnOrder(int[] columnOrder) {
        this.tree.setColumnOrder(columnOrder);
    }

    @Override
    public void layout() {
        this.tree.layout();
    }

    public TreeViewerColumn createColumn(int style, String title, boolean isMovable) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.treeViewer, style);
        TreeColumn treeColumn = viewerColumn.getColumn();
        treeColumn.setText(title);
        treeColumn.setMoveable(isMovable);
        return viewerColumn;
    }

    public TreeColumn getColumnWidget(ViewerColumn viewerColumn) {
        return ((TreeViewerColumn)viewerColumn).getColumn();
    }

    @Override
    public boolean columnGetMoveable(Item column) {
        return ((TreeColumn)column).getMoveable();
    }

    @Override
    public void columnSetMoveable(Item column, boolean moveable) {
        ((TreeColumn)column).setMoveable(moveable);
    }

    @Override
    public Rectangle itemGetBounds(Item item) {
        return ((TreeItem)item).getBounds();
    }

    @Override
    public Rectangle cellGetBounds(Item item, int columnIndex) {
        return ((TreeItem)item).getBounds(columnIndex);
    }

    @Override
    public String cellGetText(Item item, int columnIndex) {
        return ((TreeItem)item).getText(columnIndex);
    }
}

