/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.wizard;

import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public abstract class ExtendedWizard
extends Wizard {
    private Map<String, Section> sections = new HashMap<String, Section>();
    private Map<IWizardPage, String> sectionAssignments = new HashMap<IWizardPage, String>();

    protected ExtendedWizard() {
    }

    public void addSection(String id, String title, String tooltip) {
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNull(title, "title");
        if (this.sections.containsKey(id)) {
            throw new IllegalArgumentException(String.format("section ID '%s' already in use", id));
        }
        this.sections.put(id, new Section(id, title, tooltip));
    }

    public void addPage(IWizardPage page, String sectionId) {
        ArgChecks.checkForNull(page, "page");
        ArgChecks.checkForNull(sectionId, "sectionId");
        this.sectionAssignments.put(page, sectionId);
        super.addPage(page);
    }

    public Section getSectionFor(IWizardPage page) {
        String sectionId = this.sectionAssignments.get(page);
        Section section = null;
        if (sectionId != null) {
            section = this.sections.get(sectionId);
        }
        return section;
    }

    public static class Section {
        private final String id;
        private final String title;
        private final String tooltip;

        Section(String id, String title, String tooltip) {
            this.id = id;
            this.title = title;
            this.tooltip = tooltip;
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }
}

