/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.wizard;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public abstract class ExtendedWizardPage
extends WizardPage {
    private boolean isEnabled = true;
    private boolean isLoading = false;
    private boolean isSaving = false;
    private Map<Object, Message> messages = new LinkedHashMap<Object, Message>();
    private ModifyListener autoCommitModifyListener;
    private SelectionListener autoCommitSelectionListener;
    private ISelectionChangedListener autoCommitSelectionChangedListener;

    protected ExtendedWizardPage(String pageName) {
        super(pageName);
    }

    protected ExtendedWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        if (this.getContainer() != null) {
            this.getContainer().updateButtons();
        }
    }

    public boolean isPageComplete() {
        return !this.isEnabled() || super.isPageComplete();
    }

    public boolean canFlipToNextPage() {
        return !this.isEnabled() || super.canFlipToNextPage();
    }

    public void commit() {
        if (!this.isLoading) {
            this.isSaving = true;
            try {
                this.saveData();
                this.updatePageComplete();
            }
            finally {
                this.isSaving = false;
            }
        }
    }

    public void refresh() {
        if (!this.isControlCreated()) {
            return;
        }
        if (!this.isSaving) {
            this.isLoading = true;
            try {
                this.loadData();
                this.updatePageComplete();
            }
            finally {
                this.isLoading = false;
            }
        }
    }

    protected void updatePageComplete() {
    }

    protected abstract void loadData();

    protected abstract void saveData();

    protected void addMessage(Object key, int type, String text) {
        this.messages.put(key, new Message(type, text));
        this.updateMessage();
    }

    protected void removeMessage(Object key) {
        this.messages.remove(key);
        this.updateMessage();
    }

    protected void clearMessages() {
        this.messages.clear();
        this.setMessage(null);
    }

    private void updateMessage() {
        Message mostSevereMsg = null;
        for (Message msg : this.messages.values()) {
            if (mostSevereMsg != null && msg.type <= mostSevereMsg.type) continue;
            mostSevereMsg = msg;
        }
        if (mostSevereMsg == null) {
            this.setMessage(null);
        } else {
            this.setMessage(mostSevereMsg.text, mostSevereMsg.type);
        }
        if (this.getWizard().getContainer().getCurrentPage() != null) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    protected void pageEnter() {
    }

    protected void pageLeave() {
    }

    protected ModifyListener getAutoCommitModifyListener() {
        if (this.autoCommitModifyListener == null) {
            this.autoCommitModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ExtendedWizardPage.this.commit();
                }
            };
        }
        return this.autoCommitModifyListener;
    }

    protected SelectionListener getAutoCommitSelectionListener() {
        if (this.autoCommitSelectionListener == null) {
            this.autoCommitSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ExtendedWizardPage.this.commit();
                }

                public void widgetSelected(SelectionEvent e) {
                    ExtendedWizardPage.this.commit();
                }
            };
        }
        return this.autoCommitSelectionListener;
    }

    protected ISelectionChangedListener getAutoCommitSelectionChangedListener() {
        if (this.autoCommitSelectionChangedListener == null) {
            this.autoCommitSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ExtendedWizardPage.this.commit();
                }
            };
        }
        return this.autoCommitSelectionChangedListener;
    }

    private static class Message {
        private final int type;
        private final String text;

        private Message(int type, String text) {
            this.type = type;
            this.text = text;
        }
    }
}

