/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.util.wizard;

import de.aristaflow.adept2.ui.util.wizard.ExtendedWizard;
import de.aristaflow.adept2.ui.util.wizard.ExtendedWizardPage;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.List;
import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class OverviewWizardDialogue
extends WizardDialog {
    private static final String IMAGE_ARROW = "IMAGE_ARROW";
    private Composite overviewArea;
    private HyperlinkGroup hyperlinkGroup;
    private List<OverviewItem> overviewItems = new ArrayList<OverviewItem>();
    protected ImageRegistry imageReg;

    public OverviewWizardDialogue(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
    }

    protected Control createDialogArea(Composite parent) {
        final Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (e.widget.isDisposed()) {
                    return;
                }
                if ((e.stateMask & 0x10000) != 0 && e.character >= '0' && e.character <= '9') {
                    e.doit = false;
                    int index = e.character > '0' ? e.character - 48 - 1 : 9;
                    if (OverviewWizardDialogue.this.getWizard().getPageCount() > index) {
                        IWizardPage[] pages = OverviewWizardDialogue.this.getWizard().getPages();
                        boolean allowed = true;
                        int i = 0;
                        while (i < index) {
                            if (!pages[i].canFlipToNextPage()) {
                                allowed = false;
                                break;
                            }
                            ++i;
                        }
                        if (allowed) {
                            IWizardPage page = pages[index];
                            OverviewWizardDialogue.this.showPage(page);
                        }
                    }
                }
            }
        };
        this.getShell().getDisplay().addFilter(1, listener);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                e.widget.getDisplay().removeFilter(1, listener);
            }
        });
        this.hyperlinkGroup = new HyperlinkGroup(parent.getDisplay());
        this.hyperlinkGroup.setForeground(null);
        this.hyperlinkGroup.setHyperlinkUnderlineMode(2);
        this.imageReg = new ImageRegistry(parent.getDisplay());
        this.imageReg.put(IMAGE_ARROW, ImageDescriptor.createFromFile(OverviewWizardDialogue.class, (String)"OverviewWizardDialogue_arrow.png"));
        Composite dialogArea = new Composite(parent, 0);
        dialogArea.setLayoutData((Object)new GridData(4, 4, true, true));
        dialogArea.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).spacing(0, 0).create());
        new Label(dialogArea, 258).setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).span(2, 1).create());
        Control wizardPageArea = super.createDialogArea(dialogArea);
        wizardPageArea.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(1, 3).create());
        Control overviewArea = this.createOverviewArea(dialogArea);
        overviewArea.setLayoutData((Object)new GridData(4, 4, false, true));
        new Label(dialogArea, 514).setLayoutData((Object)GridDataFactory.fillDefaults().create());
        new Label(dialogArea, 258).setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).span(2, 1).create());
        this.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                OverviewWizardDialogue.this.updateOverview();
            }
        });
        return dialogArea;
    }

    protected Control createOverviewArea(Composite parent) {
        final FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolkit.dispose();
            }
        });
        Form form = toolkit.createForm(parent);
        form.setText("Overview");
        toolkit.decorateFormHeading(form);
        toolkit.paintBordersFor(form.getBody());
        this.overviewArea = form.getBody();
        this.overviewArea.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.overviewArea.setLayoutData((Object)new GridData(4, 4, false, true));
        this.overviewArea.setLayout((Layout)new MigLayout("wrap", "[][][grow, fill]", "[] 3lp"));
        this.overviewArea.setBackgroundMode(1);
        return form;
    }

    public void updateButtons() {
        IWizardPage[] iWizardPageArray = this.getWizard().getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            page.setPreviousPage(null);
            ++n2;
        }
        super.updateButtons();
        this.updateOverview();
    }

    void updateOverview() {
        boolean currentPageReached = false;
        boolean followingPagesSelectable = true;
        int itemIndex = 0;
        IWizardPage wizardPage = this.getWizard().getStartingPage();
        ExtendedWizard.Section prevSection = null;
        do {
            ExtendedWizard.Section section = null;
            if (this.getWizard() instanceof ExtendedWizard) {
                ExtendedWizard extWiz = (ExtendedWizard)this.getWizard();
                section = extWiz.getSectionFor(wizardPage);
            }
            boolean sectionChanged = prevSection != section;
            OverviewItem item = null;
            if (sectionChanged && section == null) {
                if (itemIndex < this.overviewItems.size()) {
                    item = this.overviewItems.get(itemIndex);
                }
                if (!(item instanceof OverviewSectionEnd)) {
                    while (itemIndex < this.overviewItems.size()) {
                        this.overviewItems.remove(itemIndex).dispose();
                    }
                    item = null;
                }
                if (item == null) {
                    this.overviewItems.add(new OverviewSectionEnd(this.overviewArea));
                    this.overviewArea.layout();
                    itemIndex = Integer.MAX_VALUE;
                } else {
                    ++itemIndex;
                }
            }
            if (sectionChanged && section != null) {
                if (itemIndex < this.overviewItems.size()) {
                    item = this.overviewItems.get(itemIndex);
                }
                if (!(item instanceof OverviewSectionStart)) {
                    while (itemIndex < this.overviewItems.size()) {
                        this.overviewItems.remove(itemIndex).dispose();
                    }
                    item = null;
                }
                if (item == null) {
                    this.overviewItems.add(new OverviewSectionStart(this.overviewArea));
                    this.overviewArea.layout();
                    itemIndex = Integer.MAX_VALUE;
                } else {
                    ++itemIndex;
                }
            }
            if (itemIndex < this.overviewItems.size()) {
                item = this.overviewItems.get(itemIndex);
            }
            if (!(item instanceof OverviewEntry)) {
                while (itemIndex < this.overviewItems.size()) {
                    this.overviewItems.remove(itemIndex).dispose();
                }
                item = null;
            }
            if (item == null) {
                this.overviewItems.add(new OverviewEntry(this.overviewArea));
                this.overviewArea.layout();
                itemIndex = Integer.MAX_VALUE;
            } else {
                ++itemIndex;
            }
            wizardPage = wizardPage.getNextPage();
            prevSection = section;
        } while (wizardPage != null);
        while (itemIndex < this.overviewItems.size()) {
            this.overviewItems.remove(itemIndex).dispose();
        }
        itemIndex = 0;
        int entryIndex = 0;
        wizardPage = this.getWizard().getStartingPage();
        prevSection = null;
        do {
            boolean sectionChanged;
            ExtendedWizard.Section section = null;
            if (this.getWizard() instanceof ExtendedWizard) {
                ExtendedWizard extWiz = (ExtendedWizard)this.getWizard();
                section = extWiz.getSectionFor(wizardPage);
            }
            boolean bl = sectionChanged = prevSection != section;
            if (sectionChanged && section == null) {
                this.overviewItems.get(itemIndex++);
            }
            if (sectionChanged && section != null) {
                OverviewSectionStart start = (OverviewSectionStart)this.overviewItems.get(itemIndex++);
                start.setTitle(section.getTitle());
                start.setToolTipText(section.getTooltip());
            }
            OverviewEntry entry = (OverviewEntry)this.overviewItems.get(itemIndex++);
            ++entryIndex;
            entry.assignWizardPage(wizardPage);
            int messageType = 0;
            String messageText = null;
            if (wizardPage.getErrorMessage() != null) {
                messageType = 3;
                messageText = wizardPage.getErrorMessage();
            } else if (wizardPage.getMessage() != null) {
                if (wizardPage instanceof IMessageProvider) {
                    IMessageProvider mp = (IMessageProvider)wizardPage;
                    messageType = mp.getMessageType();
                } else {
                    messageType = 0;
                }
                messageText = wizardPage.getMessage();
            }
            entry.setMessage(messageType, messageText);
            entry.setText(entryIndex, wizardPage.getTitle());
            String toolTipText = wizardPage.getDescription() == null || wizardPage.getDescription().equals("") ? wizardPage.getTitle() : String.valueOf(wizardPage.getTitle()) + ":\n" + wizardPage.getDescription();
            entry.setToolTipText(toolTipText);
            if (!currentPageReached) {
                if (this.getSelectedPage() == wizardPage) {
                    currentPageReached = true;
                }
                entry.setSelectable(true);
            }
            if (currentPageReached) {
                if (followingPagesSelectable) {
                    entry.setSelectable(true);
                    if (!wizardPage.canFlipToNextPage()) {
                        followingPagesSelectable = false;
                    }
                } else {
                    entry.setSelectable(false);
                }
            }
            if (wizardPage instanceof ExtendedWizardPage) {
                entry.setEnabled(((ExtendedWizardPage)wizardPage).isEnabled());
            }
            entry.setSelected(this.getCurrentPage() == wizardPage);
            wizardPage = wizardPage.getNextPage();
            prevSection = section;
        } while (wizardPage != null);
    }

    protected void backPressed() {
        boolean isEnabled;
        IWizardPage page = this.getCurrentPage();
        do {
            isEnabled = (page = page.getPreviousPage()) instanceof ExtendedWizardPage ? ((ExtendedWizardPage)page).isEnabled() : true;
        } while (page != null && !isEnabled);
        if (page == null) {
            return;
        }
        this.showPage(page);
    }

    protected void nextPressed() {
        boolean isEnabled;
        IWizardPage page = this.getCurrentPage();
        do {
            isEnabled = (page = page.getNextPage()) instanceof ExtendedWizardPage ? ((ExtendedWizardPage)page).isEnabled() : true;
        } while (page != null && !isEnabled);
        if (page == null) {
            return;
        }
        this.showPage(page);
    }

    public void showPage(IWizardPage page) {
        if (page instanceof ExtendedWizardPage && !((ExtendedWizardPage)page).isEnabled()) {
            return;
        }
        super.showPage(page);
        page.setPreviousPage(null);
    }

    public boolean close() {
        if (this.imageReg != null) {
            this.imageReg.dispose();
        }
        return super.close();
    }

    protected void firePageChanging(PageChangingEvent event) {
        super.firePageChanging(event);
        IWizardPage[] iWizardPageArray = this.getWizard().getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage wizardPage = iWizardPageArray[n2];
            if (wizardPage instanceof IPageChangingListener) {
                ((IPageChangingListener)wizardPage).handlePageChanging(event);
            }
            if (wizardPage instanceof ExtendedWizardPage) {
                if (wizardPage == event.getCurrentPage()) {
                    ((ExtendedWizardPage)wizardPage).pageLeave();
                } else if (wizardPage == event.getTargetPage()) {
                    ((ExtendedWizardPage)wizardPage).pageEnter();
                }
            }
            ++n2;
        }
    }

    static class ExtHyperlink
    extends Hyperlink {
        private boolean paintingText = false;
        private Color disabledForeground;

        public ExtHyperlink(Composite parent, int style) {
            super(parent, style);
        }

        public Color getDisabledForeground() {
            return this.disabledForeground;
        }

        public void setDisabledForeground(Color color) {
            this.disabledForeground = color;
        }

        public Color getForeground() {
            if (this.paintingText) {
                return this.getTextColor();
            }
            return super.getForeground();
        }

        public Color getBackground() {
            if (this.paintingText) {
                return this.getTextColor();
            }
            return super.getBackground();
        }

        private Color getTextColor() {
            if (this.isEnabled() || this.disabledForeground == null) {
                return super.getForeground();
            }
            return this.disabledForeground;
        }

        protected void paintText(GC gc, Rectangle bounds) {
            this.paintingText = true;
            super.paintText(gc, bounds);
            this.paintingText = false;
        }
    }

    private class OverviewEntry
    extends OverviewItem {
        private final Label arrowLabel;
        private final Label indexLabel;
        private final ExtHyperlink hyperlink;
        private final ControlDecoration decoration;
        private boolean isSelectable;
        private boolean isEnabled;
        private boolean isSelected;

        public OverviewEntry(Composite parent) {
            this.isSelectable = false;
            this.isEnabled = true;
            this.isSelected = false;
            this.arrowLabel = new Label(parent, 0);
            this.arrowLabel.setImage(OverviewWizardDialogue.this.imageReg.get(OverviewWizardDialogue.IMAGE_ARROW));
            this.indexLabel = new Label(parent, 0);
            this.hyperlink = new ExtHyperlink(parent, 0);
            OverviewWizardDialogue.this.hyperlinkGroup.add((Hyperlink)this.hyperlink);
            this.hyperlink.setText("");
            this.hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    IWizardPage wizardPage = (IWizardPage)e.getHref();
                    wizardPage.getWizard().getContainer().showPage(wizardPage);
                }
            });
            this.hyperlink.setLayoutData("w 0lp:150lp, gapright 10");
            this.decoration = new ControlDecoration((Control)this.hyperlink, 0x1020000);
            this.decoration.setMarginWidth(2);
        }

        public void setSelectable(boolean selectable) {
            this.isSelectable = selectable;
            this.update();
        }

        public void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
            this.update();
        }

        public void setSelected(boolean selected) {
            this.isSelected = selected;
            this.update();
        }

        private void update() {
            this.arrowLabel.setVisible(this.isSelected);
            if (this.isEnabled && this.isSelectable) {
                this.indexLabel.setForeground(null);
                this.hyperlink.setDisabledForeground(null);
                this.hyperlink.setEnabled(!this.isSelected);
            } else {
                Color c = this.hyperlink.getDisplay().getSystemColor(18);
                if (this.isEnabled) {
                    this.indexLabel.setForeground(null);
                } else {
                    this.indexLabel.setForeground(c);
                }
                this.hyperlink.setDisabledForeground(c);
                this.hyperlink.setEnabled(false);
            }
        }

        public void setText(int index, String text) {
            ArgChecks.checkForNull(text, "text");
            this.indexLabel.setText(String.valueOf(index) + ".");
            this.hyperlink.setText(text);
        }

        public void setToolTipText(String toolTipText) {
            this.hyperlink.setToolTipText(toolTipText);
        }

        public void assignWizardPage(IWizardPage wizardPage) {
            this.hyperlink.setHref(wizardPage);
        }

        public void setMessage(int type, String text) {
            if (text == null) {
                this.decoration.hide();
            } else if (type == 3) {
                this.decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
                this.decoration.setDescriptionText(text);
                this.decoration.show();
            } else if (type == 2) {
                this.decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage());
                this.decoration.setDescriptionText(text);
                this.decoration.show();
            } else {
                this.decoration.hide();
            }
        }

        @Override
        void dispose() {
            this.arrowLabel.dispose();
            this.hyperlink.dispose();
            this.decoration.dispose();
        }
    }

    private static abstract class OverviewItem {
        private OverviewItem() {
        }

        abstract void dispose();
    }

    private class OverviewSectionEnd
    extends OverviewItem {
        private Label dummy;
        private Label separator;

        public OverviewSectionEnd(Composite parent) {
            this.dummy = new Label(parent, 0);
            this.dummy.setLayoutData((Object)"spanx, split 2, w 0!, sgy section");
            this.separator = new Label(parent, 258);
            this.separator.setLayoutData((Object)"gapleft 0, growx");
        }

        @Override
        void dispose() {
            this.dummy.dispose();
            this.separator.dispose();
        }
    }

    private class OverviewSectionStart
    extends OverviewItem {
        private Label leftSep;
        private Label label;
        private Label rightSep;

        public OverviewSectionStart(Composite parent) {
            this.leftSep = new Label(parent, 258);
            this.leftSep.setLayoutData((Object)"spanx, split3, growx, w 0:15lp");
            this.label = new Label(parent, 0);
            this.label.setLayoutData((Object)"sgy section");
            this.rightSep = new Label(parent, 258);
            this.rightSep.setLayoutData((Object)"growx, w 0:15lp");
        }

        public void setTitle(String title) {
            this.label.setText(title);
        }

        public void setToolTipText(String text) {
            this.label.setToolTipText(text);
        }

        @Override
        void dispose() {
            this.leftSep.dispose();
            this.label.dispose();
        }
    }
}

