/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util;

import de.aristaflow.adept2.util.LoggerTools;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Adept2ThreadFactory
implements ThreadFactory,
Thread.UncaughtExceptionHandler {
    protected static final AtomicInteger poolNumber = new AtomicInteger(1);
    protected final ThreadGroup group;
    protected final AtomicInteger threadNumber = new AtomicInteger(1);
    protected final String namePrefix;
    protected final long stackSize;
    protected final int priority;
    protected final Logger logger;

    @Deprecated
    public Adept2ThreadFactory(String name) {
        this(name, 0L, null);
    }

    public Adept2ThreadFactory(String name, Logger logger) {
        this(name, 0L, logger);
    }

    @Deprecated
    public Adept2ThreadFactory(String name, long stackSize) {
        this(name, stackSize, 4, null);
    }

    public Adept2ThreadFactory(String name, long stackSize, Logger logger) {
        this(name, stackSize, 4, logger);
    }

    @Deprecated
    public Adept2ThreadFactory(String name, int priority) {
        this(name, 0L, priority, null);
    }

    public Adept2ThreadFactory(String name, int priority, Logger logger) {
        this(name, 0L, priority, logger);
    }

    @Deprecated
    public Adept2ThreadFactory(String name, long stackSize, int priority) {
        this(name, stackSize, priority, null);
    }

    public Adept2ThreadFactory(String name, long stackSize, int priority, Logger logger) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = name;
        this.stackSize = stackSize * 1024L;
        this.priority = priority < 1 ? 1 : (priority > 10 ? 10 : priority);
        this.logger = logger != null ? logger : LoggerTools.getLogger(Adept2ThreadFactory.class);
    }

    @Override
    public Thread newThread(Runnable r) {
        String name = String.format("%1$s-%2$s-thread-%3$s", this.namePrefix, poolNumber.getAndIncrement(), this.threadNumber.getAndIncrement());
        Thread t = new Thread(this.group, r, name, this.stackSize);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        t.setPriority(this.priority);
        t.setUncaughtExceptionHandler(this);
        return t;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        String msg = String.format("An uncaught exception occurred in thread '%s'.", t.getName());
        this.logger.log(Level.SEVERE, msg, e);
    }
}

