/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util;

import de.aristaflow.adept2.util.NullArgumentException;
import de.aristaflow.adept2.util.StackTraceTools;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ArgChecks {
    public static void check(boolean expression, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (expression) {
            String msg = "The parameter '%s' does not have a legal value!";
            ArgChecks.throwIllegalArgumentException(msg, parameterName);
        }
    }

    public static void check(boolean expression, String parameterName, String msg) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (msg == null) {
            throw new NullArgumentException("The parameter 'msg' must not be null!");
        }
        if (expression) {
            ArgChecks.throwIllegalArgumentException(msg, parameterName);
        }
    }

    public static void checkForNull(Object object, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (object == null) {
            String msg = "The parameter '%s' must not be null!";
            ArgChecks.throwNullArgumentException(msg, parameterName);
        }
    }

    public static void checkEnum(Object value, String parameterName, Object ... allowedValues) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (allowedValues == null) {
            throw new NullArgumentException("The parameter 'allowedValues' must not be null!");
        }
        boolean allowed = false;
        Object[] objectArray = allowedValues;
        int n = allowedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object allowedValue = objectArray[n2];
            if (allowedValue == null) {
                if (allowedValue == value) {
                    allowed = true;
                    break;
                }
            } else if (allowedValue.equals(value)) {
                allowed = true;
                break;
            }
            ++n2;
        }
        if (!allowed) {
            String msg = "The parameter '%s' doesn't have one of the allowed values!";
            ArgChecks.throwIllegalArgumentException(msg, parameterName);
        }
    }

    public static void checkForNegative(long number, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (number < 0L) {
            String msg = "The parameter '%s' must not be negative!";
            ArgChecks.throwIllegalArgumentException(msg, parameterName);
        }
    }

    public static void checkForNegative(double number, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (number < 0.0) {
            String msg = "The parameter '%s' must not be negative!";
            ArgChecks.throwIllegalArgumentException(msg, parameterName);
        }
    }

    public static void checkForNonpositive(long number, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (number <= 0L) {
            String msg = "The parameter '%s' must be positive!";
            ArgChecks.throwIllegalArgumentException(msg, parameterName);
        }
    }

    public static void checkForZero(long number, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (number == 0L) {
            String msg = "The parameter '%s' must not be zero!";
            ArgChecks.throwIllegalArgumentException(msg, parameterName);
        }
    }

    public static void checkMinMax(long min, String minParameterName, long max, String maxParameterName) {
        if (minParameterName == null) {
            throw new NullArgumentException("The parameter 'minParameterName' must not be null!");
        }
        if (maxParameterName == null) {
            throw new NullArgumentException("The parameter 'maxParameterName' must not be null!");
        }
        if (min > max) {
            String msg = "The parameter '%s' must not be larger than the parameter '%s'!";
            ArgChecks.throwIllegalArgumentException(msg, minParameterName, maxParameterName);
        }
    }

    public static void checkIndex(long index, long count, String parameterName) {
        if (index < 0L || index >= count) {
            String msg = "The index '%s' is out of bounds: %d, size: %d";
            msg = String.format(msg, parameterName, index, count);
            throw new IndexOutOfBoundsException(msg);
        }
    }

    public static void checkForNulls(Object[] array, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        ArgChecks.checkForNull(array, parameterName);
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object elem = objectArray[n2];
            if (elem == null) {
                String msg = "The array '%s' must not contain null values!";
                ArgChecks.throwIllegalArgumentException(msg, parameterName);
            }
            ++n2;
        }
    }

    public static void checkForEmpty(Object array, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        ArgChecks.checkForNull(array, parameterName);
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("The parameter 'array' must only be used for array types!");
        }
        if (Array.getLength(array) == 0) {
            String msg = "The array '%s' must not have a length of 0!";
            ArgChecks.throwIllegalArgumentException(msg, parameterName);
        }
    }

    public static void checkLength(Object array, int length, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (length < 0) {
            throw new NullArgumentException("The parameter 'length' must not be negative!");
        }
        ArgChecks.checkForNull(array, parameterName);
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("The parameter 'array' must only be used for array types!");
        }
        if (Array.getLength(array) != length) {
            String msg = "The array '%s' must have a length of %d!";
            ArgChecks.throwIllegalArgumentException(msg, parameterName, length);
        }
    }

    public static void checkForEmpty(String string, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        ArgChecks.checkForNull(string, parameterName);
        if (string.length() == 0) {
            String msg = "The string parameter '%s' must not be empty!";
            ArgChecks.throwIllegalArgumentException(msg, parameterName);
        }
    }

    public static void checkForBlank(String string, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        ArgChecks.checkForNull(string, parameterName);
        if (string.trim().length() == 0) {
            String msg = "The string parameter '%s' must not be blank!";
            ArgChecks.throwIllegalArgumentException(msg, parameterName);
        }
    }

    public static void checkForWhitespace(String string, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        ArgChecks.checkForNull(string, parameterName);
        int i = 0;
        while (i < string.length()) {
            if (Character.isWhitespace(string.charAt(i))) {
                String msg = "The string parameter '%s' must not contain any whitespace characters!";
                ArgChecks.throwIllegalArgumentException(msg, new Object[0]);
            }
            ++i;
        }
    }

    public static void checkForNulls(Collection<?> collection, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        ArgChecks.checkForNull(collection, parameterName);
        for (Object elem : collection) {
            if (elem != null) continue;
            String colType = collection instanceof List ? "list" : (collection instanceof Set ? "set" : "collection");
            String msg = "The %s '%s' must not contain null values!";
            ArgChecks.throwIllegalArgumentException(msg, colType, parameterName);
        }
    }

    public static void checkForEmpty(Collection<?> collection, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        ArgChecks.checkForNull(collection, parameterName);
        if (collection.isEmpty()) {
            String msg = "The collection '%s' must not be empty!";
            ArgChecks.throwIllegalArgumentException(msg, parameterName);
        }
    }

    public static void checkSize(Collection<?> collection, int minSize, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (minSize < 0) {
            throw new NullArgumentException("The parameter 'minSize' must not be negative!");
        }
        ArgChecks.checkForNull(collection, parameterName);
        if (collection.size() < minSize) {
            String msg = "The collection '%s' must have at least %d elements!";
            ArgChecks.throwIllegalArgumentException(msg, parameterName, minSize);
        }
    }

    public static void checkForNulls(Map<?, ?> map, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        ArgChecks.checkForNull(map, parameterName);
        ArgChecks.checkForNullKey(map, parameterName);
        ArgChecks.checkForNullValues(map, parameterName);
    }

    public static void checkForNullKey(Map<?, ?> map, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        ArgChecks.checkForNull(map, parameterName);
        if (map.containsKey(null)) {
            String msg = "The map '%s' must not contain a null key!";
            ArgChecks.throwIllegalArgumentException(msg, parameterName);
        }
    }

    public static void checkForNullValues(Map<?, ?> map, String parameterName) {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        ArgChecks.checkForNull(map, parameterName);
        for (Object value : map.values()) {
            if (value != null) continue;
            String msg = "The map '%s' must not contain null values!";
            ArgChecks.throwIllegalArgumentException(msg, parameterName);
        }
    }

    private static void throwIllegalArgumentException(String origMsg, Object ... args) {
        String msg = String.format(origMsg, args);
        IllegalArgumentException ex = new IllegalArgumentException(msg);
        ex.setStackTrace(StackTraceTools.headTrim(ex.getStackTrace(), ArgChecks.class));
        throw ex;
    }

    private static void throwNullArgumentException(String origMsg, String parameterName) {
        String msg = String.format(origMsg, parameterName);
        NullArgumentException ex = new NullArgumentException(msg);
        ex.setStackTrace(StackTraceTools.headTrim(ex.getStackTrace(), ArgChecks.class));
        throw ex;
    }

    private ArgChecks() {
    }
}

