/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.util;

import de.aristaflow.adept2.util.ArgChecks;
import java.lang.reflect.Array;
import java.util.Collection;

public final class ArrayTools {
    public static <T> T[] reverse(T[] array) {
        int i = 0;
        while (i < array.length / 2) {
            T temp = array[i];
            array[i++] = array[array.length - i];
            array[array.length - i] = temp;
        }
        return array;
    }

    public static <T> T[] join(T[] ... arrays) {
        ArgChecks.checkForNulls(arrays, "arrays");
        ArgChecks.checkForEmpty(arrays, "arrays");
        int joinedLength = 0;
        T[][] TArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            T[] array = TArray[n2];
            if (array.getClass() != arrays[0].getClass()) {
                throw new IllegalArgumentException("All arrays must have the same type!");
            }
            joinedLength += array.length;
            ++n2;
        }
        Object[] joinedArray = (Object[])Array.newInstance(arrays[0].getClass().getComponentType(), joinedLength);
        int offset = 0;
        T[][] TArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            T[] array = TArray2[n4];
            System.arraycopy(array, 0, joinedArray, offset, array.length);
            offset += array.length;
            ++n4;
        }
        return joinedArray;
    }

    public static <T> T[] toArray(Collection<T> coll, Class<T> componentType) {
        return coll.toArray((Object[])Array.newInstance(componentType, coll.size()));
    }

    private ArrayTools() {
    }
}

